/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.util;

import com.javaop.util.PersistantMap;
import com.javaop.util.Uniq;
import java.io.File;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.Vector;

public class UserDB {
    private PersistantMap userDB;

    public UserDB(File file) {
        this.userDB = new PersistantMap(file, "User database file.  All lines are name=FLAGS, ensuring that FLAGS are all uppercase.");
    }

    public void addFlag(String string, char c) {
        if (string == null) {
            return;
        }
        c = Character.toUpperCase(c);
        String string2 = this.userDB.getNoWrite(null, string = string.toLowerCase(), "");
        if (string2.length() == 0) {
            this.userDB.set(null, string, c + "");
        } else if (!(string2.indexOf(c) >= 0)) {
            string2 = string2 + c;
            char[] cArray = string2.toCharArray();
            Arrays.sort(cArray);
            string2 = new String(cArray);
            this.userDB.set(null, string, string2);
        }
    }

    public void addFlags(String string, String string2) {
        if (string == null) {
            return;
        }
        for (int i = 0; i < string2.length(); ++i) {
            this.addFlag(string, string2.charAt(i));
        }
    }

    public void removeFlag(String string, char c) {
        if (string == null) {
            return;
        }
        c = Character.toUpperCase(c);
        String string2 = this.userDB.getNoWrite(null, string = string.toLowerCase(), "");
        if (string2.length() > 0) {
            this.userDB.set(null, string, string2.replaceAll(c + "", ""));
        }
        if (this.userDB.getNoWrite(null, string, "").length() == 0) {
            this.userDB.remove(null, string);
        }
    }

    public void removeFlags(String string, String string2) {
        if (string == null) {
            return;
        }
        for (int i = 0; i < string2.length(); ++i) {
            this.removeFlag(string, string2.charAt(i));
        }
    }

    private boolean hasFlag(String string, char c) {
        if (string == null) {
            return c == 'M' || c == 'U';
        }
        if (this.findFlag(string = string.toLowerCase(), c = Character.toUpperCase(c))) {
            return true;
        }
        Enumeration enumeration = this.userDB.propertyNames(null);
        if (enumeration == null) {
            return false;
        }
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string.matches(UserDB.fixPattern(string2)) || !this.findFlag(string2, c)) continue;
            return true;
        }
        return false;
    }

    public String getRawFlags(String string) {
        if (string == null) {
            return "MU";
        }
        string = string.toLowerCase();
        return this.userDB.getNoWrite(null, string, "");
    }

    public String getFlags(String string) {
        Object object;
        if (string == null) {
            return "<local user> => MU (always)";
        }
        string = string.toLowerCase();
        Enumeration enumeration = this.userDB.propertyNames(null);
        StringBuffer stringBuffer = new StringBuffer();
        TreeSet<Character> treeSet = new TreeSet<Character>();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!string.matches(UserDB.fixPattern((String)object))) continue;
            stringBuffer.append((String)object).append(" ");
            String string2 = this.userDB.getNoWrite(null, (String)object, "");
            for (int i = 0; i < string2.length(); ++i) {
                treeSet.add(new Character(string2.charAt(i)));
            }
        }
        if (stringBuffer.length() == 0 || treeSet.size() == 0) {
            return "User " + string + " was not found.";
        }
        stringBuffer.append("=> ");
        object = treeSet.iterator();
        while (object.hasNext()) {
            stringBuffer.append(object.next());
        }
        return stringBuffer.toString();
    }

    public void deleteUser(String string) {
        if (string == null) {
            return;
        }
        string = string.toLowerCase();
        this.userDB.remove(null, string);
    }

    public int getCount() {
        return this.userDB.size(null);
    }

    public boolean hasAny(String string, String string2, boolean bl) {
        if (string != null) {
            string = string.toLowerCase();
        }
        if (bl && !string2.equals("U")) {
            string2 = string2 + "M";
        }
        for (int i = 0; i < string2.length(); ++i) {
            if (!this.hasFlag(string, string2.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public boolean hasAll(String string, String string2) {
        string = string.toLowerCase();
        for (int i = 0; i < string2.length(); ++i) {
            if (this.hasFlag(string, string2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean userExists(String string) {
        if (string == null) {
            return true;
        }
        return this.userDB.getNoWrite(null, string = string.toLowerCase(), "").length() > 0;
    }

    public String[] findAttr(char c) {
        c = Character.toUpperCase(c);
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.userDB.propertyNames(null);
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.userDB.getNoWrite(null, string, "").indexOf(c) < 0) continue;
            vector.add(string);
        }
        if (c == 'M' || c == 'U') {
            vector.add("<local user>");
        }
        return Uniq.uniq(vector);
    }

    public String[] getUserList() {
        Enumeration enumeration = this.userDB.propertyNames(null);
        Vector<String> vector = new Vector<String>();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                vector.add((String)enumeration.nextElement());
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    protected boolean findFlag(String string, char c) {
        String string2 = this.userDB.getNoWrite(null, string, "");
        c = Character.toUpperCase(c);
        return string2 != null && string2.indexOf(c) >= 0;
    }

    private static String fixPattern(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '*') {
                stringBuffer.append(".*");
                continue;
            }
            if (c == '?') {
                stringBuffer.append(".");
                continue;
            }
            if (c == '%') {
                stringBuffer.append("[0-9]");
                continue;
            }
            if (!Character.isLetterOrDigit(c)) {
                stringBuffer.append("\\").append(c);
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString().toLowerCase();
    }

    public static void main(String[] stringArray) throws Exception {
        UserDB userDB = new UserDB(new File("/tmp/blah"));
        userDB.addFlags("test", "ABCD");
    }
}

