/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.util;

public class TimeReader {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;

    public static long stringToTime(String string) throws IllegalArgumentException {
        if (string == null || string.length() < 1) {
            return 0L;
        }
        char c = (string = string.toLowerCase()).charAt(string.length() - 1);
        if (Character.isDigit(c)) {
            try {
                return Long.parseLong(string) * 1000L;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Invalid absolute time specified.  Time must be all in numbers.");
            }
        }
        if ((string = string.substring(0, string.length() - 1)).length() == 0) {
            return 0L;
        }
        long l = Long.parseLong(string);
        if (c == 's') {
            return l * 1000L;
        }
        if (c == 'm') {
            return l * 60000L;
        }
        if (c == 'h') {
            return l * 3600000L;
        }
        if (c == 'd') {
            return l * 86400000L;
        }
        throw new IllegalArgumentException("Invalid time units.  Valid units are D=Days, M=Minutes, H=Hours, S=Seconds");
    }

    public static String timeToString(long l) {
        if (l == 0L) {
            return "0ms";
        }
        long l2 = l / 86400000L;
        long l3 = (l %= 86400000L) / 3600000L;
        long l4 = (l %= 3600000L) / 60000L;
        long l5 = (l %= 60000L) / 1000L;
        l %= 1000L;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(l2 > 0L ? l2 + " day" + (l2 == 1L ? "" : "s") + ", " : "");
        stringBuffer.append(l3 > 0L ? l3 + " hour" + (l3 == 1L ? "" : "s") + ", " : "");
        stringBuffer.append(l4 > 0L ? l4 + " minute" + (l4 == 1L ? "" : "s") + ", " : "");
        stringBuffer.append(l5 + " second" + (l5 == 1L ? "" : "s"));
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        System.out.println(TimeReader.stringToTime("1000"));
        System.out.println(TimeReader.stringToTime("10s"));
        System.out.println(TimeReader.stringToTime("15m"));
        System.out.println(TimeReader.stringToTime("20d"));
        System.out.println(TimeReader.timeToString(TimeReader.stringToTime("1000")));
        System.out.println(TimeReader.timeToString(TimeReader.stringToTime("10s")));
        System.out.println(TimeReader.timeToString(TimeReader.stringToTime("15m")));
        System.out.println(TimeReader.timeToString(TimeReader.stringToTime("20d")));
        System.out.println(TimeReader.timeToString(TimeReader.stringToTime("20d") + TimeReader.stringToTime("15m") + TimeReader.stringToTime("10s")));
    }
}

