/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.util;

import com.javaop.util.StringEncoder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class PersistantMap {
    private final File tempFile = new File(System.getProperty("user.home") + "/.javaop2-tmp-" + Math.random());
    private final File file;
    private final String comment;
    private Hashtable<String, Properties> sections = new Hashtable();
    private long lastUpdate = 0L;

    public PersistantMap(File file, String string) {
        this.file = file;
        this.comment = string;
        this.load();
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        if (this.lastUpdate >= this.file.lastModified()) {
            return;
        }
        PersistantMap persistantMap = this;
        synchronized (persistantMap) {
            try {
                String string;
                Hashtable<String, Properties> hashtable = new Hashtable<String, Properties>();
                Properties properties = new Properties();
                String string2 = "default";
                BufferedReader bufferedReader = new BufferedReader(new FileReader(this.file));
                while ((string = bufferedReader.readLine()) != null) {
                    if ((string = string.trim()).length() == 0 || string.charAt(0) == '#') continue;
                    if (string.matches("\\[.*\\]")) {
                        hashtable.put(string2, properties);
                        properties = new Properties();
                        string2 = string.trim().substring(1, string.length() - 1).toLowerCase();
                        continue;
                    }
                    if (!string.matches(".+=.*")) continue;
                    int n = string.replaceFirst("[^\\\\]=.*", "").length() + 1;
                    String string3 = string.substring(0, n).toLowerCase().replaceAll("\\\\=", "=");
                    String string4 = string.substring(n + 1);
                    properties.setProperty(string3, StringEncoder.decode(string4).toString());
                }
                hashtable.put(string2, properties);
                bufferedReader.close();
                this.sections = hashtable;
                this.lastUpdate = System.currentTimeMillis();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception exception) {
                System.exit(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        PersistantMap persistantMap = this;
        synchronized (persistantMap) {
            try {
                Object[] objectArray = this.sortEnumeration(this.sections.keys());
                this.file.getParentFile().mkdirs();
                PrintWriter printWriter = new PrintWriter(new FileWriter(this.file));
                printWriter.println("# " + this.file.getAbsolutePath());
                printWriter.println("# Also stored  in: " + this.tempFile);
                printWriter.println("# Created on: " + new Date());
                printWriter.println("# By: " + System.getProperty("user.name"));
                printWriter.println("# Comment: " + this.comment);
                for (int i = 0; i < objectArray.length; ++i) {
                    String string = objectArray[i].toString().toLowerCase();
                    Properties properties = this.sections.get(string);
                    printWriter.println();
                    printWriter.println("[" + string + "]");
                    Object[] objectArray2 = this.sortEnumeration(properties.keys());
                    for (int j = 0; j < objectArray2.length; ++j) {
                        printWriter.println(objectArray2[j].toString().toLowerCase().replaceAll("=", "\\\\=") + "=" + StringEncoder.encode(properties.getProperty((String)objectArray2[j])));
                    }
                }
                printWriter.close();
                this.tempFile.renameTo(this.file);
                this.tempFile.delete();
                this.lastUpdate = System.currentTimeMillis();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(1);
            }
        }
    }

    private String fix(String string) {
        return string == null ? "default" : string.toLowerCase();
    }

    private Object[] sortEnumeration(Enumeration enumeration) {
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        Object[] objectArray = vector.toArray();
        Arrays.sort(objectArray);
        return objectArray;
    }

    public void set(String string, String string2, String string3) {
        string = this.fix(string);
        string2 = this.fix(string2);
        this.load();
        Properties properties = this.sections.get(string);
        if (properties == null) {
            properties = new Properties();
        }
        if (string3 == null) {
            properties.remove(string2);
        } else {
            properties.setProperty(string2, string3);
        }
        this.sections.put(string, properties);
        this.save();
    }

    public String getNoWrite(String string, String string2, String string3) {
        string = this.fix(string);
        string2 = this.fix(string2);
        this.load();
        Properties properties = this.sections.get(string);
        if (properties == null) {
            return string3;
        }
        return properties.getProperty(string2, string3);
    }

    public String getWrite(String string, String string2, String string3) {
        string = this.fix(string);
        string2 = this.fix(string2);
        this.load();
        Properties properties = this.sections.get(string);
        if (properties == null) {
            properties = new Properties();
        }
        String string4 = properties.getProperty(string2, null);
        String string5 = properties.getProperty(string2, string3);
        properties.put(string2, string5);
        this.sections.put(string, properties);
        if (string4 == null) {
            this.save();
        }
        return string5;
    }

    public void remove(String string, String string2) {
        string = this.fix(string);
        string2 = this.fix(string2);
        this.load();
        Properties properties = this.sections.get(string);
        if (properties == null) {
            return;
        }
        properties.remove(string2);
        if (properties.size() == 0) {
            this.sections.remove(string);
        }
        this.save();
    }

    public Enumeration propertyNames(String string) {
        string = this.fix(string);
        this.load();
        Properties properties = this.sections.get(string);
        if (properties == null) {
            return null;
        }
        return properties.keys();
    }

    public Enumeration sectionNames() {
        this.load();
        return this.sections.keys();
    }

    public int size(String string) {
        this.load();
        string = this.fix(string);
        Properties properties = this.sections.get(string);
        if (properties == null) {
            return 0;
        }
        return properties.size();
    }

    public int sections() {
        this.load();
        return this.sections.size();
    }

    public boolean contains(String string, String string2) {
        string = this.fix(string);
        string2 = this.fix(string2);
        this.load();
        Properties properties = this.sections.get(string);
        if (properties == null) {
            return false;
        }
        return properties.containsKey(string2);
    }

    public Properties getSection(String string) {
        string = this.fix(string);
        this.load();
        return this.sections.get(string);
    }
}

