/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.util;

import com.javaop.util.Uniq;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class FileManagement {
    public static void addLine(File file, String string) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.println(string);
        printWriter.close();
    }

    public static void removeLine(File file, String string) throws IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        Vector<String> vector = new Vector<String>();
        while ((string2 = bufferedReader.readLine()) != null) {
            if (string2.equalsIgnoreCase(string)) continue;
            vector.add(string2);
        }
        bufferedReader.close();
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, false));
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            printWriter.println((String)enumeration.nextElement());
        }
        printWriter.close();
    }

    public static boolean findLine(File file, String string) throws IOException {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            boolean bl = false;
            while ((string2 = bufferedReader.readLine()) != null && !bl) {
                if (!string2.equalsIgnoreCase(string)) continue;
                bl = true;
            }
            bufferedReader.close();
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    public static void setFile(File file, String[] stringArray) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        for (int i = 0; i < stringArray.length; ++i) {
            printWriter.println(stringArray[i]);
        }
        printWriter.close();
    }

    public static String[] getUniqueLines(File file) throws IOException {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            return new String[0];
        }
        return Uniq.uniq(FileManagement.getFile(file));
    }

    public static Vector<String> getFile(File file) throws IOException {
        String string;
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            return new Vector<String>();
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        Vector<String> vector = new Vector<String>();
        while ((string = bufferedReader.readLine()) != null) {
            vector.add(string);
        }
        bufferedReader.close();
        return vector;
    }

    public static Vector<File> search(File file, String string) {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            return new Vector<File>();
        }
        Vector<File> vector = new Vector<File>();
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    vector.addAll(FileManagement.search(fileArray[i], string));
                    continue;
                }
                if (!fileArray[i].getName().matches(string)) continue;
                vector.add(new File(fileArray[i].getAbsolutePath()));
            }
        } else if (file.exists()) {
            vector.add(file);
        }
        return vector;
    }

    public static void copyFile(File file, File file2) throws IOException {
        Vector<String> vector = FileManagement.getFile(file);
        String[] stringArray = vector.toArray(new String[vector.size()]);
        FileManagement.setFile(file2, stringArray);
    }

    public static void deleteFile(File file) {
        file.delete();
    }
}

