/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.util;

import com.javaop.util.PadString;
import com.javaop.util.PersistantMap;
import com.javaop.util.RelativeFile;
import com.javaop.util.Uniq;
import com.javaop.util.gui.Gui;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ColorConstants {
    public static final char COLOR = '\u8000';
    public static final PersistantMap colors = new PersistantMap(new RelativeFile("_Colors.txt"), "These are the color constants that display on the SwingGUI.  Feel free to modify/play with them.");

    public static String getColor(String string) {
        return '\u8000' + colors.getNoWrite(null, string, "FF00FF");
    }

    public static String removeColors(String string) {
        return string.replaceAll("\u8000......", "");
    }

    public static void showColorEditor() {
        new ColorConstants().new ColorEditor().setVisible(true);
    }

    static {
        colors.getWrite(null, "Timestamp", "FFFFFF");
        colors.getWrite(null, "Me talk name", "00FFFF");
        colors.getWrite(null, "Me talk text", "FFFFFF");
        colors.getWrite(null, "Me talk brackets", "00FFFF");
        colors.getWrite(null, "Blizzard talk name", "00CCFF");
        colors.getWrite(null, "Blizzard talk text", "00CCFF");
        colors.getWrite(null, "Blizzard talk brackets", "FFFFFF");
        colors.getWrite(null, "Op talk name", "FFFFFF");
        colors.getWrite(null, "Op talk text", "FFFFFF");
        colors.getWrite(null, "Op talk brackets", "FFFFFF");
        colors.getWrite(null, "Talk name", "FFFF00");
        colors.getWrite(null, "Talk text", "FFFFFF");
        colors.getWrite(null, "Talk brackets", "FFFF00");
        colors.getWrite(null, "Emote name", "FFFF00");
        colors.getWrite(null, "Emote message", "FFFF00");
        colors.getWrite(null, "Emote brackets", "FFFF00");
        colors.getWrite(null, "Whisper from name", "C0C0C0");
        colors.getWrite(null, "Whisper from message", "C0C0C0");
        colors.getWrite(null, "Whisper from brackets", "C0C0C0");
        colors.getWrite(null, "Whisper to name", "C0C0C0");
        colors.getWrite(null, "Whisper to message", "C0C0C0");
        colors.getWrite(null, "Whisper to brackets", "C0C0C0");
        colors.getWrite(null, "User show name", "00FF00");
        colors.getWrite(null, "User show message", "00FF00");
        colors.getWrite(null, "User show info", "00FF00");
        colors.getWrite(null, "User join name", "00FF00");
        colors.getWrite(null, "User join message", "00FF00");
        colors.getWrite(null, "User join info", "00FF00");
        colors.getWrite(null, "User leave name", "00FF00");
        colors.getWrite(null, "User leave message", "00FF00");
        colors.getWrite(null, "User leave info", "00FF00");
        colors.getWrite(null, "User update name", "00FF00");
        colors.getWrite(null, "User update message", "00FF00");
        colors.getWrite(null, "User update info", "00FF00");
        colors.getWrite(null, "Error", "FF0000");
        colors.getWrite(null, "Error 1 Debug", "009000");
        colors.getWrite(null, "Error 2 Info", "FFD700");
        colors.getWrite(null, "Error 3 Notice", "FF8000");
        colors.getWrite(null, "Error 4 Warning", "FF8000");
        colors.getWrite(null, "Error 5 Error", "FF0000");
        colors.getWrite(null, "Error 6 Critical", "FF0000");
        colors.getWrite(null, "Error 7 Alert", "FF0000");
        colors.getWrite(null, "Error 8 Emergency", "FF0000");
        colors.getWrite(null, "Error unknown event", "0000FF");
        colors.getWrite(null, "Error unknown packet", "0000FF");
        colors.getWrite(null, "Info", "FFFF00");
        colors.getWrite(null, "Broadcast", "FF8000");
        colors.getWrite(null, "Message box", "7FFFD0");
        colors.getWrite(null, "Channel name", "FFFFFF");
        colors.getWrite(null, "Channel text", "00FF00");
        colors.getWrite(null, "Silent message", "00CCFF");
        colors.getWrite(null, "Clan message", "ADFF2F");
        colors.getWrite(null, "Clan emphasize", "FFFF00");
    }

    private class ColorEditor
    extends JFrame
    implements ListSelectionListener,
    WindowListener {
        private static final long serialVersionUID = 1L;
        private final JList list;
        private final JColorChooser chooser;
        private String currentKey;

        public ColorEditor() {
            super("Editing colors");
            this.chooser = new JColorChooser();
            this.currentKey = null;
            String[] stringArray = Uniq.uniq(colors.getSection(null).keys());
            this.list = new JList<String>(stringArray);
            this.list.addListSelectionListener(this);
            this.list.setSelectedIndex(0);
            this.valueChanged(null);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)new JScrollPane(this.list), "West");
            this.getContentPane().add((Component)this.chooser, "Center");
            this.addWindowListener(this);
            this.setDefaultCloseOperation(0);
            this.setSize(570, 330);
            Gui.center(this);
        }

        public void trySave() {
            Color color;
            String string;
            String string2;
            if (this.currentKey != null && !(string2 = colors.getNoWrite(null, this.currentKey, "")).equalsIgnoreCase(string = PadString.padHex((color = this.chooser.getColor()).getRed(), 2) + PadString.padHex(color.getGreen(), 2) + PadString.padHex(color.getBlue(), 2)) && JOptionPane.showConfirmDialog(this, "Save new color?", "Save?", 0) == 0) {
                colors.set(null, this.currentKey, string);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.trySave();
            this.currentKey = (String)this.list.getSelectedValue();
            if (this.currentKey == null) {
                return;
            }
            String string = colors.getNoWrite(null, this.currentKey, "");
            this.chooser.setColor(Color.decode("#" + string));
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.trySave();
            this.dispose();
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }
    }
}

