/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.util;

import com.javaop.util.Buffer;

public class BnetPacket
extends Buffer {
    protected byte code;

    public BnetPacket() {
    }

    public BnetPacket(byte by) {
        this.setCode(by);
    }

    public BnetPacket(BnetPacket bnetPacket) {
        this.addBytes(bnetPacket.getRawBuffer());
        this.code = bnetPacket.code;
    }

    public void setCode(byte by) {
        this.code = by;
    }

    public byte getCode() {
        return this.code;
    }

    @Override
    public byte[] getBytes() {
        byte[] byArray = new byte[this.size()];
        System.arraycopy(super.getBytes(), 0, byArray, 4, this.size() - 4);
        byArray[0] = -1;
        byArray[1] = this.code;
        byArray[2] = (byte)(byArray.length >> 0 & 0xFF);
        byArray[3] = (byte)(byArray.length >> 8 & 0xFF);
        return byArray;
    }

    public byte[] getRawBuffer() {
        return super.getBytes();
    }

    @Override
    public int size() {
        return super.size() + 4;
    }

    @Override
    public String toString() {
        int n;
        int n2;
        byte[] byArray = this.getBytes();
        StringBuffer stringBuffer = new StringBuffer(this.size() * 3 + this.size() + this.size() / 4 + 30);
        stringBuffer.append("Buffer contents:\n");
        for (n2 = 0; n2 < this.size(); ++n2) {
            if (n2 != 0 && n2 % 16 == 0) {
                stringBuffer.append('\t');
                for (n = n2 - 16; n < n2; ++n) {
                    if (byArray[n] < 32 || byArray[n] > 127) {
                        stringBuffer.append('.');
                        continue;
                    }
                    stringBuffer.append((char)byArray[n]);
                }
                stringBuffer.append("\n");
            }
            stringBuffer.append(Integer.toString((byArray[n2] & 0xF0) >> 4, 16) + Integer.toString((byArray[n2] & 0xF) >> 0, 16));
            stringBuffer.append(' ');
        }
        if (n2 != 0 && n2 % 16 != 0) {
            for (n = 0; n < (16 - n2 % 16) * 3; ++n) {
                stringBuffer.append(' ');
            }
        }
        stringBuffer.append('\t');
        for (n = n2 > 0 && n2 % 16 == 0 ? n2 - 16 : n2 - n2 % 16; n2 >= 0 && n < n2; ++n) {
            if (byArray[n] < 32 || byArray[n] > 127) {
                stringBuffer.append('.');
                continue;
            }
            stringBuffer.append((char)byArray[n]);
        }
        stringBuffer.append('\n');
        stringBuffer.append("Length: " + this.size() + '\n');
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        byte[] byArray;
        if (!(object instanceof BnetPacket)) {
            return false;
        }
        BnetPacket bnetPacket = (BnetPacket)object;
        if (bnetPacket.getCode() != this.getCode()) {
            return false;
        }
        byte[] byArray2 = bnetPacket.getBytes();
        if (byArray2.length != (byArray = this.getBytes()).length) {
            return false;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] == byArray[i]) continue;
            return false;
        }
        return true;
    }
}

