/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.pluginmanagers;

import com.javaop.bot.BotCoreStatic;
import com.javaop.bot.JavaOpFileStuff;
import com.javaop.bot.PluginMain;
import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.util.ErrorMessage;
import com.javaop.util.RelativeFile;
import com.javaop.util.Uniq;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.jar.Attributes;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class PluginManager {
    private static Hashtable<String, GenericPluginInterface> allPlugins = new Hashtable();
    private Hashtable<String, GenericPluginInterface> activePlugins = new Hashtable();

    public static void initialize(boolean bl) {
        try {
            int n;
            String[] stringArray = JavaOpFileStuff.getAllPlugins();
            for (n = 0; n < stringArray.length; ++n) {
                PluginManager.loadFile(stringArray[n], bl);
            }
            if (allPlugins.size() == 0) {
                ErrorMessage.error("Unable to find any plugins.\nPlease download the plugin package from \nhttp://javaop.googlecode.com\nand extract them somewhere. You will be prompted to find them.", false);
                try {
                    JFileChooser jFileChooser = new JFileChooser(new RelativeFile(""));
                    jFileChooser.setFileSelectionMode(1);
                    jFileChooser.setDialogTitle("Please choose the folder where the plugins were extracted to (in the future, place all plugins in this folder!)");
                    int n2 = jFileChooser.showOpenDialog(null);
                    if (n2 == 1) {
                        JOptionPane.showMessageDialog(null, "The plugin folder must be selected before the bot can load.");
                        System.exit(1);
                    }
                    JavaOpFileStuff.addPluginPath(jFileChooser.getSelectedFile().getAbsolutePath());
                }
                catch (Throwable throwable) {
                    System.err.print("Unable to find any plugins.  Please enter the path where the plugins can be found --> ");
                    String string = new BufferedReader(new InputStreamReader(System.in)).readLine();
                    JavaOpFileStuff.addPluginPath(string);
                }
                stringArray = JavaOpFileStuff.getAllPlugins();
                for (n = 0; n < stringArray.length; ++n) {
                    PluginManager.loadFile(stringArray[n], bl);
                }
            }
            PluginMain pluginMain = new PluginMain();
            allPlugins.put(((GenericPluginInterface)pluginMain).getName(), pluginMain);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            try {
                JOptionPane.showMessageDialog(null, iOException.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void loadFile(String string, boolean bl) {
        try {
            PluginManager.loadFile(new URL(string), bl);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                PluginManager.loadFile(new URL("jar:file:///" + string + "!/"), bl);
            }
            catch (MalformedURLException malformedURLException2) {
                System.err.println("--> Unable to load plugin: " + string);
                System.out.println(malformedURLException);
                System.out.println(malformedURLException2);
            }
        }
    }

    private static void loadFile(URL uRL, boolean bl) {
        String string = "PluginMain";
        try {
            URL[] uRLArray = new URL[]{uRL};
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            Attributes attributes = jarURLConnection.getMainAttributes();
            if (attributes != null) {
                string = attributes.getValue(Attributes.Name.MAIN_CLASS);
            }
            System.out.println("Loading plugin: " + string);
            Class<?> clazz = uRLClassLoader.loadClass(string);
            GenericPluginInterface genericPluginInterface = (GenericPluginInterface)clazz.newInstance();
            allPlugins.put(genericPluginInterface.getName(), genericPluginInterface);
            if (bl) {
                genericPluginInterface.load(BotCoreStatic.getInstance());
            }
            genericPluginInterface.setGlobalDefaultSettings(BotCoreStatic.getInstance());
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("   --> Load failed (Plugin '" + uRL + "' doesn't have main class: " + string);
            System.err.println(classNotFoundException);
            classNotFoundException.printStackTrace();
        }
        catch (ClassCastException classCastException) {
            System.err.println("   --> Load failed (Plugin '" + uRL + "''s main class doesn't implement PluginInterface");
        }
        catch (Exception exception) {
            System.err.println("Unable to load plugin file: " + uRL);
            exception.printStackTrace();
        }
    }

    public void activatePlugins(PublicExposedFunctions publicExposedFunctions, PluginCallbackRegister pluginCallbackRegister) throws IOException {
        GenericPluginInterface genericPluginInterface;
        Enumeration<GenericPluginInterface> enumeration = allPlugins.elements();
        while (enumeration.hasMoreElements()) {
            try {
                genericPluginInterface = (GenericPluginInterface)enumeration.nextElement().getClass().newInstance();
                publicExposedFunctions.pluginSetDefaultSettings(genericPluginInterface.getName());
                if (!JavaOpFileStuff.isActivePlugin(publicExposedFunctions.getName(), genericPluginInterface.getName())) {
                    if (genericPluginInterface.getName().equalsIgnoreCase("Battle.net Login Plugin")) {
                        publicExposedFunctions.systemMessage(6, "WARNING!!! BATTLE.NET LOGIN PLUGIN IS DISABLED!! BOT WILL NOT WORK");
                    }
                    if (!genericPluginInterface.getName().equalsIgnoreCase("SwingGui")) continue;
                    publicExposedFunctions.systemMessage(7, "WARNING!!! SWING GUI PLUGIN IS DISABLED!");
                    continue;
                }
                System.out.println("Activating plugin: " + genericPluginInterface.getName());
                genericPluginInterface.activate(publicExposedFunctions, pluginCallbackRegister);
                this.activePlugins.put(genericPluginInterface.getName(), genericPluginInterface);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("Unable to load plugin:");
                illegalAccessException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                System.err.println("Unable to load plugin:");
                instantiationException.printStackTrace();
            }
        }
        if (this.activePlugins.size() < 2) {
            enumeration = allPlugins.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    genericPluginInterface = (GenericPluginInterface)enumeration.nextElement().getClass().newInstance();
                    System.out.println("Plugin: " + genericPluginInterface.getName());
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.err.println("Unable to load plugin:");
                    illegalAccessException.printStackTrace();
                }
                catch (InstantiationException instantiationException) {
                    System.err.println("Unable to load plugin:");
                    instantiationException.printStackTrace();
                }
            }
            publicExposedFunctions.systemMessage(7, "It appears that this bot is new. The important plugins have been enabled.  To connect, please select 'Configure' under the 'Settings' menu, click on 'Battle.net Login Plugin', and fill in your username, password, cdkey, and game client. Then, under the 'Connection' menu, choose 'Connect'");
        }
    }

    public void deactivatePlugins(PluginCallbackRegister pluginCallbackRegister) {
        Enumeration<GenericPluginInterface> enumeration = this.activePlugins.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().deactivate(pluginCallbackRegister);
        }
    }

    public static String[] getAllNames() {
        return Uniq.uniq(allPlugins.keys());
    }

    public static GenericPluginInterface getPlugin(String string) {
        return allPlugins.get(string);
    }
}

