/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.plugin_interfaces;

import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.util.Uniq;
import com.javaop.util.gui.PreferencesPanel;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class GenericPluginInterface {
    public abstract void load(StaticExposedFunctions var1);

    public abstract void activate(PublicExposedFunctions var1, PluginCallbackRegister var2);

    public abstract void deactivate(PluginCallbackRegister var1);

    public abstract String getName();

    public abstract String getVersion();

    public abstract String getAuthorName();

    public abstract String getAuthorWebsite();

    public abstract String getAuthorEmail();

    public abstract String getLongDescription();

    public abstract Properties getDefaultSettingValues();

    public abstract Properties getSettingsDescription();

    public abstract JComponent getComponent(String var1, String var2);

    public abstract Properties getGlobalDefaultSettingValues();

    public abstract Properties getGlobalSettingsDescription();

    public abstract JComponent getGlobalComponent(String var1, String var2);

    public Hashtable<String, JComponent> getComponents(Properties properties) {
        String[] stringArray = Uniq.uniq(this.getDefaultSettingValues().keys());
        Hashtable<String, JComponent> hashtable = new Hashtable<String, JComponent>();
        for (int i = 0; i < stringArray.length; ++i) {
            JComponent jComponent = this.getComponent(stringArray[i], properties.getProperty(stringArray[i].toLowerCase()));
            if (jComponent == null) {
                jComponent = new JTextField(properties.getProperty(stringArray[i].toLowerCase()));
            }
            hashtable.put(stringArray[i], jComponent);
        }
        return hashtable;
    }

    public Hashtable<String, JComponent> getGlobalComponents(Properties properties) {
        String[] stringArray = Uniq.uniq(this.getGlobalDefaultSettingValues().keys());
        Hashtable<String, JComponent> hashtable = new Hashtable<String, JComponent>();
        for (int i = 0; i < stringArray.length; ++i) {
            JComponent jComponent = this.getGlobalComponent(stringArray[i], properties.getProperty(stringArray[i].toLowerCase()));
            if (jComponent == null) {
                jComponent = new JTextField(properties.getProperty(stringArray[i].toLowerCase()));
            }
            hashtable.put(stringArray[i], jComponent);
        }
        return hashtable;
    }

    public JPanel getPreferenceImplementation(Properties properties, Properties properties2, Properties properties3, Hashtable<String, JComponent> hashtable) {
        return new PreferencesPanel(properties, properties2, properties3, hashtable);
    }

    public JPanel getGlobalPreferenceImplementation(Properties properties, Properties properties2, Properties properties3, Hashtable<String, JComponent> hashtable) {
        return new PreferencesPanel(properties, properties2, properties3, hashtable);
    }

    public String getFullName() {
        return this.getName() + " v" + this.getVersion();
    }

    public void setDefaultSettings(PublicExposedFunctions publicExposedFunctions) {
        Properties properties = this.getDefaultSettingValues();
        String[] stringArray = Uniq.uniq(properties.keys());
        for (int i = 0; i < stringArray.length; ++i) {
            publicExposedFunctions.getLocalSettingDefault(this.getName(), stringArray[i], properties.getProperty(stringArray[i]));
        }
    }

    public void setGlobalDefaultSettings(StaticExposedFunctions staticExposedFunctions) {
        Properties properties = this.getGlobalDefaultSettingValues();
        String[] stringArray = Uniq.uniq(properties.keys());
        for (int i = 0; i < stringArray.length; ++i) {
            staticExposedFunctions.getGlobalSettingDefault(this.getName(), stringArray[i], properties.getProperty(stringArray[i]));
        }
    }

    public String toString() {
        return "Plugin: " + this.getFullName();
    }
}

