/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.bot;

import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.pluginmanagers.PluginRegistration;
import com.javaop.util.BnetPacket;
import com.javaop.util.ChatMessage;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;

public class Queue {
    private final PublicExposedFunctions out;
    private final PluginRegistration plugins;
    private final TreeSet<ChatMessage> queue = new TreeSet();
    private final Timer timer = new Timer();
    private TimerTask current = null;
    private ChatMessage up = null;

    public Queue(PublicExposedFunctions publicExposedFunctions, PluginRegistration pluginRegistration) {
        this.out = publicExposedFunctions;
        this.plugins = pluginRegistration;
    }

    public synchronized void send(String string, int n) {
        if ((string = this.plugins.queuingText(string)) == null) {
            return;
        }
        this.queue.add(new ChatMessage(string, n));
        this.plugins.queuedText(string);
        this.scheduleNext();
    }

    public synchronized void scheduleNext() {
        String string = null;
        do {
            if (this.up != null) {
                return;
            }
            if (this.queue.size() == 0) {
                return;
            }
            this.up = this.queue.first();
            this.queue.remove(this.up);
        } while ((string = this.plugins.nextInLine(this.up.getText())) == null);
        this.up = new ChatMessage(string, this.up.getPriority());
        long l = this.plugins.getDelay(this.up.getText());
        this.current = new QueueTask();
        this.timer.schedule(this.current, l);
    }

    public synchronized void clear() {
        if (this.current != null) {
            this.current.cancel();
        }
        this.queue.clear();
        this.up = null;
        this.current = null;
    }

    private class QueueTask
    extends TimerTask {
        private QueueTask() {
        }

        @Override
        public void run() {
            try {
                if (Queue.this.out.isLocked()) {
                    Queue.this.out.systemMessage(4, "Output locked; message cancelled:");
                    Queue.this.out.systemMessage(4, Queue.this.up.getText());
                } else {
                    BnetPacket bnetPacket = new BnetPacket(14);
                    bnetPacket.addNTString(Queue.this.up.getText());
                    if (Queue.this.plugins.sendingText(Queue.this.up.getText())) {
                        Queue.this.out.sendPacket(bnetPacket);
                        Queue.this.plugins.sentText(Queue.this.up.getText());
                    }
                }
                Queue.this.up = null;
                Queue.this.scheduleNext();
            }
            catch (IOException iOException) {
                Queue.this.out.systemMessage(5, "Unable to send packet: " + iOException);
            }
        }
    }
}

