/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.bot;

import com.javaop.bot.BotCoreStatic;
import com.javaop.bot.BotManager;
import com.javaop.bot.JavaOpFileStuff;
import com.javaop.bot.PacketThread;
import com.javaop.bot.Queue;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.CommandUsedIllegally;
import com.javaop.exceptions.CommandUsedImproperly;
import com.javaop.exceptions.PluginException;
import com.javaop.pluginmanagers.PluginManager;
import com.javaop.pluginmanagers.PluginRegistration;
import com.javaop.users.UserList;
import com.javaop.util.BnetPacket;
import com.javaop.util.Buffer;
import com.javaop.util.ColorConstants;
import com.javaop.util.PersistantMap;
import com.javaop.util.Splitter;
import com.javaop.util.Uniq;
import com.javaop.util.User;
import com.javaop.util.UserDB;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class BotCore
implements PublicExposedFunctions {
    protected final PersistantMap localSettings;
    protected final UserDB userDB;
    protected final Hashtable<Object, Object> localVariables;
    protected final PluginRegistration callbacks;
    protected final String botname;
    protected final UserList users;
    protected String channelName = "<not logged in>";
    protected final Timer timer;
    protected final Hashtable<TimerTask, JOTimerTask> timerTasks = new Hashtable();
    protected final PluginManager plugins;
    protected PacketThread packetThread = null;
    private boolean running = true;
    private boolean locked = true;
    private final Queue queue;

    public BotCore(String string) throws IOException, PluginException {
        this.botname = string;
        this.users = new UserList();
        this.localVariables = new Hashtable();
        this.callbacks = new PluginRegistration(this);
        this.timer = new Timer();
        this.localSettings = JavaOpFileStuff.getSettings(string);
        this.userDB = JavaOpFileStuff.getUserDB(string);
        this.queue = new Queue(this, this.callbacks);
        if (this.localSettings == null) {
            throw new IOException("Unable to load the settings file for bot " + string);
        }
        if (this.userDB == null) {
            throw new IOException("Unable to load the user database for bot " + string);
        }
        this.plugins = new PluginManager();
        this.plugins.activatePlugins(this, this.callbacks);
        this.callbacks.botInstanceStarting();
        this.systemMessage(3, "Bot '" + string + "' has been started.");
        if (this.getLocalSettingDefault(null, "connect automatically", "false").equalsIgnoreCase("true")) {
            this.connect();
        }
    }

    @Override
    public void sendPacket(Buffer buffer) throws IOException {
        this.checkRunning();
        try {
            if (buffer instanceof BnetPacket) {
                if ((buffer = this.callbacks.processingOutgoingPacket((BnetPacket)buffer)) == null) {
                    return;
                }
                this.callbacks.processedOutgoingPacket((BnetPacket)buffer);
            }
            this.packetThread.send(buffer.getBytes());
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (PluginException pluginException) {
            this.callbacks.pluginException(pluginException);
        }
        catch (Exception exception) {
            this.callbacks.unknownException(exception);
        }
        catch (Error error) {
            this.callbacks.error(error);
        }
    }

    @Override
    public void sendTextPriority(String string, int n) {
        this.checkRunning();
        this.queue.send(string, n);
    }

    @Override
    public void sendText(String string) {
        this.checkRunning();
        this.queue.send(string, 0);
    }

    @Override
    public void sendTextUser(String string, String string2, int n) throws IOException {
        this.checkRunning();
        this.sendTextUserPriority(string, string2, n, 0);
    }

    @Override
    public void sendTextUserPriority(String string, String string2, int n, int n2) throws IOException {
        Vector vector;
        this.checkRunning();
        if (string == null) {
            n = 3;
        }
        if (n == 3) {
            vector = new Vector();
            vector.add(string2);
        } else {
            vector = Splitter.split(string2, true);
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            if (n == 1) {
                this.queue.send(string + ": " + (String)enumeration.nextElement(), n2);
                continue;
            }
            if (n == 2) {
                this.queue.send("" + (String)enumeration.nextElement(), n2);
                continue;
            }
            if (n == 0) {
                this.queue.send("/w " + string + " " + (String)enumeration.nextElement(), n2);
                continue;
            }
            if (n == 3) {
                this.showMessage(ColorConstants.getColor("Silent message") + (String)enumeration.nextElement());
                continue;
            }
            this.systemMessage(5, "Unknown 'loudness' setting for message: " + (String)enumeration.nextElement() + " (loudness was " + n + ")");
        }
    }

    @Override
    public void schedule(TimerTask timerTask, long l) {
        JOTimerTask jOTimerTask = new JOTimerTask(timerTask);
        this.timerTasks.put(timerTask, jOTimerTask);
        this.timer.schedule((TimerTask)jOTimerTask, l, l);
        this.systemMessage(1, "Scheduled timer: " + timerTask + " (every " + l + "ms)");
    }

    @Override
    public void unschedule(TimerTask timerTask) {
        JOTimerTask jOTimerTask = this.timerTasks.get(timerTask);
        if (jOTimerTask != null) {
            jOTimerTask.cancel();
        }
        this.timerTasks.remove(timerTask);
        this.systemMessage(1, "Unscheduled timer: " + timerTask);
    }

    @Override
    public void clearQueue() {
        this.checkRunning();
        this.queue.clear();
    }

    @Override
    public StaticExposedFunctions getStaticExposedFunctionsHandle() {
        return BotCoreStatic.getInstance();
    }

    @Override
    public void setTCPNoDelay(boolean bl) throws IOException {
        this.checkRunning();
        this.packetThread.setTcpNoDelay(bl);
    }

    @Override
    public boolean isLocked() {
        this.checkRunning();
        return this.locked;
    }

    @Override
    public void lock() {
        this.checkRunning();
        this.locked = true;
    }

    @Override
    public void unlock() {
        this.checkRunning();
        this.locked = false;
    }

    @Override
    public void addAlias(String string, String string2) {
        this.callbacks.addAlias(string, string2);
    }

    @Override
    public String[] getAliasesOf(String string) {
        return this.callbacks.getAliasesOf(string);
    }

    @Override
    public String getCommandOf(String string) {
        return this.callbacks.getCommandOf(string);
    }

    @Override
    public void removeAlias(String string) {
        this.callbacks.removeAlias(string);
    }

    @Override
    public void channelSetName(String string) {
        this.checkRunning();
        this.channelName = string;
    }

    @Override
    public String channelGetName() {
        this.checkRunning();
        return this.channelName;
    }

    @Override
    public int channelGetCount() {
        this.checkRunning();
        return this.users.size();
    }

    @Override
    public void channelClear() {
        this.checkRunning();
        this.users.clear();
    }

    @Override
    public User channelAddUser(String string, int n, int n2, String string2) {
        this.checkRunning();
        return this.users.addUser(string, n, n2, string2);
    }

    @Override
    public User channelRemoveUser(String string) {
        this.checkRunning();
        return this.users.removeUser(string);
    }

    @Override
    public User channelGetUser(String string) {
        this.checkRunning();
        return this.users.getUser(string);
    }

    @Override
    public String[] channelGetList() {
        this.checkRunning();
        return this.users.getList();
    }

    @Override
    public String[] channelGetListWithAny(String string) {
        this.checkRunning();
        String[] stringArray = this.channelGetList();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.dbHasAny(stringArray[i], string, false)) continue;
            vector.add(stringArray[i]);
        }
        return vector.toArray(new String[vector.size()]);
    }

    @Override
    public String[] channelGetListWithAll(String string) {
        this.checkRunning();
        String[] stringArray = this.channelGetList();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.dbHasAll(stringArray[i], string)) continue;
            vector.add(stringArray[i]);
        }
        return vector.toArray(new String[vector.size()]);
    }

    @Override
    public String[] channelGetListWithoutAny(String string) {
        this.checkRunning();
        String[] stringArray = this.channelGetList();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.dbHasAny(stringArray[i], string, false)) continue;
            vector.add(stringArray[i]);
        }
        return vector.toArray(new String[vector.size()]);
    }

    @Override
    public String[] channelMatchGetList(String string) {
        this.checkRunning();
        return this.users.matchNames(string);
    }

    @Override
    public String[] channelMatchGetListWithAny(String string, String string2) {
        this.checkRunning();
        String[] stringArray = this.channelMatchGetList(string);
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.dbHasAny(stringArray[i], string2, false)) continue;
            vector.add(stringArray[i]);
        }
        return vector.toArray(new String[vector.size()]);
    }

    @Override
    public String[] channelMatchGetListWithAll(String string, String string2) {
        this.checkRunning();
        String[] stringArray = this.channelMatchGetList(string);
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.dbHasAll(stringArray[i], string2)) continue;
            vector.add(stringArray[i]);
        }
        return vector.toArray(new String[vector.size()]);
    }

    @Override
    public String[] channelMatchGetListWithoutAny(String string, String string2) {
        this.checkRunning();
        String[] stringArray = this.channelMatchGetList(string);
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.dbHasAny(stringArray[i], string2, false)) continue;
            vector.add(stringArray[i]);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void stop() {
        this.checkRunning();
        this.lock();
        try {
            this.callbacks.botInstanceStopping();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.packetThread != null) {
            this.packetThread.stopThread();
        }
        if (this.plugins != null) {
            this.plugins.deactivatePlugins(this.callbacks);
        }
        this.localVariables.clear();
        this.users.clear();
        this.running = false;
    }

    public void killInstance() throws Exception {
        this.checkRunning();
        this.killInstance(this.getName());
    }

    public void killInstance(String string) throws Exception {
        this.checkRunning();
        BotManager.stopBot(string);
    }

    public void startInstance(String string) throws Exception {
        this.checkRunning();
        BotManager.startBot(string);
    }

    public String[] getRunningBots() {
        this.checkRunning();
        return BotManager.getActiveBots();
    }

    public String[] getAllBots() {
        this.checkRunning();
        return BotManager.getAllBots();
    }

    @Override
    public void talk(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.checkRunning();
        this.callbacks.talk(string, string2, n, n2);
    }

    @Override
    public void emote(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.checkRunning();
        this.callbacks.emote(string, string2, n, n2);
    }

    @Override
    public void whisperFrom(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.checkRunning();
        this.callbacks.whisperFrom(string, string2, n, n2);
    }

    @Override
    public void whisperTo(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.checkRunning();
        this.callbacks.whisperTo(string, string2, n, n2);
    }

    @Override
    public void userShow(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.checkRunning();
        this.callbacks.userShow(string, string2, n, n2);
    }

    @Override
    public void userJoin(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.checkRunning();
        this.callbacks.userJoin(string, string2, n, n2);
    }

    @Override
    public void userLeave(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.checkRunning();
        this.callbacks.userLeave(string, string2, n, n2);
    }

    @Override
    public void userFlags(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.checkRunning();
        this.callbacks.userFlags(string, string2, n, n2);
    }

    @Override
    public void error(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.checkRunning();
        this.callbacks.error(string, string2, n, n2);
    }

    @Override
    public void info(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.checkRunning();
        this.callbacks.info(string, string2, n, n2);
    }

    @Override
    public void broadcast(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.checkRunning();
        this.callbacks.broadcast(string, string2, n, n2);
    }

    @Override
    public void channel(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.checkRunning();
        this.callbacks.channel(string, string2, n, n2);
    }

    @Override
    public String getLocalSetting(String string, String string2) {
        this.checkRunning();
        if (string == null) {
            string = " default";
        }
        if (!this.localSettings.contains(string, string2)) {
            this.systemMessage(5, "Attempted to access a missing setting: " + string + " // " + string2);
            return null;
        }
        return this.localSettings.getNoWrite(string, string2, null);
    }

    @Override
    public String getLocalSettingDefault(String string, String string2, String string3) {
        this.checkRunning();
        if (string == null) {
            string = " default";
        }
        return this.localSettings.getWrite(string, string2, string3);
    }

    @Override
    public void putLocalSetting(String string, String string2, String string3) {
        this.checkRunning();
        this.localSettings.set(string, string2, string3);
    }

    @Override
    public void removeLocalSetting(String string, String string2) {
        this.checkRunning();
        this.localSettings.remove(string, string2);
    }

    @Override
    public String[] getLocalKeys(String string) {
        this.checkRunning();
        return Uniq.uniq(this.localSettings.propertyNames(string));
    }

    @Override
    public Properties getLocalSettingSection(String string) {
        return this.localSettings.getSection(string);
    }

    @Override
    public void putLocalVariable(Object object, Object object2) {
        this.checkRunning();
        this.localVariables.put(object, object2);
    }

    @Override
    public Object getLocalVariable(Object object) {
        this.checkRunning();
        return this.localVariables.get(object);
    }

    @Override
    public void dbAddAndRemove(String string, String string2, String string3) {
        this.checkRunning();
        String string4 = this.dbGetRawFlags(string);
        this.userDB.addFlags(string, string2);
        this.userDB.removeFlags(string, string3);
        String string5 = this.dbGetRawFlags(string);
        if (string4 == null || string4.length() == 0) {
            this.callbacks.userAdded(string, string5);
        } else if (string5 == null || string5.length() == 0) {
            this.callbacks.userRemoved(string, string4);
        } else {
            this.callbacks.userChanged(string, string4, string5);
        }
    }

    @Override
    public void dbAddFlags(String string, String string2) {
        this.checkRunning();
        String string3 = this.dbGetRawFlags(string);
        this.userDB.addFlags(string, string2);
        if (string3 == null || string3.length() == 0) {
            this.callbacks.userAdded(string, this.dbGetRawFlags(string));
        } else {
            this.callbacks.userChanged(string, string3, this.dbGetRawFlags(string));
        }
    }

    @Override
    public void dbRemoveFlag(String string, char c) {
        this.checkRunning();
        String string2 = this.dbGetRawFlags(string);
        if (string2 == null || string2.length() == 0) {
            return;
        }
        this.userDB.removeFlag(string, c);
        String string3 = this.dbGetRawFlags(string);
        if (string3 == null || string3.length() == 0) {
            this.callbacks.userRemoved(string, string2);
        } else {
            this.callbacks.userChanged(string, string2, string3);
        }
    }

    @Override
    public void dbRemoveFlags(String string, String string2) {
        this.checkRunning();
        for (int i = 0; i < string2.length(); ++i) {
            this.dbRemoveFlag(string, string2.charAt(i));
        }
    }

    @Override
    public String dbGetRawFlags(String string) {
        this.checkRunning();
        if (string != null && string.equalsIgnoreCase((String)this.getLocalVariable("username"))) {
            return "S";
        }
        return this.userDB.getRawFlags(string);
    }

    @Override
    public String dbGetFlags(String string) {
        this.checkRunning();
        return this.userDB.getFlags(string);
    }

    @Override
    public void dbDeleteUser(String string) {
        this.checkRunning();
        this.userDB.deleteUser(string);
    }

    @Override
    public int dbGetCount() {
        this.checkRunning();
        return this.userDB.getCount();
    }

    @Override
    public boolean dbHasAny(String string, String string2, boolean bl) {
        this.checkRunning();
        if (string != null && string.equalsIgnoreCase((String)this.getLocalVariable("username"))) {
            return string2.indexOf("S") >= 0;
        }
        return this.userDB.hasAny(string, string2, bl);
    }

    @Override
    public boolean dbHasAll(String string, String string2) {
        this.checkRunning();
        if (string != null && string.equalsIgnoreCase((String)this.getLocalVariable("username"))) {
            return string2.equalsIgnoreCase("S");
        }
        return this.userDB.hasAll(string, string2);
    }

    @Override
    public boolean dbUserExists(String string) {
        this.checkRunning();
        if (string != null && string.equalsIgnoreCase((String)this.getLocalVariable("username"))) {
            return true;
        }
        return this.userDB.userExists(string);
    }

    @Override
    public String[] dbFindAttr(char c) {
        this.checkRunning();
        return this.userDB.findAttr(c);
    }

    @Override
    public String[] dbGetAllUsers() {
        return this.userDB.getUserList();
    }

    public PluginRegistration getCallbacks() {
        this.checkRunning();
        return this.callbacks;
    }

    @Override
    public void systemMessage(int n, String string) {
        this.checkRunning();
        this.callbacks.systemMessage(n, string);
    }

    @Override
    public void showMessage(String string) {
        this.checkRunning();
        this.callbacks.showMessage(string);
    }

    @Override
    public void connect() {
        this.checkRunning();
        this.disconnect();
        this.systemMessage(1, "Entering connect()");
        this.packetThread = new PacketThread(this.callbacks, this);
        this.packetThread.start();
    }

    @Override
    public void disconnect() {
        this.checkRunning();
        this.systemMessage(1, "Entering disconnect()");
        if (!this.callbacks.disconnecting()) {
            return;
        }
        this.lock();
        if (this.packetThread != null) {
            this.packetThread.stopThread();
        }
        if (this.callbacks != null) {
            this.callbacks.disconnected();
        }
    }

    @Override
    public void reconnect() {
        this.connect();
    }

    @Override
    public boolean pluginIsActive(String string) {
        return JavaOpFileStuff.isActivePlugin(this.getName(), string);
    }

    @Override
    public void pluginToggleActive(String string) {
        JavaOpFileStuff.toggleActivePlugin(this.getName(), string);
    }

    @Override
    public void pluginSetActive(String string, boolean bl) {
        if (bl && JavaOpFileStuff.isActivePlugin(this.getName(), string)) {
            JavaOpFileStuff.removeActivePlugin(this.getName(), string);
        } else if (!bl && !JavaOpFileStuff.isActivePlugin(this.getName(), string)) {
            JavaOpFileStuff.addActivePlugin(this.getName(), string);
        }
    }

    @Override
    public void pluginSetDefaultSettings(String string) {
        PluginManager.getPlugin(string).setDefaultSettings(this);
        PluginManager.getPlugin(string).setGlobalDefaultSettings(BotCoreStatic.getInstance());
    }

    @Override
    public boolean raiseCommand(String string, String string2, String string3, int n, boolean bl) throws IOException {
        try {
            return this.callbacks.raiseCommand(string, string2, string3, n, bl);
        }
        catch (CommandUsedIllegally commandUsedIllegally) {
            this.exceptionIllegalCommandUsed(string, commandUsedIllegally.getUserFlags(), commandUsedIllegally.getRequiredFlags(), commandUsedIllegally.getCommand());
        }
        catch (CommandUsedImproperly commandUsedImproperly) {
            this.exceptionCommandUsedImproperly(commandUsedImproperly.getUser(), commandUsedImproperly.getCommand(), string2 + " " + string3, commandUsedImproperly.getMessage());
        }
        catch (PluginException pluginException) {
            this.callbacks.pluginException(pluginException);
        }
        catch (Exception exception) {
            this.callbacks.unknownException(exception);
        }
        return true;
    }

    @Override
    public String[] getCommandList() {
        this.checkRunning();
        return this.callbacks.getCommands();
    }

    @Override
    public String getCommandHelp(String string) {
        this.checkRunning();
        return this.callbacks.getHelp(string);
    }

    @Override
    public String getCommandUsage(String string) {
        this.checkRunning();
        return this.callbacks.getUsage(string);
    }

    @Override
    public String getRequiredFlags(String string) {
        return this.callbacks.getRequiredFlags(string);
    }

    @Override
    public boolean canUse(String string, String string2) {
        return this.dbHasAny(string, this.getRequiredFlags(string2), true);
    }

    @Override
    public void exceptionIllegalCommandUsed(String string, String string2, String string3, String string4) {
        this.callbacks.illegalCommandUsed(string, string2, string3, string4);
    }

    @Override
    public void exceptionCommandUsedImproperly(String string, String string2, String string3, String string4) {
        this.callbacks.commandUsedImproperly(string, string2, string3, string4);
    }

    @Override
    public void exceptionUnknownCommandUsed(String string, String string2) {
        this.callbacks.unknownCommandUsed(string, string2);
    }

    @Override
    public void addMenuItem(String string, String string2, char c, ActionListener actionListener) {
        this.addMenuItem(string, string2, -1, c, null, null, actionListener);
    }

    @Override
    public void addMenuItem(String string, String string2, int n, char c, KeyStroke keyStroke, Icon icon, ActionListener actionListener) {
        this.callbacks.menuItemAdded(string, string2, n, c, keyStroke, icon, actionListener);
    }

    @Override
    public void removeMenuItem(String string, String string2) {
        this.callbacks.menuItemRemoved(string, string2);
    }

    @Override
    public void addMenuSeparator(String string) {
        this.callbacks.menuSeparatorAdded(string);
    }

    @Override
    public void addMenu(String string, char c, ActionListener actionListener) {
        this.addMenu(string, -1, c, null, actionListener);
    }

    @Override
    public void addMenu(String string, int n, char c, Icon icon, ActionListener actionListener) {
        this.callbacks.menuAdded(string, n, c, icon, actionListener);
    }

    @Override
    public void removeMenu(String string) {
        this.callbacks.menuRemoved(string);
    }

    @Override
    public void addUserMenu(String string, ActionListener actionListener) {
        this.addUserMenu(string, -1, null, actionListener);
    }

    @Override
    public void addUserMenu(String string, int n, Icon icon, ActionListener actionListener) {
        this.callbacks.userMenuAdded(string, n, icon, actionListener);
    }

    @Override
    public void removeUserMenu(String string) {
        this.callbacks.userMenuRemoved(string);
    }

    @Override
    public void addUserMenuSeparator() {
        this.callbacks.userMenuSeparatorAdded();
    }

    private void checkRunning() {
        if (!this.running) {
            throw new Error("Attempting to use a stopped bot instance!");
        }
    }

    @Override
    public String getName() {
        this.checkRunning();
        return this.botname;
    }

    private class JOTimerTask
    extends TimerTask {
        private final TimerTask realTimerTask;

        public JOTimerTask(TimerTask timerTask) {
            this.realTimerTask = timerTask;
        }

        @Override
        public void run() {
            if (!BotCore.this.locked) {
                this.realTimerTask.run();
            }
        }
    }
}

