/*
 * Decompiled with CFR 0.152.
 */
package com.javaop._main;

import com.javaop.bot.JavaOpFileStuff;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.pluginmanagers.PluginManager;
import com.javaop.util.PersistantMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class CommandlineConfigure {
    private static final boolean CLEAR = true;
    private static BufferedReader in = new BufferedReader(new InputStreamReader(System.in));

    public static void main(String[] stringArray) throws IOException {
        JavaOpFileStuff.setBaseDirectory();
        PluginManager.initialize(false);
        while (true) {
            CommandlineConfigure.clear();
            System.out.println("1. Configure paths searched for plugins");
            System.out.println("2. Configure which bots are loaded");
            System.out.println("3. Manage bots");
            System.out.println("4. Add a new bot");
            System.out.println("5. Copy a bot");
            System.out.println("6. Remove a bot");
            System.out.println();
            System.out.println("0. Quit");
            System.out.println();
            int n = Integer.parseInt(CommandlineConfigure.getPatternInput("Please make a selection", null, "[1234560]"));
            if (n == 1) {
                CommandlineConfigure.configurePaths();
                continue;
            }
            if (n == 2) {
                CommandlineConfigure.configureLoadedBots();
                continue;
            }
            if (n == 3) {
                CommandlineConfigure.manageBots();
                continue;
            }
            if (n == 4) {
                CommandlineConfigure.addBot();
                continue;
            }
            if (n == 5) {
                CommandlineConfigure.copyBot();
                continue;
            }
            if (n == 6) {
                CommandlineConfigure.removeBot();
                continue;
            }
            if (n != 0) continue;
            System.out.println("-- exiting");
            System.exit(0);
        }
    }

    private static void addBot() throws IOException {
        CommandlineConfigure.clear();
        System.out.println("The current bots:");
        CommandlineConfigure.getAndPrintAllBots(false);
        System.out.println();
        String string = CommandlineConfigure.getPatternInput("Name of the new bot?", null, "[a-zA-Z1-9. -_]+");
        JavaOpFileStuff.newBot(string);
        JavaOpFileStuff.setActivePlugins(string, PluginManager.getAllNames());
    }

    private static void copyBot() throws IOException {
        CommandlineConfigure.clear();
        System.out.println("The current bots:");
        String[] stringArray = CommandlineConfigure.getAndPrintAllBots(true);
        System.out.println();
        System.out.println("0. Back");
        System.out.println();
        int n = CommandlineConfigure.getNumericInput("Which bot are we making a copy of?", null, stringArray.length);
        if (n == 0) {
            return;
        }
        String string = CommandlineConfigure.getPatternInput("What would you like to name the copy?", null, "[a-zA-Z1-9. -_]+");
        JavaOpFileStuff.copyBot(stringArray[n - 1], string);
    }

    private static void removeBot() throws IOException {
        CommandlineConfigure.clear();
        System.out.println("The current bots:");
        String[] stringArray = CommandlineConfigure.getAndPrintAllBots(true);
        System.out.println();
        System.out.println("0. Back");
        System.out.println();
        int n = CommandlineConfigure.getNumericInput("Which bot would you like to remove?", null, stringArray.length);
        if (n == 0) {
            return;
        }
        JavaOpFileStuff.deleteBot(stringArray[n - 1]);
    }

    private static void configurePaths() throws IOException {
        int n;
        do {
            String[] stringArray;
            CommandlineConfigure.clear();
            System.out.println("Current paths are:");
            CommandlineConfigure.getAndPrintPluginPaths(false);
            System.out.println();
            System.out.println();
            System.out.println("1. Add path");
            System.out.println("2. Remove path");
            System.out.println();
            System.out.println("0. Back");
            System.out.println();
            n = Integer.parseInt(CommandlineConfigure.getPatternInput("Please make a selection", null, "[120]"));
            if (n == 1) {
                stringArray = CommandlineConfigure.getPatternInput("Please enter the full path", null, ".+");
                JavaOpFileStuff.addPluginPath((String)stringArray);
                continue;
            }
            if (n != 2) continue;
            stringArray = CommandlineConfigure.getAndPrintPluginPaths(true);
            int n2 = CommandlineConfigure.getNumericInput("Which bot?", null, stringArray.length);
            JavaOpFileStuff.removePluginPath(stringArray[n2 - 1]);
        } while (n != 0);
    }

    private static void configureLoadedBots() throws IOException {
        block4: while (true) {
            CommandlineConfigure.clear();
            System.out.println("The bots currently loading at startup:");
            CommandlineConfigure.getAndPrintDefaultBots(false);
            System.out.println();
            System.out.println();
            System.out.println("1. Add bot");
            System.out.println("2. Remove bot");
            System.out.println();
            System.out.println("0. Back");
            System.out.println();
            int n = Integer.parseInt(CommandlineConfigure.getPatternInput("Please make a selection", null, "[120]"));
            switch (n) {
                case 1: {
                    String[] stringArray = CommandlineConfigure.getAndPrintAllBots(true);
                    int n2 = CommandlineConfigure.getNumericInput("Which would you like to load at startup?", null, stringArray.length);
                    JavaOpFileStuff.addDefaultBot(stringArray[n2 - 1]);
                    continue block4;
                }
                case 2: {
                    String[] stringArray = CommandlineConfigure.getAndPrintDefaultBots(true);
                    int n3 = CommandlineConfigure.getNumericInput("Which bot would you like to remove?", null, stringArray.length);
                    JavaOpFileStuff.removeDefaultBot(stringArray[n3 - 1]);
                }
            }
            break;
        }
    }

    private static void manageBots() throws IOException {
        while (true) {
            CommandlineConfigure.clear();
            String[] stringArray = CommandlineConfigure.getAndPrintAllBots(true);
            System.out.println();
            System.out.println("0. Back");
            System.out.println();
            int n = CommandlineConfigure.getNumericInput("Please choose a bot", null, stringArray.length);
            if (n == 0) {
                return;
            }
            CommandlineConfigure.manageBot(stringArray[n - 1]);
        }
    }

    private static void manageBot(String string) throws IOException {
        block0: while (true) {
            GenericPluginInterface genericPluginInterface;
            int n;
            String[] stringArray;
            CommandlineConfigure.clear();
            System.out.println("Editing: " + string);
            System.out.println();
            System.out.println("1. Enable a plugin");
            System.out.println("2. Disable a plugin");
            System.out.println("3. Enable all plugins");
            System.out.println("4. Disable all plugins");
            System.out.println("5. Configure a plugin");
            System.out.println("6. Get information on a plugin");
            System.out.println();
            System.out.println("0. Back");
            System.out.println();
            int n2 = Integer.parseInt(CommandlineConfigure.getPatternInput("Please make a selection", null, "[1234560]"));
            if (n2 == 1) {
                stringArray = CommandlineConfigure.getAndPrintAllPlugins(true);
                if (stringArray.length == 0) {
                    System.out.println("(all plugins are being loaded already)");
                }
                System.out.println();
                System.out.println("0. Back");
                System.out.println();
                n = CommandlineConfigure.getNumericInput("Please select a plugin to add", null, stringArray.length);
                if (n == 0) continue;
                JavaOpFileStuff.addActivePlugin(string, stringArray[n - 1]);
                continue;
            }
            if (n2 == 2) {
                stringArray = CommandlineConfigure.getAndPrintAllActivePlugins(string, true);
                if (stringArray.length == 0) {
                    System.out.println("(no plugins are being loaded yet)");
                }
                System.out.println();
                System.out.println("0. Back");
                System.out.println();
                n = CommandlineConfigure.getNumericInput("Please select a plugin to remove", null, stringArray.length);
                if (n == 0) continue;
                JavaOpFileStuff.removeActivePlugin(string, stringArray[n - 1]);
                continue;
            }
            if (n2 == 3) {
                JavaOpFileStuff.setActivePlugins(string, PluginManager.getAllNames());
                continue;
            }
            if (n2 == 4) {
                JavaOpFileStuff.setActivePlugins(string, new String[0]);
                continue;
            }
            if (n2 == 5) {
                stringArray = CommandlineConfigure.getAndPrintAllPlugins(true);
                System.out.println();
                System.out.println("0, Back");
                System.out.println();
                n = CommandlineConfigure.getNumericInput("Please select a plugin to configure", null, stringArray.length);
                if (n == 0) continue;
                genericPluginInterface = PluginManager.getPlugin(stringArray[--n]);
                Properties properties = genericPluginInterface.getDefaultSettingValues();
                Properties properties2 = genericPluginInterface.getSettingsDescription();
                PersistantMap persistantMap = JavaOpFileStuff.getSettings(string);
                String string2 = genericPluginInterface.getName();
                Object[] objectArray = CommandlineConfigure.sortEnumeration(properties.keys());
                int n3 = 0;
                while (true) {
                    if (n3 >= objectArray.length) continue block0;
                    CommandlineConfigure.clear();
                    String string3 = persistantMap.getNoWrite(string2, (String)objectArray[n3], properties.getProperty((String)objectArray[n3]));
                    System.out.println();
                    System.out.println(objectArray[n3] + ":");
                    System.out.println("Default setting: " + properties.getProperty((String)objectArray[n3]));
                    System.out.println("Current setting: " + string3);
                    System.out.println("Description: " + properties2.getProperty((String)objectArray[n3]));
                    System.out.println();
                    persistantMap.set(genericPluginInterface.getName(), (String)objectArray[n3], CommandlineConfigure.getPatternInput("New value?", string3, ".*"));
                    ++n3;
                }
            }
            if (n2 == 6) {
                stringArray = CommandlineConfigure.getAndPrintAllPlugins(true);
                if (stringArray.length == 0) {
                    System.out.println("(no plugins are being loaded yet)");
                }
                System.out.println();
                System.out.println("0. Back");
                System.out.println();
                n = CommandlineConfigure.getNumericInput("Please select a plugin to get info on", null, stringArray.length);
                if (n == 0) continue;
                genericPluginInterface = PluginManager.getPlugin(stringArray[--n]);
                CommandlineConfigure.clear();
                System.out.println("Name: " + genericPluginInterface.getFullName());
                System.out.println();
                System.out.println("Author: " + genericPluginInterface.getAuthorName() + " <" + genericPluginInterface.getAuthorEmail() + ">");
                System.out.println();
                System.out.println("Website: " + genericPluginInterface.getAuthorWebsite());
                System.out.println();
                System.out.println("Description: " + genericPluginInterface.getLongDescription());
                System.out.println();
                System.out.println("Press enter to continue...");
                System.in.read();
                continue;
            }
            if (n2 == 0) break;
        }
    }

    private static int getNumericInput(String string, String string2, int n) {
        int n2;
        while ((n2 = Integer.parseInt(CommandlineConfigure.getPatternInput(string + " (an integer 0 and " + n + ")", string2, "[0-9]+"))) > n) {
            System.out.println("Error: invalid value");
        }
        return n2;
    }

    private static String getPatternInput(String string, String string2, String string3) {
        while (true) {
            try {
                while (true) {
                    System.out.print(string + (string2 == null ? "" : " [" + string2 + "]") + " --> ");
                    String string4 = in.readLine();
                    if (string4.equals("") && string2 != null) {
                        return string2;
                    }
                    if (string4.matches(string3)) {
                        return string4;
                    }
                    System.out.println("Error, please enter a valid value");
                }
            }
            catch (IOException iOException) {
                System.err.println("This should never happen");
                iOException.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static void clear() {
        System.out.println("Yes, this is a crappy way to clear; but it's the only easy platform independant one, and Windows doesn't support ANSI by default, so shush.");
        for (int i = 0; i < 100; ++i) {
            System.out.println();
        }
    }

    private static String[] getAndPrintPluginPaths(boolean bl) throws IOException {
        String[] stringArray = JavaOpFileStuff.getRawPluginPaths();
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println((bl ? i + 1 + ". " : "* ") + stringArray[i]);
        }
        return stringArray;
    }

    private static String[] getAndPrintDefaultBots(boolean bl) throws IOException {
        String[] stringArray = JavaOpFileStuff.getDefaultBots();
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println((bl ? i + 1 + ". " : "* ") + stringArray[i]);
        }
        return stringArray;
    }

    private static String[] getAndPrintAllBots(boolean bl) throws IOException {
        String[] stringArray = JavaOpFileStuff.getAllBots();
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println((bl ? i + 1 + ". " : "* ") + stringArray[i]);
        }
        return stringArray;
    }

    private static String[] getAndPrintAllPlugins(boolean bl) throws IOException {
        String[] stringArray = PluginManager.getAllNames();
        for (int i = 0; i < stringArray.length - 1; ++i) {
            System.out.println((bl ? i + 1 + ". " : "* ") + stringArray[i]);
        }
        return stringArray;
    }

    private static String[] getAndPrintAllActivePlugins(String string, boolean bl) throws IOException {
        String[] stringArray = JavaOpFileStuff.getActivePlugins(string);
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println((bl ? i + 1 + ". " : "* ") + stringArray[i]);
        }
        return stringArray;
    }

    private static Object[] sortEnumeration(Enumeration<Object> enumeration) {
        Vector<Object> vector = new Vector<Object>();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        Object[] objectArray = vector.toArray();
        Arrays.sort(objectArray);
        return objectArray;
    }
}

