/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.Moderation;

import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.CommandUsedIllegally;
import com.javaop.exceptions.CommandUsedImproperly;
import com.javaop.plugin_interfaces.CommandCallback;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JComponent;

public class PluginMain
extends GenericPluginInterface
implements CommandCallback {
    private PublicExposedFunctions pubFuncs;

    public void load(StaticExposedFunctions staticExposedFunctions) {
    }

    public void activate(PublicExposedFunctions publicExposedFunctions, PluginCallbackRegister pluginCallbackRegister) {
        this.pubFuncs = publicExposedFunctions;
        String string = publicExposedFunctions.getLocalSettingDefault(this.getName(), "S can be banned/kicked by", "N");
        String string2 = publicExposedFunctions.getLocalSettingDefault(this.getName(), "F can be banned/kicked by", "ON");
        String string3 = publicExposedFunctions.getLocalSettingDefault(this.getName(), "Anybody else can be banned/kicked by", "ON");
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "banf", 2, true, string3, "<user> [message]", "Bans the requested user from the channel, as long as they don't have F or S flags.", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "ban", 2, true, string2, "<user> [message]", "Bans the requested user from the channel, as long as they don't have the S flag.", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "banz", 2, true, string, "<user> [message]", "Bans the requested user from the channel, regardless of which flags they have.", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "kickf", 2, true, string3, "<user> [message]", "Kicks the requested user from the channel, as long as they don't have F or S flags.", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "kick", 2, true, string2, "<user> [message]", "Kicks the requested user from the channel, as long as they don't have the S flag.", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "kickz", 2, true, string, "<user> [message]", "Kicks the requested user from the channel, regardless of which flags they have.", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "unban", 0, true, string2, "<users[s]>", "Unbans the requested user.", null);
        publicExposedFunctions.addAlias("ban", "b");
        publicExposedFunctions.addAlias("kick", "k");
        publicExposedFunctions.addAlias("banf", "bf");
        publicExposedFunctions.addAlias("kickf", "kf");
        publicExposedFunctions.addAlias("banz", "bz");
        publicExposedFunctions.addAlias("kickz", "kz");
        publicExposedFunctions.addAlias("unban", "u");
    }

    public void deactivate(PluginCallbackRegister pluginCallbackRegister) {
    }

    public String getName() {
        return "Moderation";
    }

    public String getVersion() {
        return "2.1.3";
    }

    public String getAuthorName() {
        return "iago";
    }

    public String getAuthorWebsite() {
        return "www.javaop.com";
    }

    public String getAuthorEmail() {
        return "iago@valhallalegends.com";
    }

    public String getShortDescription() {
        return "Basic channel moderation commands";
    }

    public String getLongDescription() {
        return "This includes the various basic moderation commands, such as kick and ban.  The flags required to use the various bans/kicks are configurable, so you can set up who can ban who in your clan.";
    }

    public Properties getDefaultSettingValues() {
        Properties properties = new Properties();
        properties.setProperty("S can be banned/kicked by", "N");
        properties.setProperty("F can be banned/kicked by", "ON");
        properties.setProperty("Anybody else can be banned/kicked by", "ON");
        properties.setProperty("Flags to ban outside the channel", "N");
        return properties;
    }

    public Properties getSettingsDescription() {
        Properties properties = new Properties();
        properties.setProperty("S can be banned/kicked by", "The flag or choice of flags required to ban or kick somebody with the \"S\" flag.  The command to do this is .banz, which can ban anybody.  Bot must be restarted for some changes.");
        properties.setProperty("F can be banned/kicked by", "The flag or choice of flags required to ban or kick somebody with the \"F\" flag.  The command to do this is .ban, which can ban anybody without S.  Bot must be restarted for some changes.");
        properties.setProperty("Anybody else can be banned/kicked by", "The flag or flags required to ban or kick anybody else.  The command to do this is .banf, which bans anybody without F. Bot must be restarted for some changes.");
        properties.setProperty("Flags to ban outside the channel", "The flag required to ban people outside the channel.  BE AWARE that this is unsafe, because it lets you override safelist, and ban, say, iago@uswest");
        return properties;
    }

    public JComponent getComponent(String string, String string2) {
        return null;
    }

    public Properties getGlobalDefaultSettingValues() {
        Properties properties = new Properties();
        return properties;
    }

    public Properties getGlobalSettingsDescription() {
        Properties properties = new Properties();
        return properties;
    }

    public JComponent getGlobalComponent(String string, String string2) {
        return null;
    }

    public void commandExecuted(String string, String string2, String[] stringArray, int n, Object object) throws IOException, CommandUsedImproperly, CommandUsedIllegally {
        block14: {
            block13: {
                if (stringArray.length == 0 || stringArray[0].length() == 0) {
                    throw new CommandUsedImproperly("All ban and kick commands require at least one parameter", string, string2);
                }
                if (!string2.toLowerCase().matches("ban.*") && !string2.toLowerCase().matches("kick.*")) break block13;
                String string3 = stringArray[0];
                string3 = string3.split(",")[0];
                String string4 = stringArray.length > 1 ? stringArray[1] : "";
                String[] stringArray2 = new String[]{};
                if (this.pubFuncs.dbHasAny(string, this.pubFuncs.getLocalSettingDefault(this.getName(), "Flags to ban outside the channel", "N"), true) && string3.indexOf(42) < 0 && string3.indexOf(63) < 0) {
                    stringArray2 = new String[]{string3};
                } else if (string2.equalsIgnoreCase("banz") || string2.equalsIgnoreCase("kickz")) {
                    stringArray2 = this.pubFuncs.channelMatchGetListWithoutAny(string3, "M");
                } else if (string2.equalsIgnoreCase("ban") || string2.equalsIgnoreCase("kick")) {
                    stringArray2 = this.pubFuncs.channelMatchGetListWithoutAny(string3, "MS");
                } else if (string2.equalsIgnoreCase("banf") || string2.equalsIgnoreCase("kickf")) {
                    stringArray2 = this.pubFuncs.channelMatchGetListWithoutAny(string3, "FMS");
                }
                if (stringArray2.length == 0) {
                    this.pubFuncs.sendTextUser(string, "No possible bans found.", 50);
                    return;
                }
                for (int i = 0; i < stringArray2.length; ++i) {
                    this.allowedToBan(string, stringArray2[i]);
                    if (string2.equalsIgnoreCase("ban") || string2.equalsIgnoreCase("banf") || string2.equalsIgnoreCase("banz")) {
                        this.pubFuncs.sendTextPriority("/ban " + stringArray2[i] + " " + string4, 100);
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("kick") && !string2.equalsIgnoreCase("kickf") && !string2.equalsIgnoreCase("kickz")) continue;
                    this.pubFuncs.sendTextPriority("/kick " + stringArray2[i] + " " + string4, 50);
                }
                break block14;
            }
            if (!string2.equalsIgnoreCase("unban")) break block14;
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].indexOf(42) >= 0 || stringArray[i].indexOf(63) >= 0) {
                    if (bl) continue;
                    this.pubFuncs.sendTextUser(string, "Sorry, can't unban by pattern yet (" + stringArray[i] + ")", n);
                    bl = true;
                    continue;
                }
                this.pubFuncs.sendTextPriority("/unban " + stringArray[i], 50);
            }
        }
    }

    private void allowedToBan(String string, String string2) throws CommandUsedIllegally {
        if (this.pubFuncs.dbHasAny(string2, "M", true)) {
            throw new CommandUsedIllegally("M can't be banned", string, "ban/kick", this.pubFuncs.dbGetFlags(string), "N/A");
        }
        String string3 = this.pubFuncs.getLocalSettingDefault(this.getName(), "S can be banned/kicked by", "N");
        if (this.pubFuncs.dbHasAny(string2, "S", true) && !this.pubFuncs.dbHasAny(string, string3, true)) {
            throw new CommandUsedIllegally("Illegally tried to ban a Safelisted user", string, "ban/kick", this.pubFuncs.dbGetFlags(string), string3);
        }
        String string4 = this.pubFuncs.getLocalSettingDefault(this.getName(), "F can be banned/kicked by", "ON");
        if (this.pubFuncs.dbHasAny(string2, "F", true) && !this.pubFuncs.dbHasAny(string, string4, true)) {
            throw new CommandUsedIllegally("Illegally tried to ban a Friendlisted user", string, "ban/kick", this.pubFuncs.dbGetFlags(string), string4);
        }
        String string5 = this.pubFuncs.getLocalSettingDefault(this.getName(), "Anybody else can be banned/kicked by", "ON");
        if (!this.pubFuncs.dbHasAny(string, string5, true)) {
            throw new CommandUsedIllegally("Illegally tried to ban somebody", string, "ban/kick", this.pubFuncs.dbGetFlags(string), string5);
        }
    }
}

