/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.util.gui;

import com.javaop.util.Uniq;
import com.javaop.util.gui.Gui;
import com.javaop.util.gui.JPanelEx;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class PreferencesPanel
extends JPanelEx {
    private static final long serialVersionUID = 1L;
    private final Hashtable components = new Hashtable();
    private final Properties initial;

    public PreferencesPanel(Properties currentSettings, Properties defaultSettings, Properties descriptions, Hashtable components) {
        super(new GridBagLayout());
        String[] keys = Uniq.uniq(defaultSettings.keys());
        if (keys.length == 0) {
            this.add(new JLabel("There are no settings for this plugin"));
        }
        int i = 0;
        while (i < keys.length) {
            String defaultSetting = defaultSettings.getProperty(keys[i], "");
            String currentSetting = currentSettings.getProperty(keys[i], defaultSetting);
            JComponent currentComponent = (JComponent)components.get(keys[i]);
            String description = descriptions.getProperty(keys[i], "<ERROR no description set>");
            if (currentComponent == null) {
                currentComponent = new JTextField(currentSetting);
            }
            JPanel thisPanel = this.getSettingPanel(keys[i], defaultSetting, description, currentComponent);
            this.add(thisPanel, new GridBagConstraints(0, i, 1, 1, 4.0, 1.0, 11, 2, new Insets(1, 1, 1, 1), 0, 0));
            ++i;
        }
        this.initial = this.getValues();
    }

    protected JPanel getSettingPanel(String name, final String defaultValue, String description, final JComponent comp) {
        JButton defaults = new JButton("Default");
        JTextArea desc = new JTextArea(description);
        this.components.put(name, comp);
        JPanelEx p = new JPanelEx(new GridBagLayout());
        p.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 2), name));
        p.add(comp, new GridBagConstraints(0, 1, 1, 1, 2.0, 0.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0));
        p.add(defaults, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0));
        p.add(desc, new GridBagConstraints(0, 2, 2, 1, 0.0, 1.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        desc.setEditable(false);
        desc.setOpaque(false);
        desc.setLineWrap(true);
        desc.setWrapStyleWord(true);
        desc.setFocusable(false);
        defaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.setTextFromComponent(comp, defaultValue);
            }
        });
        return p;
    }

    public String getValue(String key) {
        return Gui.getTextFromComponent((JComponent)this.components.get(key));
    }

    public Properties getValues() {
        Properties p = new Properties();
        Enumeration e = this.components.keys();
        while (e.hasMoreElements()) {
            String thisElement = (String)e.nextElement();
            p.setProperty(thisElement, this.getValue(thisElement));
        }
        return p;
    }

    public boolean hasChanged() {
        return !this.initial.equals(this.getValues());
    }
}

