/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.util;

import com.javaop.util.PersistantMap;
import com.javaop.util.Uniq;
import java.io.File;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;

public class UserDB {
    private PersistantMap userDB;

    public UserDB(File filename) {
        this.userDB = new PersistantMap(filename, "User database file.  All lines are name=FLAGS, ensuring that FLAGS are all uppercase.");
    }

    public void addFlag(String user, char flag) {
        if (user == null) {
            return;
        }
        flag = Character.toUpperCase(flag);
        String current = this.userDB.getNoWrite(null, user = user.toLowerCase(), "");
        if (current.length() == 0) {
            this.userDB.set(null, user, String.valueOf(flag));
        } else if (current.indexOf(flag) < 0) {
            current = String.valueOf(current) + flag;
            char[] currentArray = current.toCharArray();
            Arrays.sort(currentArray);
            current = new String(currentArray);
            this.userDB.set(null, user, current);
        }
    }

    public void addFlags(String user, String flags) {
        if (user == null) {
            return;
        }
        int i = 0;
        while (i < flags.length()) {
            this.addFlag(user, flags.charAt(i));
            ++i;
        }
    }

    public void removeFlag(String user, char flag) {
        if (user == null) {
            return;
        }
        flag = Character.toUpperCase(flag);
        String current = this.userDB.getNoWrite(null, user = user.toLowerCase(), "");
        if (current.length() > 0) {
            this.userDB.set(null, user, current.replaceAll(String.valueOf(flag), ""));
        }
        if (this.userDB.getNoWrite(null, user, "").length() == 0) {
            this.userDB.remove(null, user);
        }
    }

    public void removeFlags(String user, String flags) {
        if (user == null) {
            return;
        }
        int i = 0;
        while (i < flags.length()) {
            this.removeFlag(user, flags.charAt(i));
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean hasFlag(String user, char flag) {
        if (user == null) {
            return flag == 'M' || flag == 'U';
        }
        if (this.findFlag(user = user.toLowerCase(), flag = Character.toUpperCase(flag))) {
            return true;
        }
        e = this.userDB.propertyNames(null);
        if (e != null) ** GOTO lbl11
        return false;
lbl-1000:
        // 1 sources

        {
            name = (String)e.nextElement();
            if (!user.matches(UserDB.fixPattern(name)) || !this.findFlag(name, flag)) continue;
            return true;
lbl11:
            // 2 sources

            ** while (e.hasMoreElements())
        }
lbl12:
        // 1 sources

        return false;
    }

    public String getRawFlags(String user) {
        if (user == null) {
            return "MU";
        }
        user = user.toLowerCase();
        return this.userDB.getNoWrite(null, user, "");
    }

    public String getFlags(String user) {
        if (user == null) {
            return "<local user> => MU (always)";
        }
        user = user.toLowerCase();
        Enumeration e = this.userDB.propertyNames(null);
        StringBuffer patterns = new StringBuffer();
        TreeSet<Character> flags = new TreeSet<Character>();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!user.matches(UserDB.fixPattern(name))) continue;
            patterns.append(name).append(" ");
            String userFlags = this.userDB.getNoWrite(null, name, "");
            int i = 0;
            while (i < userFlags.length()) {
                flags.add(new Character(userFlags.charAt(i)));
                ++i;
            }
        }
        if (patterns.length() == 0 || flags.size() == 0) {
            return "User " + user + " was not found.";
        }
        patterns.append("=> ");
        Iterator i = flags.iterator();
        while (i.hasNext()) {
            patterns.append(i.next());
        }
        return patterns.toString();
    }

    public void deleteUser(String user) {
        if (user == null) {
            return;
        }
        user = user.toLowerCase();
        this.userDB.remove(null, user);
    }

    public int getCount() {
        return this.userDB.size(null);
    }

    public boolean hasAny(String user, String flagList, boolean allowMOverride) {
        if (user != null) {
            user = user.toLowerCase();
        }
        if (allowMOverride && !flagList.equals("U")) {
            flagList = String.valueOf(flagList) + "M";
        }
        int i = 0;
        while (i < flagList.length()) {
            if (this.hasFlag(user, flagList.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasAll(String user, String flagList) {
        user = user.toLowerCase();
        int i = 0;
        while (i < flagList.length()) {
            if (!this.hasFlag(user, flagList.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean userExists(String user) {
        if (user == null) {
            return true;
        }
        return this.userDB.getNoWrite(null, user = user.toLowerCase(), "").length() > 0;
    }

    public String[] findAttr(char flag) {
        flag = Character.toUpperCase(flag);
        Vector<String> users = new Vector<String>();
        Enumeration e = this.userDB.propertyNames(null);
        while (e.hasMoreElements()) {
            String thisUser = (String)e.nextElement();
            if (this.userDB.getNoWrite(null, thisUser, "").indexOf(flag) < 0) continue;
            users.add(thisUser);
        }
        if (flag == 'M' || flag == 'U') {
            users.add("<local user>");
        }
        return Uniq.uniq(users);
    }

    public String[] getUserList() {
        Enumeration e = this.userDB.propertyNames(null);
        Vector<String> ret = new Vector<String>();
        if (e != null) {
            while (e.hasMoreElements()) {
                ret.add((String)e.nextElement());
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    protected boolean findFlag(String user, char flag) {
        String current = this.userDB.getNoWrite(null, user, "");
        flag = Character.toUpperCase(flag);
        return current != null && current.indexOf(flag) >= 0;
    }

    private static String fixPattern(String str) {
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char thisChar = str.charAt(i);
            if (thisChar == '*') {
                ret.append(".*");
            } else if (thisChar == '?') {
                ret.append(".");
            } else if (thisChar == '%') {
                ret.append("[0-9]");
            } else if (!Character.isLetterOrDigit(thisChar)) {
                ret.append("\\").append(thisChar);
            } else {
                ret.append(str.charAt(i));
            }
            ++i;
        }
        return ret.toString().toLowerCase();
    }

    public static void main(String[] args) throws Exception {
        UserDB db = new UserDB(new File("/tmp/blah"));
        db.addFlags("test", "ABCD");
    }
}

