/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.util;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;

public class TimeoutSocket
extends Thread {
    private Socket s = null;
    private boolean cancel = false;
    private String failed = null;
    private final String server;
    private final int port;

    public static Socket getSocket(String server, int port, int timeout) throws SocketException {
        long endTime = System.currentTimeMillis() + (long)timeout;
        TimeoutSocket thisSocket = new TimeoutSocket(server, port);
        thisSocket.start();
        while (thisSocket.getSocket() == null) {
            if (System.currentTimeMillis() > endTime) {
                thisSocket.cancel();
                throw new SocketException("Connection timed out");
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
            }
        }
        return thisSocket.getSocket();
    }

    private TimeoutSocket(String server, int port) {
        this.server = server;
        this.port = port;
    }

    @Override
    public void run() {
        try {
            this.s = new Socket(this.server, this.port);
            if (this.cancel) {
                this.s.close();
            }
        }
        catch (IOException e) {
            this.failed = e.toString();
        }
    }

    private Socket getSocket() throws SocketException {
        if (this.failed != null) {
            throw new SocketException(this.failed);
        }
        return this.s;
    }

    private void cancel() {
        this.cancel = true;
    }
}

