/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.util;

public class TimeReader {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;

    public static long stringToTime(String time) throws IllegalArgumentException {
        if (time == null || time.length() < 1) {
            return 0L;
        }
        char lastChar = (time = time.toLowerCase()).charAt(time.length() - 1);
        if (Character.isDigit(lastChar)) {
            try {
                return Long.parseLong(time) * 1000L;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid absolute time specified.  Time must be all in numbers.");
            }
        }
        if ((time = time.substring(0, time.length() - 1)).length() == 0) {
            return 0L;
        }
        long baseTime = Long.parseLong(time);
        if (lastChar == 's') {
            return baseTime * 1000L;
        }
        if (lastChar == 'm') {
            return baseTime * 60000L;
        }
        if (lastChar == 'h') {
            return baseTime * 3600000L;
        }
        if (lastChar == 'd') {
            return baseTime * 86400000L;
        }
        throw new IllegalArgumentException("Invalid time units.  Valid units are D=Days, M=Minutes, H=Hours, S=Seconds");
    }

    public static String timeToString(long time) {
        if (time == 0L) {
            return "0ms";
        }
        long days = time / 86400000L;
        long hours = (time %= 86400000L) / 3600000L;
        long minutes = (time %= 3600000L) / 60000L;
        long seconds = (time %= 60000L) / 1000L;
        time %= 1000L;
        StringBuffer s = new StringBuffer();
        s.append(days > 0L ? String.valueOf(days) + " day" + (days == 1L ? "" : "s") + ", " : "");
        s.append(hours > 0L ? String.valueOf(hours) + " hour" + (hours == 1L ? "" : "s") + ", " : "");
        s.append(minutes > 0L ? String.valueOf(minutes) + " minute" + (minutes == 1L ? "" : "s") + ", " : "");
        s.append(String.valueOf(seconds) + " second" + (seconds == 1L ? "" : "s"));
        return s.toString();
    }

    public static void main(String[] args) {
        System.out.println(TimeReader.stringToTime("1000"));
        System.out.println(TimeReader.stringToTime("10s"));
        System.out.println(TimeReader.stringToTime("15m"));
        System.out.println(TimeReader.stringToTime("20d"));
        System.out.println(TimeReader.timeToString(TimeReader.stringToTime("1000")));
        System.out.println(TimeReader.timeToString(TimeReader.stringToTime("10s")));
        System.out.println(TimeReader.timeToString(TimeReader.stringToTime("15m")));
        System.out.println(TimeReader.timeToString(TimeReader.stringToTime("20d")));
        System.out.println(TimeReader.timeToString(TimeReader.stringToTime("20d") + TimeReader.stringToTime("15m") + TimeReader.stringToTime("10s")));
    }
}

