/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.util;

import com.javaop.util.StringEncoder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class PersistantMap {
    private final File tempFile = new File(String.valueOf(System.getProperty("user.home")) + "/.javaop2-tmp-" + Math.random());
    private final File file;
    private final String comment;
    private Hashtable<String, Properties> sections = new Hashtable();
    private long lastUpdate = 0L;

    public PersistantMap(File file, String comment) {
        this.file = file;
        this.comment = comment;
        this.load();
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        if (this.lastUpdate >= this.file.lastModified()) {
            return;
        }
        PersistantMap persistantMap = this;
        synchronized (persistantMap) {
            try {
                String line;
                Hashtable<String, Properties> temp = new Hashtable<String, Properties>();
                Properties currentSection = new Properties();
                String sectionName = "default";
                BufferedReader in = new BufferedReader(new FileReader(this.file));
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                    if (line.matches("\\[.*\\]")) {
                        temp.put(sectionName, currentSection);
                        currentSection = new Properties();
                        sectionName = line.trim().substring(1, line.length() - 1).toLowerCase();
                        continue;
                    }
                    if (!line.matches(".+=.*")) continue;
                    int location = line.replaceFirst("[^\\\\]=.*", "").length() + 1;
                    String name = line.substring(0, location).toLowerCase().replaceAll("\\\\=", "=");
                    String value = line.substring(location + 1);
                    currentSection.setProperty(name, StringEncoder.decode(value).toString());
                }
                temp.put(sectionName, currentSection);
                in.close();
                this.sections = temp;
                this.lastUpdate = System.currentTimeMillis();
            }
            catch (FileNotFoundException temp) {
            }
            catch (Exception e) {
                System.exit(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        PersistantMap persistantMap = this;
        synchronized (persistantMap) {
            try {
                Object[] sectionArray = this.sortEnumeration(this.sections.keys());
                this.file.getParentFile().mkdirs();
                PrintWriter out = new PrintWriter(new FileWriter(this.file));
                out.println("# " + this.file.getAbsolutePath());
                out.println("# Also stored  in: " + this.tempFile);
                out.println("# Created on: " + new Date());
                out.println("# By: " + System.getProperty("user.name"));
                out.println("# Comment: " + this.comment);
                int i = 0;
                while (i < sectionArray.length) {
                    String name = sectionArray[i].toString().toLowerCase();
                    Properties data = this.sections.get(name);
                    out.println();
                    out.println("[" + name + "]");
                    Object[] keys = this.sortEnumeration(data.keys());
                    int j = 0;
                    while (j < keys.length) {
                        out.println(String.valueOf(keys[j].toString().toLowerCase().replaceAll("=", "\\\\=")) + "=" + StringEncoder.encode(data.getProperty((String)keys[j])));
                        ++j;
                    }
                    ++i;
                }
                out.close();
                this.tempFile.renameTo(this.file);
                this.tempFile.delete();
                this.lastUpdate = System.currentTimeMillis();
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private String fix(String value) {
        return value == null ? "default" : value.toLowerCase();
    }

    private Object[] sortEnumeration(Enumeration e) {
        Vector objectVector = new Vector();
        while (e.hasMoreElements()) {
            objectVector.add(e.nextElement());
        }
        Object[] ret = objectVector.toArray();
        Arrays.sort(ret);
        return ret;
    }

    public void set(String sectionName, String key, String value) {
        sectionName = this.fix(sectionName);
        key = this.fix(key);
        this.load();
        Properties section = this.sections.get(sectionName);
        if (section == null) {
            section = new Properties();
        }
        if (value == null) {
            section.remove(key);
        } else {
            section.setProperty(key, value);
        }
        this.sections.put(sectionName, section);
        this.save();
    }

    public String getNoWrite(String sectionName, String key, String defaultValue) {
        sectionName = this.fix(sectionName);
        key = this.fix(key);
        this.load();
        Properties section = this.sections.get(sectionName);
        if (section == null) {
            return defaultValue;
        }
        return section.getProperty(key, defaultValue);
    }

    public String getWrite(String sectionName, String key, String defaultValue) {
        sectionName = this.fix(sectionName);
        key = this.fix(key);
        this.load();
        Properties section = this.sections.get(sectionName);
        if (section == null) {
            section = new Properties();
        }
        String oldValue = section.getProperty(key, null);
        String value = section.getProperty(key, defaultValue);
        section.put(key, value);
        this.sections.put(sectionName, section);
        if (oldValue == null) {
            this.save();
        }
        return value;
    }

    public void remove(String sectionName, String key) {
        sectionName = this.fix(sectionName);
        key = this.fix(key);
        this.load();
        Properties section = this.sections.get(sectionName);
        if (section == null) {
            return;
        }
        section.remove(key);
        if (section.size() == 0) {
            this.sections.remove(sectionName);
        }
        this.save();
    }

    public Enumeration propertyNames(String sectionName) {
        sectionName = this.fix(sectionName);
        this.load();
        Properties section = this.sections.get(sectionName);
        if (section == null) {
            return null;
        }
        return section.keys();
    }

    public Enumeration sectionNames() {
        this.load();
        return this.sections.keys();
    }

    public int size(String sectionName) {
        this.load();
        sectionName = this.fix(sectionName);
        Properties section = this.sections.get(sectionName);
        if (section == null) {
            return 0;
        }
        return section.size();
    }

    public int sections() {
        this.load();
        return this.sections.size();
    }

    public boolean contains(String sectionName, String key) {
        sectionName = this.fix(sectionName);
        key = this.fix(key);
        this.load();
        Properties section = this.sections.get(sectionName);
        if (section == null) {
            return false;
        }
        return section.containsKey(key);
    }

    public Properties getSection(String section) {
        section = this.fix(section);
        this.load();
        return this.sections.get(section);
    }
}

