/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.util;

public class Buffer {
    public final int defaultLength = 32;
    protected byte[] buffer = new byte[32];
    private int currentLength = 0;
    private int maxLength = 32;

    public Buffer() {
    }

    public Buffer(byte[] b) {
        this();
        this.addBytes(b);
    }

    public Buffer(Buffer b) {
        this();
        this.addBytes(b.getBytes());
    }

    public int size() {
        return this.currentLength;
    }

    public byte[] getBytes() {
        byte[] ret = new byte[this.currentLength];
        System.arraycopy(this.buffer, 0, ret, 0, this.currentLength);
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    private void verifyLength(int bytes) {
        if (this.currentLength + bytes > this.maxLength) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            this.maxLength *= 2;
lbl4:
            // 2 sources

            ** while (this.currentLength + bytes > this.maxLength)
        }
lbl5:
        // 1 sources

        newBuffer = new byte[this.maxLength];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.currentLength);
        this.buffer = newBuffer;
    }

    protected byte[] remove(int number) {
        byte[] ret = new byte[number];
        System.arraycopy(this.buffer, 0, ret, 0, number);
        System.arraycopy(this.buffer, number, this.buffer, 0, this.currentLength - number);
        this.currentLength -= number;
        return ret;
    }

    public void addByte(byte b) {
        this.verifyLength(1);
        this.buffer[this.currentLength++] = b;
    }

    public byte removeByte() throws IndexOutOfBoundsException {
        if (this.currentLength == 0) {
            throw new IndexOutOfBoundsException("Attempted to remove data from the buffer that wasn't there.");
        }
        return this.remove(1)[0];
    }

    public byte byteAt(int index) {
        return this.buffer[index];
    }

    public void addWord(short w) {
        this.addByte((byte)((w & 0xFF) >> 0));
        this.addByte((byte)((w & 0xFF00) >> 8));
    }

    public short removeWord() throws IndexOutOfBoundsException {
        int ret = this.removeByte() << 0 & 0xFF | this.removeByte() << 8 & 0xFF00;
        return (short)(ret & 0xFFFF);
    }

    public void addDWord(int d) {
        this.addByte((byte)((d & 0xFF) >> 0));
        this.addByte((byte)((d & 0xFF00) >> 8));
        this.addByte((byte)((d & 0xFF0000) >> 16));
        this.addByte((byte)((d & 0xFF000000) >> 24));
    }

    public void addArray(int[] a) {
        int i = 0;
        while (i < a.length) {
            this.addDWord(a[i]);
            ++i;
        }
    }

    public int removeDWord() throws IndexOutOfBoundsException {
        return this.removeByte() << 0 & 0xFF | this.removeByte() << 8 & 0xFF00 | this.removeByte() << 16 & 0xFF0000 | this.removeByte() << 24 & 0xFF000000;
    }

    public void addLong(long l) {
        this.addByte((byte)((l & 0xFFL) >> 0));
        this.addByte((byte)((l & 0xFF00L) >> 8));
        this.addByte((byte)((l & 0xFF0000L) >> 16));
        this.addByte((byte)((l & 0xFF000000L) >> 24));
        this.addByte((byte)((l & 0xFF00000000L) >> 32));
        this.addByte((byte)((l & 0xFF0000000000L) >> 40));
        this.addByte((byte)((l & 0xFF000000000000L) >> 48));
        this.addByte((byte)((l & 0xFF00000000000000L) >> 56));
    }

    public long removeLong() throws IndexOutOfBoundsException {
        return (long)this.removeByte() << 0 & 0xFFL | (long)this.removeByte() << 8 & 0xFF00L | (long)this.removeByte() << 16 & 0xFF0000L | (long)this.removeByte() << 24 & 0xFF000000L | (long)this.removeByte() << 32 & 0xFF00000000L | (long)this.removeByte() << 40 & 0xFF0000000000L | (long)this.removeByte() << 48 & 0xFF000000000000L | (long)this.removeByte() << 56 & 0xFF00000000000000L;
    }

    public void addString(String s) {
        int i = 0;
        while (i < s.length()) {
            this.addByte((byte)s.charAt(i));
            ++i;
        }
    }

    public String removeString(int i) throws IndexOutOfBoundsException {
        StringBuffer s = new StringBuffer(i + 1);
        int j = 0;
        while (j < i) {
            s.append((char)this.removeByte());
            ++j;
        }
        return s.toString();
    }

    public void addNTString(String s) {
        this.addString(s);
        this.addByte((byte)0);
    }

    public String removeNTString() {
        StringBuffer s = new StringBuffer();
        byte b = this.removeByte();
        while (b != 0) {
            s.append((char)b);
            b = this.removeByte();
        }
        return s.toString();
    }

    public byte[] removeNtByteArray() {
        Buffer ret = new Buffer();
        byte b = this.removeByte();
        while (b != 0) {
            ret.addByte(b);
            b = this.removeByte();
        }
        return ret.getBytes();
    }

    public void addNtByteArray(byte[] b) {
        this.addBytes(b);
        this.addByte((byte)0);
    }

    public void addBytes(byte[] b) {
        int i = 0;
        while (i < b.length) {
            this.addByte(b[i]);
            ++i;
        }
    }

    public byte[] removeBytes(int i) throws IndexOutOfBoundsException {
        return this.remove(i);
    }

    public void addBuffer(Buffer b) {
        this.addBytes(b.getBytes());
    }

    public void add(byte b) {
        this.addByte(b);
    }

    public void add(short s) {
        this.addWord(s);
    }

    public void add(int i) {
        this.addDWord(i);
    }

    public void add(int[] i) {
        this.addArray(i);
    }

    public void add(long l) {
        this.addLong(l);
    }

    public void add(byte[] b) {
        this.addBytes(b);
    }

    public void add(Buffer b) {
        this.addBuffer(b);
    }

    public String toString() {
        int j;
        StringBuffer returnString = new StringBuffer(this.currentLength * 3 + this.currentLength + this.currentLength / 4 + 30);
        int i = 0;
        while (i < this.currentLength) {
            if (i != 0 && i % 16 == 0) {
                returnString.append('\t');
                j = i - 16;
                while (j < i) {
                    if (this.buffer[j] < 32 || this.buffer[j] > 127) {
                        returnString.append('.');
                    } else {
                        returnString.append((char)this.buffer[j]);
                    }
                    ++j;
                }
                returnString.append("\n");
            }
            returnString.append(String.valueOf(Integer.toString((this.buffer[i] & 0xF0) >> 4, 16)) + Integer.toString((this.buffer[i] & 0xF) >> 0, 16));
            returnString.append(' ');
            ++i;
        }
        if (i != 0 && i % 16 != 0) {
            j = 0;
            while (j < (16 - i % 16) * 3) {
                returnString.append(' ');
                ++j;
            }
        }
        returnString.append('\t');
        j = i > 0 && i % 16 == 0 ? i - 16 : i - i % 16;
        while (i >= 0 && j < i) {
            if (this.buffer[j] < 32 || this.buffer[j] > 127) {
                returnString.append('.');
            } else {
                returnString.append((char)this.buffer[j]);
            }
            ++j;
        }
        returnString.append('\n');
        returnString.append("Length: " + this.currentLength + '\n');
        return returnString.toString();
    }
}

