/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.util;

import com.javaop.util.Buffer;

public class BnetPacket
extends Buffer {
    protected byte code;

    public BnetPacket() {
    }

    public BnetPacket(byte code) {
        this.setCode(code);
    }

    public BnetPacket(BnetPacket old) {
        this.addBytes(old.getRawBuffer());
        this.code = old.code;
    }

    public void setCode(byte code) {
        this.code = code;
    }

    public byte getCode() {
        return this.code;
    }

    @Override
    public byte[] getBytes() {
        byte[] ret = new byte[this.size()];
        System.arraycopy(super.getBytes(), 0, ret, 4, this.size() - 4);
        ret[0] = -1;
        ret[1] = this.code;
        ret[2] = (byte)(ret.length >> 0 & 0xFF);
        ret[3] = (byte)(ret.length >> 8 & 0xFF);
        return ret;
    }

    public byte[] getRawBuffer() {
        return super.getBytes();
    }

    @Override
    public int size() {
        return super.size() + 4;
    }

    @Override
    public String toString() {
        int j;
        byte[] buffer = this.getBytes();
        StringBuffer returnString = new StringBuffer(this.size() * 3 + this.size() + this.size() / 4 + 30);
        returnString.append("Buffer contents:\n");
        int i = 0;
        while (i < this.size()) {
            if (i != 0 && i % 16 == 0) {
                returnString.append('\t');
                j = i - 16;
                while (j < i) {
                    if (buffer[j] < 32 || buffer[j] > 127) {
                        returnString.append('.');
                    } else {
                        returnString.append((char)buffer[j]);
                    }
                    ++j;
                }
                returnString.append("\n");
            }
            returnString.append(String.valueOf(Integer.toString((buffer[i] & 0xF0) >> 4, 16)) + Integer.toString((buffer[i] & 0xF) >> 0, 16));
            returnString.append(' ');
            ++i;
        }
        if (i != 0 && i % 16 != 0) {
            j = 0;
            while (j < (16 - i % 16) * 3) {
                returnString.append(' ');
                ++j;
            }
        }
        returnString.append('\t');
        j = i > 0 && i % 16 == 0 ? i - 16 : i - i % 16;
        while (i >= 0 && j < i) {
            if (buffer[j] < 32 || buffer[j] > 127) {
                returnString.append('.');
            } else {
                returnString.append((char)buffer[j]);
            }
            ++j;
        }
        returnString.append('\n');
        returnString.append("Length: " + this.size() + '\n');
        return returnString.toString();
    }

    public boolean equals(Object o) {
        byte[] thatPacket;
        if (!(o instanceof BnetPacket)) {
            return false;
        }
        BnetPacket packet = (BnetPacket)o;
        if (packet.getCode() != this.getCode()) {
            return false;
        }
        byte[] thisPacket = packet.getBytes();
        if (thisPacket.length != (thatPacket = this.getBytes()).length) {
            return false;
        }
        int i = 0;
        while (i < thisPacket.length) {
            if (thisPacket[i] != thatPacket[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

