/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.util;

import java.math.BigInteger;
import java.util.Random;

public class BigIntegerEx {
    public static final int BIG_ENDIAN = 0;
    public static final int LITTLE_ENDIAN = 1;
    public static final int BIGINT_SIZE = 32;
    private final BigInteger bigInteger;
    private final int endian;

    public BigIntegerEx(int endian, String value) {
        this.endian = endian;
        this.bigInteger = new BigInteger(value);
    }

    public BigIntegerEx(int endian, byte[] value) {
        this.endian = endian;
        this.bigInteger = endian == 0 ? new BigInteger(1, value) : new BigInteger(1, BigIntegerEx.reverseArray(value, value.length));
    }

    public BigIntegerEx(int endian, BigInteger base) {
        this.endian = endian;
        this.bigInteger = endian == 1 ? base : new BigInteger(BigIntegerEx.reverseArray(base.toByteArray(), 32));
    }

    public BigIntegerEx(int endian, int bits) {
        this.endian = endian;
        this.bigInteger = new BigInteger(bits, new Random());
    }

    public BigInteger getBigInteger() {
        return this.bigInteger;
    }

    public byte[] toByteArray() {
        if (this.endian == 0) {
            return this.bigInteger.toByteArray();
        }
        return BigIntegerEx.reverseArray(this.bigInteger.toByteArray(), 32);
    }

    public BigIntegerEx modPow(BigIntegerEx exponent, BigIntegerEx m) {
        return new BigIntegerEx(this.endian, this.getBigInteger().modPow(exponent.getBigInteger(), m.getBigInteger()));
    }

    public BigIntegerEx mod(BigIntegerEx m) {
        return new BigIntegerEx(this.endian, this.getBigInteger().mod(m.getBigInteger()));
    }

    public BigIntegerEx add(BigIntegerEx a) {
        return new BigIntegerEx(this.endian, this.getBigInteger().add(a.getBigInteger()));
    }

    public BigIntegerEx subtract(BigIntegerEx a) {
        return new BigIntegerEx(this.endian, this.getBigInteger().subtract(a.getBigInteger()));
    }

    public BigIntegerEx multiply(BigIntegerEx a) {
        return new BigIntegerEx(this.endian, this.getBigInteger().multiply(a.getBigInteger()));
    }

    public int compareTo(BigIntegerEx a) {
        return this.bigInteger.compareTo(a.getBigInteger());
    }

    public String toString() {
        return this.bigInteger.toString();
    }

    public String toString(int radix) {
        return this.bigInteger.toString(radix);
    }

    private static byte[] reverseArray(byte[] array, int maxLen) {
        byte[] a = new byte[array.length];
        int i = 0;
        while (i < array.length) {
            a[array.length - i - 1] = array[i];
            ++i;
        }
        if (maxLen != 0) {
            return BigIntegerEx.trimArray(a, maxLen);
        }
        return a;
    }

    private static byte[] trimArray(byte[] array, int size) {
        byte[] a = new byte[size];
        if (array.length > size) {
            System.arraycopy(array, 0, a, 0, size);
        } else {
            System.arraycopy(array, 0, a, 0, array.length);
        }
        return a;
    }
}

