/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.users;

import com.javaop.util.User;

class UserData
implements User {
    private static final long serialVersionUID = 1L;
    private final int ping;
    private final String name;
    private final long joinTime;
    private final String prettyStatstring;
    private final String rawStatstring;
    private int flags;

    public UserData(String name, int ping, int flags, String stats) {
        this.name = name;
        this.ping = ping;
        this.flags = flags;
        this.joinTime = System.currentTimeMillis();
        this.rawStatstring = stats;
        this.prettyStatstring = stats;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPing() {
        return this.ping;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public String getPrettyStatstring() {
        return this.toString();
    }

    @Override
    public String getRawStatstring() {
        return this.rawStatstring;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    @Override
    public String toString() {
        if (this.prettyStatstring != null) {
            return String.valueOf(this.name) + "(" + this.ping + "ms, " + this.prettyStatstring + ")";
        }
        return String.valueOf(this.name) + "(" + this.ping + "ms)";
    }

    public boolean equals(Object o) {
        if (o instanceof UserData && ((UserData)o).getName().equalsIgnoreCase(this.getName())) {
            return true;
        }
        return o instanceof String && ((String)o).equalsIgnoreCase(this.getName());
    }

    @Override
    public long getJoinTime() {
        return this.joinTime;
    }
}

