/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.pluginmanagers;

import com.javaop.bot.BotCoreStatic;
import com.javaop.bot.JavaOpFileStuff;
import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.exceptions.CommandUsedIllegally;
import com.javaop.exceptions.CommandUsedImproperly;
import com.javaop.exceptions.LoginException;
import com.javaop.exceptions.PluginException;
import com.javaop.plugin_containers.BotPlugin;
import com.javaop.plugin_containers.CommandPlugin;
import com.javaop.plugin_containers.ConnectionPlugin;
import com.javaop.plugin_containers.ErrorPlugin;
import com.javaop.plugin_containers.EventPlugin;
import com.javaop.plugin_containers.GuiPlugin;
import com.javaop.plugin_containers.OutgoingTextPlugin;
import com.javaop.plugin_containers.PacketPlugin;
import com.javaop.plugin_containers.RawEventPlugin;
import com.javaop.plugin_containers.SystemMessagePlugin;
import com.javaop.plugin_containers.UserDatabasePlugin;
import com.javaop.plugin_containers.UserErrorPlugin;
import com.javaop.plugin_interfaces.BotCallback;
import com.javaop.plugin_interfaces.CommandCallback;
import com.javaop.plugin_interfaces.ConnectionCallback;
import com.javaop.plugin_interfaces.ErrorCallback;
import com.javaop.plugin_interfaces.EventCallback;
import com.javaop.plugin_interfaces.GuiCallback;
import com.javaop.plugin_interfaces.OutgoingTextCallback;
import com.javaop.plugin_interfaces.PacketCallback;
import com.javaop.plugin_interfaces.RawEventCallback;
import com.javaop.plugin_interfaces.SystemMessageCallback;
import com.javaop.plugin_interfaces.UserDatabaseCallback;
import com.javaop.plugin_interfaces.UserErrorCallback;
import com.javaop.util.BnetEvent;
import com.javaop.util.BnetPacket;
import com.javaop.util.PersistantMap;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class PluginRegistration
implements PluginCallbackRegister {
    private Vector<BotPlugin> botPlugins = new Vector();
    private Vector<ConnectionPlugin> connectionPlugins = new Vector();
    private Vector<ErrorPlugin> errorPlugins = new Vector();
    private Vector<OutgoingTextPlugin> outgoingTextPlugins = new Vector();
    private Vector<SystemMessagePlugin> systemMessagePlugins = new Vector();
    private Vector<UserDatabasePlugin> userDatabasePlugins = new Vector();
    private Vector<UserErrorPlugin> userErrorPlugins = new Vector();
    private Vector<EventPlugin> eventPlugins = new Vector();
    private Vector<GuiPlugin> guiPlugins = new Vector();
    private Vector<RawEventPlugin>[] rawEventPlugins = new Vector[24];
    private Vector<PacketPlugin>[] incomingPacketPlugins = new Vector[255];
    private Vector<PacketPlugin>[] outgoingPacketPlugins = new Vector[255];
    private Hashtable<String, CommandPlugin> commandPlugins = new Hashtable();
    private final PersistantMap commandAliases;
    private final PersistantMap customCommandFlags;
    private PublicExposedFunctions pubFuncs;

    public PluginRegistration(PublicExposedFunctions pubFuncs) {
        this.pubFuncs = pubFuncs;
        this.customCommandFlags = JavaOpFileStuff.getCustomFlags(pubFuncs.getName());
        this.commandAliases = JavaOpFileStuff.getAliases(pubFuncs.getName());
    }

    public String[] getCommands() {
        Enumeration<String> commands = this.commandPlugins.keys();
        Vector<String> ret = new Vector<String>();
        while (commands.hasMoreElements()) {
            ret.add(commands.nextElement());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public String getHelp(String command) {
        CommandPlugin plugin = this.commandPlugins.get(command);
        if (plugin == null) {
            return null;
        }
        return plugin.getHelp();
    }

    public String getUsage(String command) {
        CommandPlugin plugin = this.commandPlugins.get(command);
        if (plugin == null) {
            return null;
        }
        return plugin.getUsage();
    }

    public String getRequiredFlags(String command) {
        CommandPlugin plugin = this.commandPlugins.get(command);
        if (plugin == null) {
            return null;
        }
        String requiredFlags = plugin.getRequiredFlags();
        String customFlags = this.customCommandFlags.getNoWrite(null, plugin.getName(), "");
        if (customFlags.length() > 0) {
            requiredFlags = customFlags;
        }
        return requiredFlags;
    }

    public void addAlias(String command, String alias) {
        this.commandAliases.set(null, alias, command);
    }

    public String[] getAliasesOf(String command) {
        Enumeration e = this.commandAliases.propertyNames(null);
        Vector<String> v = new Vector<String>();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (!this.commandAliases.getNoWrite(null, s, "").equals(command)) continue;
            v.add(0, s);
        }
        return v.toArray(new String[v.size()]);
    }

    public String getCommandOf(String alias) {
        return this.commandAliases.getNoWrite(null, alias, alias);
    }

    public void removeAlias(String alias) {
        this.commandAliases.remove(null, alias);
    }

    @Override
    public void registerBotPlugin(BotCallback callback, Object data) {
        this.botPlugins.add(new BotPlugin(callback, data));
    }

    @Override
    public void registerCommandPlugin(CommandCallback callback, String name, int args, boolean requiresOps, String requiredFlags, String usage, String help, Object data) {
        this.commandPlugins.put(name.toLowerCase(), new CommandPlugin(callback, name, args, requiresOps, requiredFlags, usage, help, data));
    }

    @Override
    public void registerConnectionPlugin(ConnectionCallback callback, Object data) {
        this.connectionPlugins.add(new ConnectionPlugin(callback, data));
    }

    @Override
    public void registerErrorPlugin(ErrorCallback callback, Object data) {
        this.errorPlugins.add(new ErrorPlugin(callback, data));
    }

    @Override
    public void registerRawEventPlugin(RawEventCallback callback, int event, Object data) {
        if (this.rawEventPlugins[event] == null) {
            this.rawEventPlugins[event] = new Vector();
        }
        this.rawEventPlugins[event].add(new RawEventPlugin(callback, event, data));
    }

    @Override
    public void registerRawEventPlugin(RawEventCallback callback, int minEvent, int maxEvent, Object data) {
        int i = minEvent;
        while (i <= maxEvent) {
            this.registerRawEventPlugin(callback, i, data);
            ++i;
        }
    }

    @Override
    public void registerEventPlugin(EventCallback callback, Object data) {
        this.eventPlugins.add(new EventPlugin(callback, data));
    }

    @Override
    public void registerOutgoingTextPlugin(OutgoingTextCallback callback, Object data) {
        this.outgoingTextPlugins.add(new OutgoingTextPlugin(callback, data));
    }

    @Override
    public void registerIncomingPacketPlugin(PacketCallback callback, int packet, Object data) {
        if (this.incomingPacketPlugins[packet] == null) {
            this.incomingPacketPlugins[packet] = new Vector();
        }
        this.incomingPacketPlugins[packet].add(new PacketPlugin(callback, packet, data));
    }

    @Override
    public void registerIncomingPacketPlugin(PacketCallback callback, int minPacket, int maxPacket, Object data) {
        int i = minPacket;
        while (i <= maxPacket) {
            this.registerIncomingPacketPlugin(callback, i, data);
            ++i;
        }
    }

    @Override
    public void registerOutgoingPacketPlugin(PacketCallback callback, int packet, Object data) {
        if (this.outgoingPacketPlugins[packet] == null) {
            this.outgoingPacketPlugins[packet] = new Vector();
        }
        this.outgoingPacketPlugins[packet].add(new PacketPlugin(callback, packet, data));
    }

    @Override
    public void registerOutgoingPacketPlugin(PacketCallback callback, int minPacket, int maxPacket, Object data) {
        int i = minPacket;
        while (i <= maxPacket) {
            this.registerOutgoingPacketPlugin(callback, i, data);
            ++i;
        }
    }

    @Override
    public void registerSystemMessagePlugin(SystemMessageCallback callback, int minLevel, int maxLevel, Object data) {
        this.systemMessagePlugins.add(new SystemMessagePlugin(callback, minLevel, maxLevel, data));
    }

    @Override
    public void registerSystemMessagePlugin(SystemMessageCallback callback, int level, Object data) {
        this.registerSystemMessagePlugin(callback, level, level, data);
    }

    @Override
    public void registerUserDatabasePlugin(UserDatabaseCallback callback, Object data) {
        this.userDatabasePlugins.add(new UserDatabasePlugin(callback, data));
    }

    @Override
    public void registerUserErrorPlugin(UserErrorCallback callback, Object data) {
        this.userErrorPlugins.add(new UserErrorPlugin(callback, data));
    }

    @Override
    public void registerGuiPlugin(GuiCallback callback, Object data) {
        this.guiPlugins.add(new GuiPlugin(callback, data));
    }

    public void botInstanceStarting() throws IOException, PluginException {
        Enumeration<BotPlugin> e = this.botPlugins.elements();
        while (e.hasMoreElements()) {
            BotPlugin plugin = e.nextElement();
            ((BotCallback)plugin.getCallback()).botInstanceStarting(plugin.getData());
        }
    }

    public void botInstanceStopping() throws IOException, PluginException {
        Enumeration<BotPlugin> e = this.botPlugins.elements();
        while (e.hasMoreElements()) {
            BotPlugin plugin = e.nextElement();
            ((BotCallback)plugin.getCallback()).botInstanceStopping(plugin.getData());
        }
    }

    public boolean raiseCommand(String user, String command, String args, int loudness, boolean errorOnUnknown) throws PluginException, CommandUsedImproperly, IOException, CommandUsedIllegally {
        String newCommand;
        int infiniteLoopChecker = 0;
        while (++infiniteLoopChecker < 1000 && !(newCommand = this.getCommandOf(command)).replaceAll(" .*", "").equalsIgnoreCase(command)) {
            String[] commandParams = newCommand.split(" ", 2);
            if (commandParams.length == 2) {
                commandParams[1] = commandParams[1].replaceAll("\\%u", user);
                commandParams[1] = commandParams[1].replaceAll("\\%c", command);
                commandParams[1] = commandParams[1].replaceAll("\\%v", "JavaOp2 " + (String)BotCoreStatic.getInstance().getGlobalVariable("version"));
                commandParams[1] = commandParams[1].replaceAll("\\%n", this.pubFuncs.getName());
                args = String.valueOf(commandParams[1]) + " " + args;
            }
            System.out.println(String.valueOf(command) + " ==> " + commandParams[0]);
            command = commandParams[0];
        }
        if (infiniteLoopChecker == 1000) {
            this.pubFuncs.systemMessage(5, "There was a suspected infinite alias loop.  It's been skipped.");
            return true;
        }
        CommandPlugin plugin = this.commandPlugins.get(command);
        if (plugin == null) {
            if (errorOnUnknown) {
                this.unknownCommandUsed(user, command);
            }
            return false;
        }
        String requiredFlags = this.getRequiredFlags(command);
        if (!this.pubFuncs.dbHasAny(user, requiredFlags, true)) {
            throw new CommandUsedIllegally("User attempted to use an illegal command", user, command, this.pubFuncs.dbGetFlags(user), requiredFlags);
        }
        String[] splitArgs = args.length() > 0 ? args.split("\\s+", plugin.getArgs()) : new String[]{};
        ((CommandCallback)plugin.getCallback()).commandExecuted(user, command, splitArgs, loudness, plugin.getData());
        return true;
    }

    public boolean connecting(String server, int port) throws IOException, PluginException {
        Enumeration<ConnectionPlugin> e = this.connectionPlugins.elements();
        while (e.hasMoreElements()) {
            ConnectionPlugin plugin = e.nextElement();
            if (((ConnectionCallback)plugin.getCallback()).connecting(server, port, plugin.getData())) continue;
            return false;
        }
        return true;
    }

    public void connected(String server, int port) throws IOException, PluginException {
        Enumeration<ConnectionPlugin> e = this.connectionPlugins.elements();
        while (e.hasMoreElements()) {
            ConnectionPlugin plugin = e.nextElement();
            ((ConnectionCallback)plugin.getCallback()).connected(server, port, plugin.getData());
        }
    }

    public boolean disconnecting() {
        Enumeration<ConnectionPlugin> e = this.connectionPlugins.elements();
        while (e.hasMoreElements()) {
            ConnectionPlugin plugin = e.nextElement();
            if (((ConnectionCallback)plugin.getCallback()).disconnecting(plugin.getData())) continue;
            return false;
        }
        return true;
    }

    public void disconnected() {
        Enumeration<ConnectionPlugin> e = this.connectionPlugins.elements();
        while (e.hasMoreElements()) {
            ConnectionPlugin plugin = e.nextElement();
            ((ConnectionCallback)plugin.getCallback()).disconnected(plugin.getData());
        }
    }

    public void ioException(IOException e) {
        Enumeration<ErrorPlugin> enumeration = this.errorPlugins.elements();
        while (enumeration.hasMoreElements()) {
            ErrorPlugin plugin = enumeration.nextElement();
            ((ErrorCallback)plugin.getCallback()).ioException(e, plugin.getData());
        }
    }

    public void unknownException(Exception e) {
        Enumeration<ErrorPlugin> enumeration = this.errorPlugins.elements();
        while (enumeration.hasMoreElements()) {
            ErrorPlugin plugin = enumeration.nextElement();
            ((ErrorCallback)plugin.getCallback()).unknownException(e, plugin.getData());
        }
    }

    public void error(Error e) {
        Enumeration<ErrorPlugin> enumeration = this.errorPlugins.elements();
        while (enumeration.hasMoreElements()) {
            ErrorPlugin plugin = enumeration.nextElement();
            ((ErrorCallback)plugin.getCallback()).error(e, plugin.getData());
        }
    }

    public void pluginException(PluginException e) {
        Enumeration<ErrorPlugin> enumeration = this.errorPlugins.elements();
        while (enumeration.hasMoreElements()) {
            ErrorPlugin plugin = enumeration.nextElement();
            ((ErrorCallback)plugin.getCallback()).pluginException(e, plugin.getData());
        }
    }

    public void loginException(LoginException e) {
        Enumeration<ErrorPlugin> enumeration = this.errorPlugins.elements();
        while (enumeration.hasMoreElements()) {
            ErrorPlugin plugin = enumeration.nextElement();
            ((ErrorCallback)plugin.getCallback()).loginException(e, plugin.getData());
        }
    }

    public void unknownPacketReceived(BnetPacket packet) {
        Enumeration<ErrorPlugin> enumeration = this.errorPlugins.elements();
        while (enumeration.hasMoreElements()) {
            ErrorPlugin plugin = enumeration.nextElement();
            ((ErrorCallback)plugin.getCallback()).unknownPacketReceived(packet, plugin.getData());
        }
    }

    public void unknownEventReceived(BnetEvent event) {
        Enumeration<ErrorPlugin> enumeration = this.errorPlugins.elements();
        while (enumeration.hasMoreElements()) {
            ErrorPlugin plugin = enumeration.nextElement();
            ((ErrorCallback)plugin.getCallback()).unknownEventReceived(new BnetEvent(event), plugin.getData());
        }
    }

    public BnetEvent eventOccurring(BnetEvent event) throws IOException, PluginException {
        if (this.rawEventPlugins[event.getCode()] == null) {
            this.unknownEventReceived(event);
            return null;
        }
        Enumeration<RawEventPlugin> e = this.rawEventPlugins[event.getCode()].elements();
        while (e.hasMoreElements()) {
            RawEventPlugin plugin = e.nextElement();
            event = ((RawEventCallback)plugin.getCallback()).eventOccurring(event, plugin.getData());
            if (event != null) continue;
            return null;
        }
        return event;
    }

    public void eventOccurred(BnetEvent event) throws IOException, PluginException {
        if (this.rawEventPlugins[event.getCode()] == null) {
            return;
        }
        Enumeration<RawEventPlugin> e = this.rawEventPlugins[event.getCode()].elements();
        while (e.hasMoreElements()) {
            RawEventPlugin plugin = e.nextElement();
            ((RawEventCallback)plugin.getCallback()).eventOccurred(new BnetEvent(event), plugin.getData());
        }
    }

    public void talk(String user, String statstring, int ping, int flags) throws IOException, PluginException {
        Enumeration<EventPlugin> e = this.eventPlugins.elements();
        while (e.hasMoreElements()) {
            EventPlugin plugin = e.nextElement();
            ((EventCallback)plugin.getCallback()).talk(user, statstring, ping, flags);
        }
    }

    public void emote(String user, String statstring, int ping, int flags) throws IOException, PluginException {
        Enumeration<EventPlugin> e = this.eventPlugins.elements();
        while (e.hasMoreElements()) {
            EventPlugin plugin = e.nextElement();
            ((EventCallback)plugin.getCallback()).emote(user, statstring, ping, flags);
        }
    }

    public void whisperFrom(String user, String statstring, int ping, int flags) throws IOException, PluginException {
        Enumeration<EventPlugin> e = this.eventPlugins.elements();
        while (e.hasMoreElements()) {
            EventPlugin plugin = e.nextElement();
            ((EventCallback)plugin.getCallback()).whisperFrom(user, statstring, ping, flags);
        }
    }

    public void whisperTo(String user, String statstring, int ping, int flags) throws IOException, PluginException {
        Enumeration<EventPlugin> e = this.eventPlugins.elements();
        while (e.hasMoreElements()) {
            EventPlugin plugin = e.nextElement();
            ((EventCallback)plugin.getCallback()).whisperTo(user, statstring, ping, flags);
        }
    }

    public void userShow(String user, String statstring, int ping, int flags) throws IOException, PluginException {
        Enumeration<EventPlugin> e = this.eventPlugins.elements();
        while (e.hasMoreElements()) {
            EventPlugin plugin = e.nextElement();
            ((EventCallback)plugin.getCallback()).userShow(user, statstring, ping, flags);
        }
    }

    public void userJoin(String user, String statstring, int ping, int flags) throws IOException, PluginException {
        Enumeration<EventPlugin> e = this.eventPlugins.elements();
        while (e.hasMoreElements()) {
            EventPlugin plugin = e.nextElement();
            ((EventCallback)plugin.getCallback()).userJoin(user, statstring, ping, flags);
        }
    }

    public void userLeave(String user, String statstring, int ping, int flags) throws IOException, PluginException {
        Enumeration<EventPlugin> e = this.eventPlugins.elements();
        while (e.hasMoreElements()) {
            EventPlugin plugin = e.nextElement();
            ((EventCallback)plugin.getCallback()).userLeave(user, statstring, ping, flags);
        }
    }

    public void userFlags(String user, String statstring, int ping, int flags) throws IOException, PluginException {
        Enumeration<EventPlugin> e = this.eventPlugins.elements();
        while (e.hasMoreElements()) {
            EventPlugin plugin = e.nextElement();
            ((EventCallback)plugin.getCallback()).userFlags(user, statstring, ping, flags);
        }
    }

    public void error(String user, String statstring, int ping, int flags) throws IOException, PluginException {
        Enumeration<EventPlugin> e = this.eventPlugins.elements();
        while (e.hasMoreElements()) {
            EventPlugin plugin = e.nextElement();
            ((EventCallback)plugin.getCallback()).error(user, statstring, ping, flags);
        }
    }

    public void info(String user, String statstring, int ping, int flags) throws IOException, PluginException {
        Enumeration<EventPlugin> e = this.eventPlugins.elements();
        while (e.hasMoreElements()) {
            EventPlugin plugin = e.nextElement();
            ((EventCallback)plugin.getCallback()).info(user, statstring, ping, flags);
        }
    }

    public void broadcast(String user, String statstring, int ping, int flags) throws IOException, PluginException {
        Enumeration<EventPlugin> e = this.eventPlugins.elements();
        while (e.hasMoreElements()) {
            EventPlugin plugin = e.nextElement();
            ((EventCallback)plugin.getCallback()).broadcast(user, statstring, ping, flags);
        }
    }

    public void channel(String user, String statstring, int ping, int flags) throws IOException, PluginException {
        Enumeration<EventPlugin> e = this.eventPlugins.elements();
        while (e.hasMoreElements()) {
            EventPlugin plugin = e.nextElement();
            ((EventCallback)plugin.getCallback()).channel(user, statstring, ping, flags);
        }
    }

    public String queuingText(String text) {
        Enumeration<OutgoingTextPlugin> e = this.outgoingTextPlugins.elements();
        while (e.hasMoreElements()) {
            OutgoingTextPlugin plugin = e.nextElement();
            text = ((OutgoingTextCallback)plugin.getCallback()).queuingText(text, plugin.getData());
            if (text != null) continue;
            return null;
        }
        return text;
    }

    public void queuedText(String text) {
        Enumeration<OutgoingTextPlugin> e = this.outgoingTextPlugins.elements();
        while (e.hasMoreElements()) {
            OutgoingTextPlugin plugin = e.nextElement();
            ((OutgoingTextCallback)plugin.getCallback()).queuedText(text, plugin.getData());
        }
    }

    public String nextInLine(String text) {
        Enumeration<OutgoingTextPlugin> e = this.outgoingTextPlugins.elements();
        while (e.hasMoreElements()) {
            OutgoingTextPlugin plugin = e.nextElement();
            text = ((OutgoingTextCallback)plugin.getCallback()).nextInLine(text, plugin.getData());
            if (text != null) continue;
            return null;
        }
        return text;
    }

    public long getDelay(String text) {
        Enumeration<OutgoingTextPlugin> e = this.outgoingTextPlugins.elements();
        long delay = 0L;
        while (e.hasMoreElements()) {
            OutgoingTextPlugin plugin = e.nextElement();
            delay += ((OutgoingTextCallback)plugin.getCallback()).getDelay(text, plugin.getData());
        }
        return delay > 0L ? delay : 0L;
    }

    public boolean sendingText(String text) {
        Enumeration<OutgoingTextPlugin> e = this.outgoingTextPlugins.elements();
        while (e.hasMoreElements()) {
            OutgoingTextPlugin plugin = e.nextElement();
            if (((OutgoingTextCallback)plugin.getCallback()).sendingText(text, plugin.getData())) continue;
            return false;
        }
        return true;
    }

    public void sentText(String text) {
        Enumeration<OutgoingTextPlugin> e = this.outgoingTextPlugins.elements();
        while (e.hasMoreElements()) {
            OutgoingTextPlugin plugin = e.nextElement();
            ((OutgoingTextCallback)plugin.getCallback()).sentText(text, plugin.getData());
        }
    }

    public BnetPacket processingIncomingPacket(BnetPacket buf) throws IOException, PluginException {
        int code = buf.getCode() & 0xFF;
        if (this.incomingPacketPlugins[code] == null) {
            if (code != 15) {
                this.unknownPacketReceived(buf);
                return null;
            }
            return buf;
        }
        Enumeration<PacketPlugin> e = this.incomingPacketPlugins[code].elements();
        while (e.hasMoreElements()) {
            PacketPlugin plugin = e.nextElement();
            buf = ((PacketCallback)plugin.getCallback()).processingPacket(new BnetPacket(buf), plugin.getData());
            if (buf != null) continue;
            return null;
        }
        return buf;
    }

    public void processedIncomingPacket(BnetPacket buf) throws IOException, PluginException {
        int code = buf.getCode() & 0xFF;
        if (this.incomingPacketPlugins[code] == null) {
            return;
        }
        Enumeration<PacketPlugin> e = this.incomingPacketPlugins[code].elements();
        while (e.hasMoreElements()) {
            PacketPlugin plugin = e.nextElement();
            ((PacketCallback)plugin.getCallback()).processedPacket(new BnetPacket(buf), plugin.getData());
        }
    }

    public BnetPacket processingOutgoingPacket(BnetPacket buf) throws IOException, PluginException {
        int code = buf.getCode() & 0xFF;
        if (this.outgoingPacketPlugins[code] == null) {
            return buf;
        }
        Enumeration<PacketPlugin> e = this.outgoingPacketPlugins[code].elements();
        while (e.hasMoreElements()) {
            PacketPlugin plugin = e.nextElement();
            buf = ((PacketCallback)plugin.getCallback()).processingPacket(buf, plugin.getData());
            if (buf != null) continue;
            return null;
        }
        return buf;
    }

    public void processedOutgoingPacket(BnetPacket buf) throws IOException, PluginException {
        int code = buf.getCode() & 0xFF;
        if (this.outgoingPacketPlugins[code] == null) {
            return;
        }
        Enumeration<PacketPlugin> e = this.outgoingPacketPlugins[code].elements();
        while (e.hasMoreElements()) {
            PacketPlugin plugin = e.nextElement();
            ((PacketCallback)plugin.getCallback()).processedPacket(new BnetPacket(buf), plugin.getData());
        }
    }

    public void systemMessage(int level, String message) {
        Enumeration<SystemMessagePlugin> e = this.systemMessagePlugins.elements();
        while (e.hasMoreElements()) {
            SystemMessagePlugin plugin = e.nextElement();
            if (level < plugin.getMinLevel() || level > plugin.getMaxLevel()) continue;
            ((SystemMessageCallback)plugin.getCallback()).systemMessage(level, message, plugin.getData());
        }
    }

    public void showMessage(String message) {
        Enumeration<SystemMessagePlugin> e = this.systemMessagePlugins.elements();
        while (e.hasMoreElements()) {
            SystemMessagePlugin plugin = e.nextElement();
            ((SystemMessageCallback)plugin.getCallback()).showMessage(message, plugin.getData());
        }
    }

    public void menuItemAdded(String name, String whichMenu, int index, char mnemonic, KeyStroke hotkey, Icon icon, ActionListener callback) {
        Enumeration<GuiPlugin> e = this.guiPlugins.elements();
        while (e.hasMoreElements()) {
            GuiPlugin plugin = e.nextElement();
            ((GuiCallback)plugin.getCallback()).menuItemAdded(name, whichMenu, index, mnemonic, hotkey, icon, callback, plugin.getData());
        }
    }

    public void menuItemRemoved(String name, String whichMenu) {
        Enumeration<GuiPlugin> e = this.guiPlugins.elements();
        while (e.hasMoreElements()) {
            GuiPlugin plugin = e.nextElement();
            ((GuiCallback)plugin.getCallback()).menuItemRemoved(name, whichMenu, plugin.getData());
        }
    }

    public void menuSeparatorAdded(String whichMenu) {
        Enumeration<GuiPlugin> e = this.guiPlugins.elements();
        while (e.hasMoreElements()) {
            GuiPlugin plugin = e.nextElement();
            ((GuiCallback)plugin.getCallback()).menuSeparatorAdded(whichMenu, plugin.getData());
        }
    }

    public void menuAdded(String name, int index, char mnemonic, Icon icon, ActionListener callback) {
        Enumeration<GuiPlugin> e = this.guiPlugins.elements();
        while (e.hasMoreElements()) {
            GuiPlugin plugin = e.nextElement();
            ((GuiCallback)plugin.getCallback()).menuAdded(name, index, mnemonic, icon, callback, plugin.getData());
        }
    }

    public void menuRemoved(String name) {
        Enumeration<GuiPlugin> e = this.guiPlugins.elements();
        while (e.hasMoreElements()) {
            GuiPlugin plugin = e.nextElement();
            ((GuiCallback)plugin.getCallback()).menuRemoved(name, plugin.getData());
        }
    }

    public void userMenuAdded(String name, int index, Icon icon, ActionListener callback) {
        Enumeration<GuiPlugin> e = this.guiPlugins.elements();
        while (e.hasMoreElements()) {
            GuiPlugin plugin = e.nextElement();
            ((GuiCallback)plugin.getCallback()).userMenuAdded(name, index, icon, callback, plugin.getData());
        }
    }

    public void userMenuRemoved(String name) {
        Enumeration<GuiPlugin> e = this.guiPlugins.elements();
        while (e.hasMoreElements()) {
            GuiPlugin plugin = e.nextElement();
            ((GuiCallback)plugin.getCallback()).userMenuRemoved(name, plugin.getData());
        }
    }

    public void userMenuSeparatorAdded() {
        Enumeration<GuiPlugin> e = this.guiPlugins.elements();
        while (e.hasMoreElements()) {
            GuiPlugin plugin = e.nextElement();
            ((GuiCallback)plugin.getCallback()).userMenuSeparatorAdded(plugin.getData());
        }
    }

    public void userAdded(String username, String flags) {
        Enumeration<UserDatabasePlugin> e = this.userDatabasePlugins.elements();
        while (e.hasMoreElements()) {
            UserDatabasePlugin plugin = e.nextElement();
            ((UserDatabaseCallback)plugin.getCallback()).userAdded(username, flags, plugin.getData());
        }
    }

    public void userChanged(String username, String oldFlags, String newFlags) {
        Enumeration<UserDatabasePlugin> e = this.userDatabasePlugins.elements();
        while (e.hasMoreElements()) {
            UserDatabasePlugin plugin = e.nextElement();
            ((UserDatabaseCallback)plugin.getCallback()).userChanged(username, oldFlags, newFlags, plugin.getData());
        }
    }

    public void userRemoved(String username, String oldFlags) {
        Enumeration<UserDatabasePlugin> e = this.userDatabasePlugins.elements();
        while (e.hasMoreElements()) {
            UserDatabasePlugin plugin = e.nextElement();
            ((UserDatabaseCallback)plugin.getCallback()).userAdded(username, oldFlags, plugin.getData());
        }
    }

    public void illegalCommandUsed(String user, String userFlags, String requiredFlags, String command) {
        Enumeration<UserErrorPlugin> e = this.userErrorPlugins.elements();
        while (e.hasMoreElements()) {
            UserErrorPlugin plugin = e.nextElement();
            ((UserErrorCallback)plugin.getCallback()).illegalCommandUsed(user, userFlags, requiredFlags, command, plugin.getData());
        }
    }

    public void unknownCommandUsed(String user, String command) {
        Enumeration<UserErrorPlugin> e = this.userErrorPlugins.elements();
        while (e.hasMoreElements()) {
            UserErrorPlugin plugin = e.nextElement();
            ((UserErrorCallback)plugin.getCallback()).nonExistantCommandUsed(user, command, plugin.getData());
        }
    }

    public void commandUsedImproperly(String user, String command, String syntaxUsed, String errorMessage) {
        Enumeration<UserErrorPlugin> e = this.userErrorPlugins.elements();
        while (e.hasMoreElements()) {
            UserErrorPlugin plugin = e.nextElement();
            ((UserErrorCallback)plugin.getCallback()).commandUsedImproperly(user, command, syntaxUsed, errorMessage, plugin.getData());
        }
    }
}

