/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.pluginmanagers;

import com.javaop.bot.BotCoreStatic;
import com.javaop.bot.JavaOpFileStuff;
import com.javaop.bot.PluginMain;
import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.util.ErrorMessage;
import com.javaop.util.RelativeFile;
import com.javaop.util.Uniq;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.jar.Attributes;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class PluginManager {
    private static Hashtable<String, GenericPluginInterface> allPlugins = new Hashtable();
    private Hashtable<String, GenericPluginInterface> activePlugins = new Hashtable();

    public static void initialize(boolean load) {
        try {
            String[] searchPaths = JavaOpFileStuff.getAllPlugins();
            int i = 0;
            while (i < searchPaths.length) {
                PluginManager.loadFile(searchPaths[i], load);
                ++i;
            }
            if (allPlugins.size() == 0) {
                ErrorMessage.error("Unable to find any plugins.\nPlease download the plugin package from \nhttp://javaop.googlecode.com\nand extract them somewhere. You will be prompted to find them.", false);
                try {
                    JFileChooser chooser = new JFileChooser(new RelativeFile(""));
                    chooser.setFileSelectionMode(1);
                    chooser.setDialogTitle("Please choose the folder where the plugins were extracted to (in the future, place all plugins in this folder!)");
                    int selection = chooser.showOpenDialog(null);
                    if (selection == 1) {
                        JOptionPane.showMessageDialog(null, "The plugin folder must be selected before the bot can load.");
                        System.exit(1);
                    }
                    JavaOpFileStuff.addPluginPath(chooser.getSelectedFile().getAbsolutePath());
                }
                catch (Throwable e) {
                    System.err.print("Unable to find any plugins.  Please enter the path where the plugins can be found --> ");
                    String path = new BufferedReader(new InputStreamReader(System.in)).readLine();
                    JavaOpFileStuff.addPluginPath(path);
                }
                searchPaths = JavaOpFileStuff.getAllPlugins();
                i = 0;
                while (i < searchPaths.length) {
                    PluginManager.loadFile(searchPaths[i], load);
                    ++i;
                }
            }
            PluginMain defaultPlugin = new PluginMain();
            allPlugins.put(((GenericPluginInterface)defaultPlugin).getName(), defaultPlugin);
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                JOptionPane.showMessageDialog(null, e.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void loadFile(String url, boolean load) {
        try {
            PluginManager.loadFile(new URL(url), load);
        }
        catch (MalformedURLException e) {
            try {
                PluginManager.loadFile(new URL("jar:file:///" + url + "!/"), load);
            }
            catch (MalformedURLException e2) {
                System.err.println("--> Unable to load plugin: " + url);
                System.out.println(e);
                System.out.println(e2);
            }
        }
    }

    private static void loadFile(URL url, boolean load) {
        String mainClass = "PluginMain";
        try {
            URL[] urls = new URL[]{url};
            URLClassLoader ucl = new URLClassLoader(urls);
            JarURLConnection uc = (JarURLConnection)url.openConnection();
            Attributes attr = uc.getMainAttributes();
            if (attr != null) {
                mainClass = attr.getValue(Attributes.Name.MAIN_CLASS);
            }
            System.out.println("Loading plugin: " + mainClass);
            Class<?> cl = ucl.loadClass(mainClass);
            GenericPluginInterface plugin = (GenericPluginInterface)cl.newInstance();
            allPlugins.put(plugin.getName(), plugin);
            if (load) {
                plugin.load(BotCoreStatic.getInstance());
            }
            plugin.setGlobalDefaultSettings(BotCoreStatic.getInstance());
        }
        catch (ClassNotFoundException e) {
            System.err.println("   --> Load failed (Plugin '" + url + "' doesn't have main class: " + mainClass);
            System.err.println(e);
            e.printStackTrace();
        }
        catch (ClassCastException e) {
            System.err.println("   --> Load failed (Plugin '" + url + "''s main class doesn't implement PluginInterface");
        }
        catch (Exception e) {
            System.err.println("Unable to load plugin file: " + url);
            e.printStackTrace();
        }
    }

    public void activatePlugins(PublicExposedFunctions out, PluginCallbackRegister register) throws IOException {
        GenericPluginInterface plugin;
        Enumeration<GenericPluginInterface> e = allPlugins.elements();
        while (e.hasMoreElements()) {
            try {
                plugin = (GenericPluginInterface)e.nextElement().getClass().newInstance();
                out.pluginSetDefaultSettings(plugin.getName());
                if (!JavaOpFileStuff.isActivePlugin(out.getName(), plugin.getName())) {
                    if (plugin.getName().equalsIgnoreCase("Battle.net Login Plugin")) {
                        out.systemMessage(6, "WARNING!!! BATTLE.NET LOGIN PLUGIN IS DISABLED!! BOT WILL NOT WORK");
                    }
                    if (!plugin.getName().equalsIgnoreCase("SwingGui")) continue;
                    out.systemMessage(7, "WARNING!!! SWING GUI PLUGIN IS DISABLED!");
                    continue;
                }
                System.out.println("Activating plugin: " + plugin.getName());
                plugin.activate(out, register);
                this.activePlugins.put(plugin.getName(), plugin);
            }
            catch (IllegalAccessException exc) {
                System.err.println("Unable to load plugin:");
                exc.printStackTrace();
            }
            catch (InstantiationException exc) {
                System.err.println("Unable to load plugin:");
                exc.printStackTrace();
            }
        }
        if (this.activePlugins.size() < 2) {
            e = allPlugins.elements();
            while (e.hasMoreElements()) {
                try {
                    plugin = (GenericPluginInterface)e.nextElement().getClass().newInstance();
                    System.out.println("Plugin: " + plugin.getName());
                }
                catch (IllegalAccessException exc) {
                    System.err.println("Unable to load plugin:");
                    exc.printStackTrace();
                }
                catch (InstantiationException exc) {
                    System.err.println("Unable to load plugin:");
                    exc.printStackTrace();
                }
            }
            out.systemMessage(7, "It appears that this bot is new. The important plugins have been enabled.  To connect, please select 'Configure' under the 'Settings' menu, click on 'Battle.net Login Plugin', and fill in your username, password, cdkey, and game client. Then, under the 'Connection' menu, choose 'Connect'");
        }
    }

    public void deactivatePlugins(PluginCallbackRegister register) {
        Enumeration<GenericPluginInterface> e = this.activePlugins.elements();
        while (e.hasMoreElements()) {
            e.nextElement().deactivate(register);
        }
    }

    public static String[] getAllNames() {
        return Uniq.uniq(allPlugins.keys());
    }

    public static GenericPluginInterface getPlugin(String name) {
        return allPlugins.get(name);
    }
}

