/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.plugin_interfaces;

import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.util.Uniq;
import com.javaop.util.gui.PreferencesPanel;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class GenericPluginInterface {
    public abstract void load(StaticExposedFunctions var1);

    public abstract void activate(PublicExposedFunctions var1, PluginCallbackRegister var2);

    public abstract void deactivate(PluginCallbackRegister var1);

    public abstract String getName();

    public abstract String getVersion();

    public abstract String getAuthorName();

    public abstract String getAuthorWebsite();

    public abstract String getAuthorEmail();

    public abstract String getLongDescription();

    public abstract Properties getDefaultSettingValues();

    public abstract Properties getSettingsDescription();

    public abstract JComponent getComponent(String var1, String var2);

    public abstract Properties getGlobalDefaultSettingValues();

    public abstract Properties getGlobalSettingsDescription();

    public abstract JComponent getGlobalComponent(String var1, String var2);

    public Hashtable<String, JComponent> getComponents(Properties values) {
        String[] keys = Uniq.uniq(this.getDefaultSettingValues().keys());
        Hashtable<String, JComponent> ret = new Hashtable<String, JComponent>();
        int i = 0;
        while (i < keys.length) {
            JComponent component = this.getComponent(keys[i], values.getProperty(keys[i].toLowerCase()));
            if (component == null) {
                component = new JTextField(values.getProperty(keys[i].toLowerCase()));
            }
            ret.put(keys[i], component);
            ++i;
        }
        return ret;
    }

    public Hashtable<String, JComponent> getGlobalComponents(Properties values) {
        String[] keys = Uniq.uniq(this.getGlobalDefaultSettingValues().keys());
        Hashtable<String, JComponent> ret = new Hashtable<String, JComponent>();
        int i = 0;
        while (i < keys.length) {
            JComponent component = this.getGlobalComponent(keys[i], values.getProperty(keys[i].toLowerCase()));
            if (component == null) {
                component = new JTextField(values.getProperty(keys[i].toLowerCase()));
            }
            ret.put(keys[i], component);
            ++i;
        }
        return ret;
    }

    public JPanel getPreferenceImplementation(Properties currentSettings, Properties defaultSettings, Properties descriptions, Hashtable<String, JComponent> components) {
        return new PreferencesPanel(currentSettings, defaultSettings, descriptions, components);
    }

    public JPanel getGlobalPreferenceImplementation(Properties currentSettings, Properties defaultSettings, Properties descriptions, Hashtable<String, JComponent> components) {
        return new PreferencesPanel(currentSettings, defaultSettings, descriptions, components);
    }

    public String getFullName() {
        return String.valueOf(this.getName()) + " v" + this.getVersion();
    }

    public void setDefaultSettings(PublicExposedFunctions out) {
        Properties props = this.getDefaultSettingValues();
        String[] defaultSettings = Uniq.uniq(props.keys());
        int i = 0;
        while (i < defaultSettings.length) {
            out.getLocalSettingDefault(this.getName(), defaultSettings[i], props.getProperty(defaultSettings[i]));
            ++i;
        }
    }

    public void setGlobalDefaultSettings(StaticExposedFunctions funcs) {
        Properties props = this.getGlobalDefaultSettingValues();
        String[] defaultSettings = Uniq.uniq(props.keys());
        int i = 0;
        while (i < defaultSettings.length) {
            funcs.getGlobalSettingDefault(this.getName(), defaultSettings[i], props.getProperty(defaultSettings[i]));
            ++i;
        }
    }

    public String toString() {
        return "Plugin: " + this.getFullName();
    }
}

