/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.bot;

import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.pluginmanagers.PluginRegistration;
import com.javaop.util.BnetPacket;
import com.javaop.util.ChatMessage;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;

public class Queue {
    private final PublicExposedFunctions out;
    private final PluginRegistration plugins;
    private final TreeSet<ChatMessage> queue = new TreeSet();
    private final Timer timer = new Timer();
    private TimerTask current = null;
    private ChatMessage up = null;

    public Queue(PublicExposedFunctions out, PluginRegistration plugins) {
        this.out = out;
        this.plugins = plugins;
    }

    public synchronized void send(String text, int priority) {
        if ((text = this.plugins.queuingText(text)) == null) {
            return;
        }
        this.queue.add(new ChatMessage(text, priority));
        this.plugins.queuedText(text);
        this.scheduleNext();
    }

    public synchronized void scheduleNext() {
        String text = null;
        do {
            if (this.up != null) {
                return;
            }
            if (this.queue.size() == 0) {
                return;
            }
            this.up = this.queue.first();
            this.queue.remove(this.up);
        } while ((text = this.plugins.nextInLine(this.up.getText())) == null);
        this.up = new ChatMessage(text, this.up.getPriority());
        long delay = this.plugins.getDelay(this.up.getText());
        this.current = new QueueTask();
        this.timer.schedule(this.current, delay);
    }

    public synchronized void clear() {
        if (this.current != null) {
            this.current.cancel();
        }
        this.queue.clear();
        this.up = null;
        this.current = null;
    }

    private class QueueTask
    extends TimerTask {
        private QueueTask() {
        }

        @Override
        public void run() {
            try {
                if (Queue.this.out.isLocked()) {
                    Queue.this.out.systemMessage(4, "Output locked; message cancelled:");
                    Queue.this.out.systemMessage(4, Queue.this.up.getText());
                } else {
                    BnetPacket command = new BnetPacket(14);
                    command.addNTString(Queue.this.up.getText());
                    if (Queue.this.plugins.sendingText(Queue.this.up.getText())) {
                        Queue.this.out.sendPacket(command);
                        Queue.this.plugins.sentText(Queue.this.up.getText());
                    }
                }
                Queue.this.up = null;
                Queue.this.scheduleNext();
            }
            catch (IOException e) {
                Queue.this.out.systemMessage(5, "Unable to send packet: " + e);
            }
        }
    }
}

