/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.bot;

import com.javaop.bot.BotManager;
import com.javaop.bot.PluginMain;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.util.FileManagement;
import com.javaop.util.PersistantMap;
import com.javaop.util.RelativeFile;
import com.javaop.util.Uniq;
import com.javaop.util.UserDB;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Vector;

public class JavaOpFileStuff {
    public static final String EXT_SETTINGS = ".jbb";
    public static final String EXT_SETTINGS_MATCH = ".*\\.jbb";
    public static final String EXT_DATABASE = ".jdb";
    public static final String EXT_DATABASE_MATCH = ".*\\.jdb";
    public static final String EXT_PLUGIN = ".plugin";
    public static final String EXT_PLUGIN_MATCH = ".*\\.plugin";
    public static final String EXT_ALIASES = ".aliases";
    public static final String EXT_CUSTOMFLAGS = ".flags";
    public static final String GLOBAL_SETTINGS = "_GlobalSettings.txt";
    public static final String PLUGIN_PATHS = "_PluginPaths.txt";
    public static final String DEFAULT_BOTS = "_DefaultBots.txt";

    public static void setBaseDirectory() {
        System.setProperty("user.dir", String.valueOf(System.getProperty("user.home")) + "/.javaop2");
    }

    public static File getDefaultBotsFile() {
        return new RelativeFile(DEFAULT_BOTS);
    }

    public static File getPluginPathsFile() {
        return new RelativeFile(PLUGIN_PATHS);
    }

    public static File getPluginFile(String name) {
        return new RelativeFile(String.valueOf(name) + EXT_PLUGIN);
    }

    public static File getAliasesFile(String name) {
        return new RelativeFile(String.valueOf(name) + EXT_ALIASES);
    }

    public static File getCustomFlagsFile(String name) {
        return new RelativeFile(String.valueOf(name) + EXT_CUSTOMFLAGS);
    }

    public static String[] getRawPluginPaths() {
        return Uniq.uniq(JavaOpFileStuff.getPluginPaths());
    }

    public static void addPluginPath(String plugin) {
        try {
            FileManagement.addLine(JavaOpFileStuff.getPluginPathsFile(), plugin);
        }
        catch (IOException e) {
            System.err.println("Error adding plugin path: " + e);
            System.exit(0);
            throw new RuntimeException();
        }
    }

    public static void removePluginPath(String plugin) {
        try {
            FileManagement.removeLine(JavaOpFileStuff.getPluginPathsFile(), plugin);
        }
        catch (IOException e) {
            System.err.println("Error removing plugin path: " + e);
            System.exit(0);
            throw new RuntimeException();
        }
    }

    public static String[] getAllPlugins() {
        String[] paths = Uniq.uniq(JavaOpFileStuff.getPluginPaths());
        Vector<File> jars = new Vector<File>();
        int i = 0;
        while (i < paths.length) {
            jars.addAll(FileManagement.search(new RelativeFile(paths[i]), ".*\\.jar"));
            ++i;
        }
        return Uniq.uniq(jars);
    }

    private static Vector<String> getPluginPaths() {
        try {
            RelativeFile pluginFile = new RelativeFile(PLUGIN_PATHS);
            Vector<String> ret = FileManagement.getFile(pluginFile);
            if (ret == null) {
                System.err.println("Plugin paths file not found -- using defaults (" + pluginFile + ")");
            }
            JavaOpFileStuff.addIfExists(ret, new RelativeFile("Plugins"));
            JavaOpFileStuff.addIfExists(ret, new File("C:\\JavaOp-Plugins"));
            JavaOpFileStuff.addIfExists(ret, new File("C:\\Program Files\\JavaOp2\\JavaOp-Plugins"));
            JavaOpFileStuff.addIfExists(ret, new File("/usr/local/JavaOp-Plugins"));
            return ret;
        }
        catch (IOException e) {
            System.err.println("Error reading plugin paths: " + e);
            System.exit(0);
            throw new RuntimeException();
        }
    }

    private static void addIfExists(Vector v, File f) {
        if (f.exists() && !v.contains(f)) {
            v.add(f);
        }
    }

    public static GenericPluginInterface loadPlugin(String location) throws ClassNotFoundException, MalformedURLException, InstantiationException, IllegalAccessException {
        URL url;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e) {
            url = new URL("file:///" + location);
        }
        return JavaOpFileStuff.loadPlugin(url);
    }

    public static GenericPluginInterface loadPlugin(URL url) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        URL[] urls = new URL[]{url};
        URLClassLoader ucl = new URLClassLoader(urls);
        Class<?> cl = ucl.loadClass("PluginMain");
        return (GenericPluginInterface)cl.newInstance();
    }

    public static String[] getActivePlugins(String bot) {
        try {
            return FileManagement.getUniqueLines(JavaOpFileStuff.getPluginFile(bot));
        }
        catch (IOException e) {
            System.err.println("Error getting active plugins: " + e);
            System.exit(0);
            throw new RuntimeException();
        }
    }

    public static void setActivePlugins(String bot, String[] plugins) {
        FileManagement.deleteFile(JavaOpFileStuff.getPluginFile(bot));
        int i = 0;
        while (i < plugins.length) {
            JavaOpFileStuff.addActivePlugin(bot, plugins[i]);
            ++i;
        }
    }

    public static boolean isActivePlugin(String bot, String plugin) {
        block3: {
            try {
                if (!plugin.equalsIgnoreCase(new PluginMain().getName())) break block3;
                return true;
            }
            catch (IOException e) {
                System.err.println("Error checking if active plugin: " + e);
                System.exit(0);
                throw new RuntimeException();
            }
        }
        return FileManagement.findLine(JavaOpFileStuff.getPluginFile(bot), plugin);
    }

    public static void addActivePlugin(String bot, String plugin) {
        try {
            if (plugin.equalsIgnoreCase(new PluginMain().getName())) {
                return;
            }
            FileManagement.addLine(JavaOpFileStuff.getPluginFile(bot), plugin);
        }
        catch (IOException e) {
            System.err.println("Error adding active plugin: " + e);
            System.exit(0);
            throw new RuntimeException();
        }
    }

    public static void removeActivePlugin(String bot, String plugin) {
        try {
            if (plugin.equalsIgnoreCase(new PluginMain().getName())) {
                return;
            }
            FileManagement.removeLine(JavaOpFileStuff.getPluginFile(bot), plugin);
        }
        catch (IOException e) {
            System.err.println("Error removing active plugin: " + e);
            System.exit(0);
            throw new RuntimeException();
        }
    }

    public static void toggleActivePlugin(String bot, String plugin) {
        if (plugin.equalsIgnoreCase(new PluginMain().getName())) {
            return;
        }
        if (JavaOpFileStuff.isActivePlugin(bot, plugin)) {
            JavaOpFileStuff.removeActivePlugin(bot, plugin);
        } else {
            JavaOpFileStuff.addActivePlugin(bot, plugin);
        }
    }

    public static String[] getAllBots() {
        String[] bots = Uniq.uniq(FileManagement.search(new RelativeFile(""), EXT_SETTINGS_MATCH));
        int i = 0;
        while (i < bots.length) {
            bots[i] = bots[i].replaceAll("\\.jbb$", "");
            bots[i] = bots[i].replaceAll(".*[\\\\/]", "");
            ++i;
        }
        return bots;
    }

    public static void deleteBot(String name) {
        JavaOpFileStuff.removeDefaultBot(name);
        BotManager.stopBot(name);
        new RelativeFile(String.valueOf(name) + EXT_SETTINGS).delete();
        new RelativeFile(String.valueOf(name) + EXT_DATABASE).delete();
        new RelativeFile(String.valueOf(name) + EXT_ALIASES).delete();
        new RelativeFile(String.valueOf(name) + ".jbb.remote").delete();
        new RelativeFile(String.valueOf(name) + EXT_PLUGIN).delete();
        new RelativeFile(String.valueOf(name) + ".quotes").delete();
        new RelativeFile(String.valueOf(name) + ".seen").delete();
        new RelativeFile(String.valueOf(name) + EXT_CUSTOMFLAGS).delete();
    }

    public static void newBot(String name) {
        JavaOpFileStuff.getSettings(name);
    }

    public static void copyBot(String oldName, String newName) {
        try {
            FileManagement.copyFile(new RelativeFile(String.valueOf(oldName) + EXT_SETTINGS), new RelativeFile(String.valueOf(newName) + EXT_SETTINGS));
            FileManagement.copyFile(new RelativeFile(String.valueOf(oldName) + EXT_ALIASES), new RelativeFile(String.valueOf(newName) + EXT_ALIASES));
            FileManagement.copyFile(new RelativeFile(String.valueOf(oldName) + EXT_DATABASE), new RelativeFile(String.valueOf(newName) + EXT_DATABASE));
            FileManagement.copyFile(new RelativeFile(String.valueOf(oldName) + EXT_PLUGIN), new RelativeFile(String.valueOf(newName) + EXT_PLUGIN));
        }
        catch (IOException e) {
            System.err.println("Error copying bot: " + e);
            System.exit(0);
            throw new RuntimeException();
        }
    }

    public static String[] getDefaultBots() {
        try {
            return FileManagement.getUniqueLines(JavaOpFileStuff.getDefaultBotsFile());
        }
        catch (IOException e) {
            System.err.println("Error getting default bots: " + e);
            System.exit(0);
            throw new RuntimeException();
        }
    }

    public static boolean isDefaultBot(String bot) {
        try {
            return FileManagement.findLine(JavaOpFileStuff.getDefaultBotsFile(), bot);
        }
        catch (IOException e) {
            System.err.println("Error checking if default bot: " + e);
            System.exit(0);
            throw new RuntimeException();
        }
    }

    public static void toggleDefault(String bot) {
        try {
            if (JavaOpFileStuff.isDefaultBot(bot)) {
                FileManagement.removeLine(JavaOpFileStuff.getDefaultBotsFile(), bot);
            } else {
                FileManagement.addLine(JavaOpFileStuff.getDefaultBotsFile(), bot);
            }
        }
        catch (IOException e) {
            System.err.println("Error toggling default bot: " + e);
            System.exit(0);
            throw new RuntimeException();
        }
    }

    public static void setDefaultBots(String[] bots) {
        try {
            FileManagement.setFile(JavaOpFileStuff.getDefaultBotsFile(), bots);
        }
        catch (IOException e) {
            System.err.println("Error setting default bots: " + e);
            System.exit(0);
            throw new RuntimeException();
        }
    }

    public static void addDefaultBot(String bot) {
        try {
            FileManagement.addLine(JavaOpFileStuff.getDefaultBotsFile(), bot);
        }
        catch (IOException e) {
            System.err.println("Error adding default bot: " + e);
            System.exit(0);
            throw new RuntimeException();
        }
    }

    public static void removeDefaultBot(String bot) {
        try {
            FileManagement.removeLine(JavaOpFileStuff.getDefaultBotsFile(), bot);
        }
        catch (IOException e) {
            System.err.println("Error removing default bot: " + e);
            System.exit(0);
            throw new RuntimeException();
        }
    }

    public static PersistantMap getGlobalSettings() {
        return new PersistantMap(new RelativeFile(GLOBAL_SETTINGS), "These are the bot's settings");
    }

    public static PersistantMap getSettings(String botName) {
        return new PersistantMap(new RelativeFile(String.valueOf(botName) + EXT_SETTINGS), "These are the bot's settings");
    }

    public static PersistantMap getAliases(String botName) {
        return new PersistantMap(JavaOpFileStuff.getAliasesFile(botName), "These are the aliases; each line is in the format alias=command");
    }

    public static PersistantMap getCustomFlags(String botName) {
        return new PersistantMap(JavaOpFileStuff.getCustomFlagsFile(botName), "These are customized flags for commands.  You may add 'command=FLAGS' for any command, and it will be overridden.");
    }

    public static UserDB getUserDB(String botName) {
        return new UserDB(new RelativeFile(String.valueOf(botName) + EXT_DATABASE));
    }

    public static File getDB(String bot) {
        return new RelativeFile(String.valueOf(bot) + EXT_DATABASE);
    }
}

