/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.bot;

import com.javaop.bot.BotManager;
import com.javaop.bot.JavaOpFileStuff;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.PluginException;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.pluginmanagers.PluginManager;
import com.javaop.util.PersistantMap;
import com.javaop.util.Uniq;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JComponent;

public class BotCoreStatic
implements StaticExposedFunctions {
    private static final Hashtable<Object, Object> globalVariables = new Hashtable();
    private static final PersistantMap globalSettings = JavaOpFileStuff.getGlobalSettings();
    private static BotCoreStatic instance = new BotCoreStatic();

    private BotCoreStatic() {
    }

    public static BotCoreStatic getInstance() {
        return instance;
    }

    @Override
    public void newBot(String name) throws PluginException {
        this.botStart(name);
        JavaOpFileStuff.setActivePlugins(name, PluginManager.getAllNames());
    }

    @Override
    public void botStart(String name) throws PluginException {
        if (!name.matches("[\\w\\_\\-\\.]+")) {
            throw new PluginException("Bots' names must contain at least one character, and the only characters a-z, A-Z, 0-9, or '.-_'");
        }
        try {
            BotManager.startBot(name);
        }
        catch (IOException e) {
            throw new PluginException(e);
        }
    }

    @Override
    public void botStop(String name) throws IllegalArgumentException {
        BotManager.stopBot(name);
    }

    @Override
    public String[] botGetAllNames() {
        return BotManager.getAllBots();
    }

    @Override
    public String[] botGetActiveNames() {
        return BotManager.getActiveBots();
    }

    @Override
    public PublicExposedFunctions[] botGetAllActive() {
        String[] bots = BotManager.getActiveBots();
        PublicExposedFunctions[] funcs = new PublicExposedFunctions[bots.length];
        int i = 0;
        while (i < funcs.length) {
            funcs[i] = this.botGet(bots[i]);
            ++i;
        }
        return funcs;
    }

    @Override
    public PublicExposedFunctions botGet(String name) {
        return BotManager.getBot(name);
    }

    @Override
    public PersistantMap botGetSettings(String bot) {
        return JavaOpFileStuff.getSettings(bot);
    }

    @Override
    public void systemMessage(int level, String message) {
        PublicExposedFunctions[] bots = this.botGetAllActive();
        int i = 0;
        while (i < bots.length) {
            bots[i].systemMessage(level, message);
            ++i;
        }
    }

    @Override
    public void botDelete(String name) {
        JavaOpFileStuff.deleteBot(name);
    }

    @Override
    public boolean botIsDefault(String name) {
        return JavaOpFileStuff.isDefaultBot(name);
    }

    @Override
    public void botToggleDefault(String name) {
        JavaOpFileStuff.toggleDefault(name);
    }

    @Override
    public PersistantMap getCustomFlags(String bot) {
        return JavaOpFileStuff.getCustomFlags(bot);
    }

    @Override
    public String getVersion() {
        return "2.1.3";
    }

    @Override
    public String getGlobalSetting(String section, String key) {
        return globalSettings.getNoWrite(section, key, null);
    }

    @Override
    public String getGlobalSettingDefault(String section, String key, String defaultValue) {
        if (section == null) {
            section = " default";
        }
        return globalSettings.getWrite(section, key, defaultValue);
    }

    @Override
    public void setGlobalSetting(String section, String key, String value) {
        globalSettings.set(section, key, value);
    }

    @Override
    public Properties getGlobalSection(String section) {
        return globalSettings.getSection(section);
    }

    @Override
    public String[] getGlobalKeys(String section) {
        return Uniq.uniq(globalSettings.propertyNames(section));
    }

    @Override
    public void putGlobalVariable(Object key, Object value) {
        globalVariables.put(key, value);
    }

    @Override
    public Object getGlobalVariable(Object key) {
        return globalVariables.get(key);
    }

    @Override
    public String[] pluginGetNames() {
        return PluginManager.getAllNames();
    }

    @Override
    public GenericPluginInterface pluginGet(String name) {
        return PluginManager.getPlugin(name);
    }

    @Override
    public Properties pluginGetDefaultSettings(String plugin) {
        return this.pluginGet(plugin).getDefaultSettingValues();
    }

    @Override
    public Properties pluginGetGlobalDefaultSettings(String plugin) {
        return this.pluginGet(plugin).getGlobalDefaultSettingValues();
    }

    @Override
    public Properties pluginGetDescriptions(String plugin) {
        return this.pluginGet(plugin).getSettingsDescription();
    }

    @Override
    public Properties pluginGetGlobalDescriptions(String plugin) {
        return this.pluginGet(plugin).getGlobalSettingsDescription();
    }

    @Override
    public Hashtable<String, JComponent> pluginGetComponents(String plugin, Properties values) {
        return this.pluginGet(plugin).getComponents(values);
    }

    @Override
    public Hashtable<String, JComponent> pluginGetGlobalComponents(String plugin, Properties values) {
        return this.pluginGet(plugin).getGlobalComponents(values);
    }

    @Override
    public GenericPluginInterface[] pluginGetAll(boolean includeDefault) {
        String[] names = this.pluginGetNames();
        GenericPluginInterface[] plugins = new GenericPluginInterface[names.length];
        int i = 0;
        while (i < plugins.length) {
            plugins[i] = this.pluginGet(names[i]);
            ++i;
        }
        return plugins;
    }

    @Override
    public String pluginGetFullName(String plugin) {
        return this.pluginGet(plugin).getFullName();
    }

    @Override
    public String pluginGetAuthor(String plugin) {
        return this.pluginGet(plugin).getAuthorName();
    }

    @Override
    public String pluginGetWebsite(String plugin) {
        return this.pluginGet(plugin).getAuthorWebsite();
    }

    @Override
    public String pluginGetEmail(String plugin) {
        return this.pluginGet(plugin).getAuthorEmail();
    }

    @Override
    public String pluginGetLongDescription(String plugin) {
        return this.pluginGet(plugin).getLongDescription();
    }
}

