/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.bot;

import com.javaop.bot.BotCoreStatic;
import com.javaop.bot.BotManager;
import com.javaop.bot.JavaOpFileStuff;
import com.javaop.bot.PacketThread;
import com.javaop.bot.Queue;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.CommandUsedIllegally;
import com.javaop.exceptions.CommandUsedImproperly;
import com.javaop.exceptions.PluginException;
import com.javaop.pluginmanagers.PluginManager;
import com.javaop.pluginmanagers.PluginRegistration;
import com.javaop.users.UserList;
import com.javaop.util.BnetPacket;
import com.javaop.util.Buffer;
import com.javaop.util.ColorConstants;
import com.javaop.util.PersistantMap;
import com.javaop.util.Splitter;
import com.javaop.util.Uniq;
import com.javaop.util.User;
import com.javaop.util.UserDB;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class BotCore
implements PublicExposedFunctions {
    protected final PersistantMap localSettings;
    protected final UserDB userDB;
    protected final Hashtable<Object, Object> localVariables;
    protected final PluginRegistration callbacks;
    protected final String botname;
    protected final UserList users;
    protected String channelName = "<not logged in>";
    protected final Timer timer;
    protected final Hashtable<TimerTask, JOTimerTask> timerTasks = new Hashtable();
    protected final PluginManager plugins;
    protected PacketThread packetThread = null;
    private boolean running = true;
    private boolean locked = true;
    private final Queue queue;
    private JTextField chatboxInput;

    public BotCore(String botname) throws IOException, PluginException {
        this.botname = botname;
        this.users = new UserList();
        this.localVariables = new Hashtable();
        this.callbacks = new PluginRegistration(this);
        this.timer = new Timer();
        this.localSettings = JavaOpFileStuff.getSettings(botname);
        this.userDB = JavaOpFileStuff.getUserDB(botname);
        this.queue = new Queue(this, this.callbacks);
        if (this.localSettings == null) {
            throw new IOException("Unable to load the settings file for bot " + botname);
        }
        if (this.userDB == null) {
            throw new IOException("Unable to load the user database for bot " + botname);
        }
        this.plugins = new PluginManager();
        this.plugins.activatePlugins(this, this.callbacks);
        this.callbacks.botInstanceStarting();
        this.systemMessage(3, "Bot '" + botname + "' has been started.");
        if (this.getLocalSettingDefault(null, "connect automatically", "false").equalsIgnoreCase("true")) {
            this.connect();
        }
    }

    @Override
    public void sendPacket(Buffer packet) throws IOException {
        this.checkRunning();
        try {
            if (packet instanceof BnetPacket) {
                if ((packet = this.callbacks.processingOutgoingPacket((BnetPacket)packet)) == null) {
                    return;
                }
                this.callbacks.processedOutgoingPacket((BnetPacket)packet);
            }
            this.packetThread.send(packet.getBytes());
        }
        catch (IOException e) {
            throw e;
        }
        catch (PluginException e) {
            this.callbacks.pluginException(e);
        }
        catch (Exception e) {
            this.callbacks.unknownException(e);
        }
        catch (Error e) {
            this.callbacks.error(e);
        }
    }

    @Override
    public void sendTextPriority(String text, int priority) {
        this.checkRunning();
        this.queue.send(text, priority);
    }

    @Override
    public void sendText(String text) {
        this.checkRunning();
        this.queue.send(text, 0);
    }

    @Override
    public void sendTextUser(String user, String text, int loudness) throws IOException {
        this.checkRunning();
        this.sendTextUserPriority(user, text, loudness, 0);
    }

    @Override
    public void sendTextUserPriority(String user, String text, int loudness, int priority) throws IOException {
        Vector splitText;
        this.checkRunning();
        if (user == null) {
            loudness = 3;
        }
        if (loudness == 3) {
            splitText = new Vector();
            splitText.add(text);
        } else {
            splitText = Splitter.split(text, true);
        }
        Enumeration e = splitText.elements();
        while (e.hasMoreElements()) {
            if (loudness == 1) {
                this.queue.send(String.valueOf(user) + ": " + (String)e.nextElement(), priority);
                continue;
            }
            if (loudness == 2) {
                this.queue.send((String)e.nextElement(), priority);
                continue;
            }
            if (loudness == 0) {
                this.queue.send("/w " + user + " " + (String)e.nextElement(), priority);
                continue;
            }
            if (loudness == 3) {
                this.showMessage(String.valueOf(ColorConstants.getColor("Silent message")) + (String)e.nextElement());
                continue;
            }
            this.systemMessage(5, "Unknown 'loudness' setting for message: " + (String)e.nextElement() + " (loudness was " + loudness + ")");
        }
    }

    @Override
    public void schedule(TimerTask task, long interval) {
        JOTimerTask thisTask = new JOTimerTask(task);
        this.timerTasks.put(task, thisTask);
        this.timer.schedule((TimerTask)thisTask, interval, interval);
        this.systemMessage(1, "Scheduled timer: " + task + " (every " + interval + "ms)");
    }

    @Override
    public void unschedule(TimerTask task) {
        JOTimerTask thatTask = this.timerTasks.get(task);
        if (thatTask != null) {
            thatTask.cancel();
        }
        this.timerTasks.remove(task);
        this.systemMessage(1, "Unscheduled timer: " + task);
    }

    @Override
    public void clearQueue() {
        this.checkRunning();
        this.queue.clear();
    }

    @Override
    public StaticExposedFunctions getStaticExposedFunctionsHandle() {
        return BotCoreStatic.getInstance();
    }

    @Override
    public void setTCPNoDelay(boolean noDelay) throws IOException {
        this.checkRunning();
        this.packetThread.setTcpNoDelay(noDelay);
    }

    @Override
    public boolean isLocked() {
        this.checkRunning();
        return this.locked;
    }

    @Override
    public void lock() {
        this.checkRunning();
        this.locked = true;
    }

    @Override
    public void unlock() {
        this.checkRunning();
        this.locked = false;
    }

    @Override
    public void addAlias(String command, String alias) {
        this.callbacks.addAlias(command, alias);
    }

    @Override
    public String[] getAliasesOf(String command) {
        return this.callbacks.getAliasesOf(command);
    }

    @Override
    public String getCommandOf(String alias) {
        return this.callbacks.getCommandOf(alias);
    }

    @Override
    public void removeAlias(String alias) {
        this.callbacks.removeAlias(alias);
    }

    @Override
    public void channelSetName(String name) {
        this.checkRunning();
        this.channelName = name;
    }

    @Override
    public String channelGetName() {
        this.checkRunning();
        return this.channelName;
    }

    @Override
    public int channelGetCount() {
        this.checkRunning();
        return this.users.size();
    }

    @Override
    public void channelClear() {
        this.checkRunning();
        this.users.clear();
    }

    @Override
    public User channelAddUser(String name, int flags, int ping, String message) {
        this.checkRunning();
        return this.users.addUser(name, flags, ping, message);
    }

    @Override
    public User channelRemoveUser(String name) {
        this.checkRunning();
        return this.users.removeUser(name);
    }

    @Override
    public User channelGetUser(String name) {
        this.checkRunning();
        return this.users.getUser(name);
    }

    @Override
    public String[] channelGetList() {
        this.checkRunning();
        return this.users.getList();
    }

    @Override
    public String[] channelGetListWithAny(String flags) {
        this.checkRunning();
        String[] users = this.channelGetList();
        Vector<String> ret = new Vector<String>();
        int i = 0;
        while (i < users.length) {
            if (this.dbHasAny(users[i], flags, false)) {
                ret.add(users[i]);
            }
            ++i;
        }
        return ret.toArray(new String[ret.size()]);
    }

    @Override
    public String[] channelGetListWithAll(String flags) {
        this.checkRunning();
        String[] users = this.channelGetList();
        Vector<String> ret = new Vector<String>();
        int i = 0;
        while (i < users.length) {
            if (this.dbHasAll(users[i], flags)) {
                ret.add(users[i]);
            }
            ++i;
        }
        return ret.toArray(new String[ret.size()]);
    }

    @Override
    public String[] channelGetListWithoutAny(String flags) {
        this.checkRunning();
        String[] users = this.channelGetList();
        Vector<String> ret = new Vector<String>();
        int i = 0;
        while (i < users.length) {
            if (!this.dbHasAny(users[i], flags, false)) {
                ret.add(users[i]);
            }
            ++i;
        }
        return ret.toArray(new String[ret.size()]);
    }

    @Override
    public String[] channelMatchGetList(String pattern) {
        this.checkRunning();
        return this.users.matchNames(pattern);
    }

    @Override
    public String[] channelMatchGetListWithAny(String pattern, String flags) {
        this.checkRunning();
        String[] users = this.channelMatchGetList(pattern);
        Vector<String> ret = new Vector<String>();
        int i = 0;
        while (i < users.length) {
            if (this.dbHasAny(users[i], flags, false)) {
                ret.add(users[i]);
            }
            ++i;
        }
        return ret.toArray(new String[ret.size()]);
    }

    @Override
    public String[] channelMatchGetListWithAll(String pattern, String flags) {
        this.checkRunning();
        String[] users = this.channelMatchGetList(pattern);
        Vector<String> ret = new Vector<String>();
        int i = 0;
        while (i < users.length) {
            if (this.dbHasAll(users[i], flags)) {
                ret.add(users[i]);
            }
            ++i;
        }
        return ret.toArray(new String[ret.size()]);
    }

    @Override
    public String[] channelMatchGetListWithoutAny(String pattern, String flags) {
        this.checkRunning();
        String[] users = this.channelMatchGetList(pattern);
        Vector<String> ret = new Vector<String>();
        int i = 0;
        while (i < users.length) {
            if (!this.dbHasAny(users[i], flags, false)) {
                ret.add(users[i]);
            }
            ++i;
        }
        return ret.toArray(new String[ret.size()]);
    }

    public void stop() {
        this.checkRunning();
        this.lock();
        try {
            this.callbacks.botInstanceStopping();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.packetThread != null) {
            this.packetThread.stopThread();
        }
        if (this.plugins != null) {
            this.plugins.deactivatePlugins(this.callbacks);
        }
        this.localVariables.clear();
        this.users.clear();
        this.running = false;
    }

    public void killInstance() throws Exception {
        this.checkRunning();
        this.killInstance(this.getName());
    }

    public void killInstance(String name) throws Exception {
        this.checkRunning();
        BotManager.stopBot(name);
    }

    public void startInstance(String name) throws Exception {
        this.checkRunning();
        BotManager.startBot(name);
    }

    public String[] getRunningBots() {
        this.checkRunning();
        return BotManager.getActiveBots();
    }

    public String[] getAllBots() {
        this.checkRunning();
        return BotManager.getAllBots();
    }

    @Override
    public void talk(String user, String message, int ping, int flags) throws IOException, PluginException {
        this.checkRunning();
        this.callbacks.talk(user, message, ping, flags);
    }

    @Override
    public void emote(String user, String message, int ping, int flags) throws IOException, PluginException {
        this.checkRunning();
        this.callbacks.emote(user, message, ping, flags);
    }

    @Override
    public void whisperFrom(String user, String message, int ping, int flags) throws IOException, PluginException {
        this.checkRunning();
        this.callbacks.whisperFrom(user, message, ping, flags);
    }

    @Override
    public void whisperTo(String user, String message, int ping, int flags) throws IOException, PluginException {
        this.checkRunning();
        this.callbacks.whisperTo(user, message, ping, flags);
    }

    @Override
    public void userShow(String user, String message, int ping, int flags) throws IOException, PluginException {
        this.checkRunning();
        this.callbacks.userShow(user, message, ping, flags);
    }

    @Override
    public void userJoin(String user, String message, int ping, int flags) throws IOException, PluginException {
        this.checkRunning();
        this.callbacks.userJoin(user, message, ping, flags);
    }

    @Override
    public void userLeave(String user, String message, int ping, int flags) throws IOException, PluginException {
        this.checkRunning();
        this.callbacks.userLeave(user, message, ping, flags);
    }

    @Override
    public void userFlags(String user, String message, int ping, int flags) throws IOException, PluginException {
        this.checkRunning();
        this.callbacks.userFlags(user, message, ping, flags);
    }

    @Override
    public void error(String user, String message, int ping, int flags) throws IOException, PluginException {
        this.checkRunning();
        this.callbacks.error(user, message, ping, flags);
    }

    @Override
    public void info(String user, String message, int ping, int flags) throws IOException, PluginException {
        this.checkRunning();
        this.callbacks.info(user, message, ping, flags);
    }

    @Override
    public void broadcast(String user, String message, int ping, int flags) throws IOException, PluginException {
        this.checkRunning();
        this.callbacks.broadcast(user, message, ping, flags);
    }

    @Override
    public void channel(String user, String message, int ping, int flags) throws IOException, PluginException {
        this.checkRunning();
        this.callbacks.channel(user, message, ping, flags);
    }

    @Override
    public String getLocalSetting(String section, String key) {
        this.checkRunning();
        if (section == null) {
            section = " default";
        }
        if (!this.localSettings.contains(section, key)) {
            this.systemMessage(5, "Attempted to access a missing setting: " + section + " // " + key);
            return null;
        }
        return this.localSettings.getNoWrite(section, key, null);
    }

    @Override
    public String getLocalSettingDefault(String section, String key, String defaultValue) {
        this.checkRunning();
        if (section == null) {
            section = " default";
        }
        return this.localSettings.getWrite(section, key, defaultValue);
    }

    @Override
    public void putLocalSetting(String section, String key, String value) {
        this.checkRunning();
        this.localSettings.set(section, key, value);
    }

    @Override
    public void removeLocalSetting(String section, String key) {
        this.checkRunning();
        this.localSettings.remove(section, key);
    }

    @Override
    public String[] getLocalKeys(String section) {
        this.checkRunning();
        return Uniq.uniq(this.localSettings.propertyNames(section));
    }

    @Override
    public Properties getLocalSettingSection(String section) {
        return this.localSettings.getSection(section);
    }

    @Override
    public void putLocalVariable(Object key, Object value) {
        this.checkRunning();
        this.localVariables.put(key, value);
    }

    @Override
    public Object getLocalVariable(Object key) {
        this.checkRunning();
        return this.localVariables.get(key);
    }

    @Override
    public void dbAddAndRemove(String user, String add, String remove) {
        this.checkRunning();
        String oldFlags = this.dbGetRawFlags(user);
        this.userDB.addFlags(user, add);
        this.userDB.removeFlags(user, remove);
        String newFlags = this.dbGetRawFlags(user);
        if (oldFlags == null || oldFlags.length() == 0) {
            this.callbacks.userAdded(user, newFlags);
        } else if (newFlags == null || newFlags.length() == 0) {
            this.callbacks.userRemoved(user, oldFlags);
        } else {
            this.callbacks.userChanged(user, oldFlags, newFlags);
        }
    }

    @Override
    public void dbAddFlags(String user, String flags) {
        this.checkRunning();
        String oldFlags = this.dbGetRawFlags(user);
        this.userDB.addFlags(user, flags);
        if (oldFlags == null || oldFlags.length() == 0) {
            this.callbacks.userAdded(user, this.dbGetRawFlags(user));
        } else {
            this.callbacks.userChanged(user, oldFlags, this.dbGetRawFlags(user));
        }
    }

    @Override
    public void dbRemoveFlag(String user, char flag) {
        this.checkRunning();
        String oldFlags = this.dbGetRawFlags(user);
        if (oldFlags == null || oldFlags.length() == 0) {
            return;
        }
        this.userDB.removeFlag(user, flag);
        String newFlags = this.dbGetRawFlags(user);
        if (newFlags == null || newFlags.length() == 0) {
            this.callbacks.userRemoved(user, oldFlags);
        } else {
            this.callbacks.userChanged(user, oldFlags, newFlags);
        }
    }

    @Override
    public void dbRemoveFlags(String user, String flags) {
        this.checkRunning();
        int i = 0;
        while (i < flags.length()) {
            this.dbRemoveFlag(user, flags.charAt(i));
            ++i;
        }
    }

    @Override
    public String dbGetRawFlags(String user) {
        this.checkRunning();
        if (user != null && user.equalsIgnoreCase((String)this.getLocalVariable("username"))) {
            return "S";
        }
        return this.userDB.getRawFlags(user);
    }

    @Override
    public String dbGetFlags(String user) {
        this.checkRunning();
        return this.userDB.getFlags(user);
    }

    @Override
    public void dbDeleteUser(String user) {
        this.checkRunning();
        this.userDB.deleteUser(user);
    }

    @Override
    public int dbGetCount() {
        this.checkRunning();
        return this.userDB.getCount();
    }

    @Override
    public boolean dbHasAny(String user, String flagList, boolean allowMOverride) {
        this.checkRunning();
        if (user != null && user.equalsIgnoreCase((String)this.getLocalVariable("username"))) {
            return flagList.indexOf("S") >= 0;
        }
        return this.userDB.hasAny(user, flagList, allowMOverride);
    }

    @Override
    public boolean dbHasAll(String user, String flagList) {
        this.checkRunning();
        if (user != null && user.equalsIgnoreCase((String)this.getLocalVariable("username"))) {
            return flagList.equalsIgnoreCase("S");
        }
        return this.userDB.hasAll(user, flagList);
    }

    @Override
    public boolean dbUserExists(String user) {
        this.checkRunning();
        if (user != null && user.equalsIgnoreCase((String)this.getLocalVariable("username"))) {
            return true;
        }
        return this.userDB.userExists(user);
    }

    @Override
    public String[] dbFindAttr(char flag) {
        this.checkRunning();
        return this.userDB.findAttr(flag);
    }

    @Override
    public String[] dbGetAllUsers() {
        return this.userDB.getUserList();
    }

    public PluginRegistration getCallbacks() {
        this.checkRunning();
        return this.callbacks;
    }

    @Override
    public void systemMessage(int level, String message) {
        this.checkRunning();
        this.callbacks.systemMessage(level, message);
    }

    @Override
    public void showMessage(String message) {
        this.checkRunning();
        this.callbacks.showMessage(message);
    }

    @Override
    public void connect() {
        this.checkRunning();
        this.disconnect();
        this.systemMessage(1, "Entering connect()");
        this.packetThread = new PacketThread(this.callbacks, this);
        this.packetThread.start();
    }

    @Override
    public void disconnect() {
        this.checkRunning();
        this.systemMessage(1, "Entering disconnect()");
        if (!this.callbacks.disconnecting()) {
            return;
        }
        this.lock();
        if (this.packetThread != null) {
            this.packetThread.stopThread();
        }
        if (this.callbacks != null) {
            this.callbacks.disconnected();
        }
    }

    @Override
    public void reconnect() {
        this.connect();
    }

    @Override
    public boolean pluginIsActive(String name) {
        return JavaOpFileStuff.isActivePlugin(this.getName(), name);
    }

    @Override
    public void pluginToggleActive(String name) {
        JavaOpFileStuff.toggleActivePlugin(this.getName(), name);
    }

    @Override
    public void pluginSetActive(String name, boolean active) {
        if (active && JavaOpFileStuff.isActivePlugin(this.getName(), name)) {
            JavaOpFileStuff.removeActivePlugin(this.getName(), name);
        } else if (!active && !JavaOpFileStuff.isActivePlugin(this.getName(), name)) {
            JavaOpFileStuff.addActivePlugin(this.getName(), name);
        }
    }

    @Override
    public void pluginSetDefaultSettings(String plugin) {
        PluginManager.getPlugin(plugin).setDefaultSettings(this);
        PluginManager.getPlugin(plugin).setGlobalDefaultSettings(BotCoreStatic.getInstance());
    }

    @Override
    public boolean raiseCommand(String user, String command, String args, int loudness, boolean errorOnUnknown) throws IOException {
        try {
            return this.callbacks.raiseCommand(user, command, args, loudness, errorOnUnknown);
        }
        catch (CommandUsedIllegally exception) {
            this.exceptionIllegalCommandUsed(user, exception.getUserFlags(), exception.getRequiredFlags(), exception.getCommand());
        }
        catch (CommandUsedImproperly exception) {
            this.exceptionCommandUsedImproperly(exception.getUser(), exception.getCommand(), String.valueOf(command) + " " + args, exception.getMessage());
        }
        catch (PluginException exception) {
            this.callbacks.pluginException(exception);
        }
        catch (Exception e) {
            this.callbacks.unknownException(e);
        }
        return true;
    }

    @Override
    public String[] getCommandList() {
        this.checkRunning();
        return this.callbacks.getCommands();
    }

    @Override
    public String getCommandHelp(String command) {
        this.checkRunning();
        return this.callbacks.getHelp(command);
    }

    @Override
    public String getCommandUsage(String command) {
        this.checkRunning();
        return this.callbacks.getUsage(command);
    }

    @Override
    public String getRequiredFlags(String command) {
        return this.callbacks.getRequiredFlags(command);
    }

    @Override
    public boolean canUse(String user, String command) {
        return this.dbHasAny(user, this.getRequiredFlags(command), true);
    }

    @Override
    public void exceptionIllegalCommandUsed(String user, String userFlags, String requiredFlags, String command) {
        this.callbacks.illegalCommandUsed(user, userFlags, requiredFlags, command);
    }

    @Override
    public void exceptionCommandUsedImproperly(String user, String command, String syntaxUsed, String errorMessage) {
        this.callbacks.commandUsedImproperly(user, command, syntaxUsed, errorMessage);
    }

    @Override
    public void exceptionUnknownCommandUsed(String user, String command) {
        this.callbacks.unknownCommandUsed(user, command);
    }

    @Override
    public void addMenuItem(String name, String whichMenu, char mnemonic, ActionListener callback) {
        this.addMenuItem(name, whichMenu, -1, mnemonic, null, null, callback);
    }

    @Override
    public void addMenuItem(String name, String whichMenu, int index, char mnemonic, KeyStroke hotkey, Icon icon, ActionListener callback) {
        this.callbacks.menuItemAdded(name, whichMenu, index, mnemonic, hotkey, icon, callback);
    }

    @Override
    public void removeMenuItem(String name, String whichMenu) {
        this.callbacks.menuItemRemoved(name, whichMenu);
    }

    @Override
    public void addMenuSeparator(String whichMenu) {
        this.callbacks.menuSeparatorAdded(whichMenu);
    }

    @Override
    public void addMenu(String name, char mnemonic, ActionListener callback) {
        this.addMenu(name, -1, mnemonic, null, callback);
    }

    @Override
    public void addMenu(String name, int index, char mnemonic, Icon icon, ActionListener callback) {
        this.callbacks.menuAdded(name, index, mnemonic, icon, callback);
    }

    @Override
    public void removeMenu(String name) {
        this.callbacks.menuRemoved(name);
    }

    @Override
    public void addUserMenu(String name, ActionListener callback) {
        this.addUserMenu(name, -1, null, callback);
    }

    @Override
    public void addUserMenu(String name, int index, Icon icon, ActionListener callback) {
        this.callbacks.userMenuAdded(name, index, icon, callback);
    }

    @Override
    public void removeUserMenu(String name) {
        this.callbacks.userMenuRemoved(name);
    }

    @Override
    public void addUserMenuSeparator() {
        this.callbacks.userMenuSeparatorAdded();
    }

    private void checkRunning() {
        if (!this.running) {
            throw new Error("Attempting to use a stopped bot instance!");
        }
    }

    @Override
    public String getName() {
        this.checkRunning();
        return this.botname;
    }

    @Override
    public JTextField getChatboxInput() {
        return this.chatboxInput;
    }

    @Override
    public void setChatboxInput(JTextField chatboxInput) {
        this.chatboxInput = chatboxInput;
    }

    private class JOTimerTask
    extends TimerTask {
        private final TimerTask realTimerTask;

        public JOTimerTask(TimerTask realTimerTask) {
            this.realTimerTask = realTimerTask;
        }

        @Override
        public void run() {
            if (!BotCore.this.locked) {
                this.realTimerTask.run();
            }
        }
    }
}

