/*
 * Decompiled with CFR 0.152.
 */
package com.javaop._main;

import com.javaop.bot.JavaOpFileStuff;
import com.javaop.pluginmanagers.PluginManager;
import com.javaop.util.RelativeFile;
import com.javaop.util.gui.Gui;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public class ConfigurePlugins
extends JFrame
implements WindowListener {
    private static final long serialVersionUID = 1L;
    private JList list;
    private boolean dirty = true;
    private DefaultListModel listData;

    public ConfigurePlugins() {
        super("Configure loaded plugins");
        try {
            this.listData = new DefaultListModel();
            String[] files = JavaOpFileStuff.getRawPluginPaths();
            int i = 0;
            while (i < files.length) {
                this.listData.addElement(files[i].toString());
                ++i;
            }
            this.setDefaultCloseOperation(0);
            this.getContentPane().setLayout(new BorderLayout(5, 5));
            this.getContentPane().add((Component)new Form(), "Center");
            this.getContentPane().add((Component)new JLabel(), "North");
            this.getContentPane().add((Component)new JLabel(), "East");
            this.getContentPane().add((Component)new JLabel(), "South");
            this.getContentPane().add((Component)new JLabel(), "West");
            this.setSize(750, 550);
            Gui.center(this);
            this.setVisible(true);
            this.addWindowListener(this);
        }
        catch (Throwable t) {
            t.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error populating plugin list: " + t);
        }
    }

    private void save() throws IOException {
        File pluginFile = JavaOpFileStuff.getPluginPathsFile();
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(pluginFile)));
        Enumeration elements = this.listData.elements();
        while (elements.hasMoreElements()) {
            out.println(elements.nextElement());
        }
        out.close();
        this.dirty = false;
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.dirty) {
            int result = JOptionPane.showConfirmDialog(this, "Do you want to save before exiting?", "Save?", 1);
            if (result == 2) {
                return;
            }
            if (result == 0) {
                try {
                    this.save();
                    System.exit(0);
                }
                catch (IOException exception) {
                    JOptionPane.showMessageDialog(null, "An error occurred writing to the file: " + exception.toString());
                }
            }
        }
        System.exit(0);
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public static void main(String[] args) {
        JavaOpFileStuff.setBaseDirectory();
        PluginManager.initialize(false);
        new ConfigurePlugins();
    }

    private class AddSection
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private JButton addFile;
        private JButton addUrl;
        private JButton remove;
        private JButton save;

        public AddSection() {
            this.setLayout(new GridLayout(0, 3, 5, 5));
            this.add(new JLabel());
            this.addFile = new JButton("Add from file...");
            this.add(this.addFile);
            this.add(new JLabel());
            this.add(new JLabel());
            this.addUrl = new JButton("Add from url...");
            this.add(this.addUrl);
            this.add(new JLabel());
            this.add(new JLabel());
            this.remove = new JButton("Remove");
            this.add(this.remove);
            this.add(new JLabel());
            this.add(new JLabel());
            this.save = new JButton("Save");
            this.add(this.save);
            this.add(new JLabel());
            this.addFile.addActionListener(this);
            this.addUrl.addActionListener(this);
            this.remove.addActionListener(this);
            this.save.addActionListener(this);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 2), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.addFile) {
                JFileChooser chooser = new JFileChooser(new RelativeFile(""));
                chooser.setFileHidingEnabled(false);
                chooser.setMultiSelectionEnabled(true);
                chooser.setFileSelectionMode(2);
                chooser.setFileFilter(new FindJarFiles());
                if (chooser.showOpenDialog(this) == 0) {
                    File[] files = chooser.getSelectedFiles();
                    int i = 0;
                    while (i < files.length) {
                        ConfigurePlugins.this.listData.addElement(files[i].getAbsolutePath());
                        ++i;
                    }
                    ConfigurePlugins.this.dirty = true;
                }
            } else if (e.getSource() == this.addUrl) {
                String input = JOptionPane.showInputDialog(this, (Object)"Please type the url here.");
                if (input != null) {
                    ConfigurePlugins.this.listData.addElement(input);
                    ConfigurePlugins.this.dirty = true;
                }
            } else if (e.getSource() == this.remove) {
                int[] selected = ConfigurePlugins.this.list.getSelectedIndices();
                if (selected != null) {
                    int i = 0;
                    while (i < selected.length) {
                        ConfigurePlugins.this.listData.remove(selected[i]);
                        ++i;
                    }
                    if (selected[0] >= ConfigurePlugins.this.listData.getSize()) {
                        ConfigurePlugins.this.list.setSelectedIndex(ConfigurePlugins.this.listData.getSize() - 1);
                    } else {
                        ConfigurePlugins.this.list.setSelectedIndex(selected[0]);
                    }
                    ConfigurePlugins.this.dirty = true;
                }
            } else if (e.getSource() == this.save) {
                try {
                    ConfigurePlugins.this.save();
                }
                catch (IOException exception) {
                    JOptionPane.showMessageDialog(null, "An error occurred writing to the file: " + exception.toString());
                }
            }
        }
    }

    private class FindJarFiles
    extends javax.swing.filechooser.FileFilter
    implements FileFilter {
        private FindJarFiles() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().matches(".*\\.jar");
        }

        @Override
        public String getDescription() {
            return "JavaOp2 Plugin Files (*.jar)";
        }
    }

    private class Form
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public Form() {
            this.setLayout(new BorderLayout(10, 10));
            this.add((Component)new ListSection(), "Center");
            this.add((Component)new AddSection(), "South");
        }
    }

    private class ListSection
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public ListSection() {
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)new JLabel("Loaded paths:"), "North");
            JList jList = new JList(ConfigurePlugins.this.listData);
            ConfigurePlugins.this.list = jList;
            this.add((Component)new JScrollPane(jList), "Center");
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 2), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            ConfigurePlugins.this.list.setCellRenderer(new MyCellRenderer());
        }

        private class MyCellRenderer
        implements ListCellRenderer {
            private MyCellRenderer() {
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel c = new JLabel(value.toString());
                ((Component)c).setBackground(Color.WHITE);
                ((Component)c).setForeground(Color.BLACK);
                JPanel ret = new JPanel();
                ret.setLayout(new GridLayout());
                ret.setBackground(Color.WHITE);
                ret.setForeground(Color.BLACK);
                ret.add(c);
                if (isSelected) {
                    ret.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
                } else {
                    ret.setBorder(BorderFactory.createLineBorder(list.getBackground(), 2));
                }
                return ret;
            }
        }
    }
}

