/*
 * Decompiled with CFR 0.152.
 */
package com.javaop._main;

import com.javaop.bot.JavaOpFileStuff;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.pluginmanagers.PluginManager;
import com.javaop.util.PersistantMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class CommandlineConfigure {
    private static final boolean CLEAR = true;
    private static BufferedReader in = new BufferedReader(new InputStreamReader(System.in));

    public static void main(String[] args) throws IOException {
        JavaOpFileStuff.setBaseDirectory();
        PluginManager.initialize(false);
        while (true) {
            CommandlineConfigure.clear();
            System.out.println("1. Configure paths searched for plugins");
            System.out.println("2. Configure which bots are loaded");
            System.out.println("3. Manage bots");
            System.out.println("4. Add a new bot");
            System.out.println("5. Copy a bot");
            System.out.println("6. Remove a bot");
            System.out.println();
            System.out.println("0. Quit");
            System.out.println();
            int choice = Integer.parseInt(CommandlineConfigure.getPatternInput("Please make a selection", null, "[1234560]"));
            if (choice == 1) {
                CommandlineConfigure.configurePaths();
                continue;
            }
            if (choice == 2) {
                CommandlineConfigure.configureLoadedBots();
                continue;
            }
            if (choice == 3) {
                CommandlineConfigure.manageBots();
                continue;
            }
            if (choice == 4) {
                CommandlineConfigure.addBot();
                continue;
            }
            if (choice == 5) {
                CommandlineConfigure.copyBot();
                continue;
            }
            if (choice == 6) {
                CommandlineConfigure.removeBot();
                continue;
            }
            if (choice != 0) continue;
            System.out.println("-- exiting");
            System.exit(0);
        }
    }

    private static void addBot() throws IOException {
        CommandlineConfigure.clear();
        System.out.println("The current bots:");
        CommandlineConfigure.getAndPrintAllBots(false);
        System.out.println();
        String newBot = CommandlineConfigure.getPatternInput("Name of the new bot?", null, "[a-zA-Z1-9. -_]+");
        JavaOpFileStuff.newBot(newBot);
        JavaOpFileStuff.setActivePlugins(newBot, PluginManager.getAllNames());
    }

    private static void copyBot() throws IOException {
        CommandlineConfigure.clear();
        System.out.println("The current bots:");
        String[] bots = CommandlineConfigure.getAndPrintAllBots(true);
        System.out.println();
        System.out.println("0. Back");
        System.out.println();
        int base = CommandlineConfigure.getNumericInput("Which bot are we making a copy of?", null, bots.length);
        if (base == 0) {
            return;
        }
        String newName = CommandlineConfigure.getPatternInput("What would you like to name the copy?", null, "[a-zA-Z1-9. -_]+");
        JavaOpFileStuff.copyBot(bots[base - 1], newName);
    }

    private static void removeBot() throws IOException {
        CommandlineConfigure.clear();
        System.out.println("The current bots:");
        String[] bots = CommandlineConfigure.getAndPrintAllBots(true);
        System.out.println();
        System.out.println("0. Back");
        System.out.println();
        int remove = CommandlineConfigure.getNumericInput("Which bot would you like to remove?", null, bots.length);
        if (remove == 0) {
            return;
        }
        JavaOpFileStuff.deleteBot(bots[remove - 1]);
    }

    private static void configurePaths() throws IOException {
        int choice;
        do {
            CommandlineConfigure.clear();
            System.out.println("Current paths are:");
            CommandlineConfigure.getAndPrintPluginPaths(false);
            System.out.println();
            System.out.println();
            System.out.println("1. Add path");
            System.out.println("2. Remove path");
            System.out.println();
            System.out.println("0. Back");
            System.out.println();
            choice = Integer.parseInt(CommandlineConfigure.getPatternInput("Please make a selection", null, "[120]"));
            if (choice == 1) {
                String path = CommandlineConfigure.getPatternInput("Please enter the full path", null, ".+");
                JavaOpFileStuff.addPluginPath(path);
                continue;
            }
            if (choice != 2) continue;
            String[] bots = CommandlineConfigure.getAndPrintPluginPaths(true);
            int bot = CommandlineConfigure.getNumericInput("Which bot?", null, bots.length);
            JavaOpFileStuff.removePluginPath(bots[bot - 1]);
        } while (choice != 0);
    }

    private static void configureLoadedBots() throws IOException {
        block4: while (true) {
            CommandlineConfigure.clear();
            System.out.println("The bots currently loading at startup:");
            CommandlineConfigure.getAndPrintDefaultBots(false);
            System.out.println();
            System.out.println();
            System.out.println("1. Add bot");
            System.out.println("2. Remove bot");
            System.out.println();
            System.out.println("0. Back");
            System.out.println();
            int choice = Integer.parseInt(CommandlineConfigure.getPatternInput("Please make a selection", null, "[120]"));
            switch (choice) {
                case 1: {
                    String[] allBots = CommandlineConfigure.getAndPrintAllBots(true);
                    int bot = CommandlineConfigure.getNumericInput("Which would you like to load at startup?", null, allBots.length);
                    JavaOpFileStuff.addDefaultBot(allBots[bot - 1]);
                    continue block4;
                }
                case 2: {
                    String[] defaultBots = CommandlineConfigure.getAndPrintDefaultBots(true);
                    int num = CommandlineConfigure.getNumericInput("Which bot would you like to remove?", null, defaultBots.length);
                    JavaOpFileStuff.removeDefaultBot(defaultBots[num - 1]);
                }
            }
            break;
        }
    }

    private static void manageBots() throws IOException {
        while (true) {
            CommandlineConfigure.clear();
            String[] bots = CommandlineConfigure.getAndPrintAllBots(true);
            System.out.println();
            System.out.println("0. Back");
            System.out.println();
            int bot = CommandlineConfigure.getNumericInput("Please choose a bot", null, bots.length);
            if (bot == 0) {
                return;
            }
            CommandlineConfigure.manageBot(bots[bot - 1]);
        }
    }

    private static void manageBot(String bot) throws IOException {
        block0: while (true) {
            int plugin;
            String[] plugins;
            CommandlineConfigure.clear();
            System.out.println("Editing: " + bot);
            System.out.println();
            System.out.println("1. Enable a plugin");
            System.out.println("2. Disable a plugin");
            System.out.println("3. Enable all plugins");
            System.out.println("4. Disable all plugins");
            System.out.println("5. Configure a plugin");
            System.out.println("6. Get information on a plugin");
            System.out.println();
            System.out.println("0. Back");
            System.out.println();
            int choice = Integer.parseInt(CommandlineConfigure.getPatternInput("Please make a selection", null, "[1234560]"));
            if (choice == 1) {
                plugins = CommandlineConfigure.getAndPrintAllPlugins(true);
                if (plugins.length == 0) {
                    System.out.println("(all plugins are being loaded already)");
                }
                System.out.println();
                System.out.println("0. Back");
                System.out.println();
                plugin = CommandlineConfigure.getNumericInput("Please select a plugin to add", null, plugins.length);
                if (plugin == 0) continue;
                JavaOpFileStuff.addActivePlugin(bot, plugins[plugin - 1]);
                continue;
            }
            if (choice == 2) {
                plugins = CommandlineConfigure.getAndPrintAllActivePlugins(bot, true);
                if (plugins.length == 0) {
                    System.out.println("(no plugins are being loaded yet)");
                }
                System.out.println();
                System.out.println("0. Back");
                System.out.println();
                plugin = CommandlineConfigure.getNumericInput("Please select a plugin to remove", null, plugins.length);
                if (plugin == 0) continue;
                JavaOpFileStuff.removeActivePlugin(bot, plugins[plugin - 1]);
                continue;
            }
            if (choice == 3) {
                JavaOpFileStuff.setActivePlugins(bot, PluginManager.getAllNames());
                continue;
            }
            if (choice == 4) {
                JavaOpFileStuff.setActivePlugins(bot, new String[0]);
                continue;
            }
            if (choice == 5) {
                plugins = CommandlineConfigure.getAndPrintAllPlugins(true);
                System.out.println();
                System.out.println("0, Back");
                System.out.println();
                plugin = CommandlineConfigure.getNumericInput("Please select a plugin to configure", null, plugins.length);
                if (plugin == 0) continue;
                GenericPluginInterface thisPlugin = PluginManager.getPlugin(plugins[--plugin]);
                Properties defaults = thisPlugin.getDefaultSettingValues();
                Properties descriptions = thisPlugin.getSettingsDescription();
                PersistantMap settings = JavaOpFileStuff.getSettings(bot);
                String pluginName = thisPlugin.getName();
                Object[] keys = CommandlineConfigure.sortEnumeration(defaults.keys());
                int i = 0;
                while (true) {
                    if (i >= keys.length) continue block0;
                    CommandlineConfigure.clear();
                    String currentSetting = settings.getNoWrite(pluginName, (String)keys[i], defaults.getProperty((String)keys[i]));
                    System.out.println();
                    System.out.println(keys[i] + ":");
                    System.out.println("Default setting: " + defaults.getProperty((String)keys[i]));
                    System.out.println("Current setting: " + currentSetting);
                    System.out.println("Description: " + descriptions.getProperty((String)keys[i]));
                    System.out.println();
                    settings.set(thisPlugin.getName(), (String)keys[i], CommandlineConfigure.getPatternInput("New value?", currentSetting, ".*"));
                    ++i;
                }
            }
            if (choice == 6) {
                plugins = CommandlineConfigure.getAndPrintAllPlugins(true);
                if (plugins.length == 0) {
                    System.out.println("(no plugins are being loaded yet)");
                }
                System.out.println();
                System.out.println("0. Back");
                System.out.println();
                int num = CommandlineConfigure.getNumericInput("Please select a plugin to get info on", null, plugins.length);
                if (num == 0) continue;
                GenericPluginInterface plugin2 = PluginManager.getPlugin(plugins[--num]);
                CommandlineConfigure.clear();
                System.out.println("Name: " + plugin2.getFullName());
                System.out.println();
                System.out.println("Author: " + plugin2.getAuthorName() + " <" + plugin2.getAuthorEmail() + ">");
                System.out.println();
                System.out.println("Website: " + plugin2.getAuthorWebsite());
                System.out.println();
                System.out.println("Description: " + plugin2.getLongDescription());
                System.out.println();
                System.out.println("Press enter to continue...");
                System.in.read();
                continue;
            }
            if (choice == 0) break;
        }
    }

    private static int getNumericInput(String prompt, String defaultIn, int max) {
        int input;
        while ((input = Integer.parseInt(CommandlineConfigure.getPatternInput(String.valueOf(prompt) + " (an integer 0 and " + max + ")", defaultIn, "[0-9]+"))) > max) {
            System.out.println("Error: invalid value");
        }
        return input;
    }

    private static String getPatternInput(String prompt, String defaultIn, String pattern) {
        while (true) {
            try {
                while (true) {
                    System.out.print(String.valueOf(prompt) + (defaultIn == null ? "" : " [" + defaultIn + "]") + " --> ");
                    String text = in.readLine();
                    if (text.equals("") && defaultIn != null) {
                        return defaultIn;
                    }
                    if (text.matches(pattern)) {
                        return text;
                    }
                    System.out.println("Error, please enter a valid value");
                }
            }
            catch (IOException e) {
                System.err.println("This should never happen");
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static void clear() {
        System.out.println("Yes, this is a crappy way to clear; but it's the only easy platform independant one, and Windows doesn't support ANSI by default, so shush.");
        int i = 0;
        while (i < 100) {
            System.out.println();
            ++i;
        }
    }

    private static String[] getAndPrintPluginPaths(boolean printNumbers) throws IOException {
        String[] allPlugins = JavaOpFileStuff.getRawPluginPaths();
        int i = 0;
        while (i < allPlugins.length) {
            System.out.println(String.valueOf(printNumbers ? String.valueOf(i + 1) + ". " : "* ") + allPlugins[i]);
            ++i;
        }
        return allPlugins;
    }

    private static String[] getAndPrintDefaultBots(boolean printNumbers) throws IOException {
        String[] defaultBots = JavaOpFileStuff.getDefaultBots();
        int i = 0;
        while (i < defaultBots.length) {
            System.out.println(String.valueOf(printNumbers ? String.valueOf(i + 1) + ". " : "* ") + defaultBots[i]);
            ++i;
        }
        return defaultBots;
    }

    private static String[] getAndPrintAllBots(boolean printNumbers) throws IOException {
        String[] allBots = JavaOpFileStuff.getAllBots();
        int i = 0;
        while (i < allBots.length) {
            System.out.println(String.valueOf(printNumbers ? String.valueOf(i + 1) + ". " : "* ") + allBots[i]);
            ++i;
        }
        return allBots;
    }

    private static String[] getAndPrintAllPlugins(boolean printNumbers) throws IOException {
        String[] plugins = PluginManager.getAllNames();
        int i = 0;
        while (i < plugins.length - 1) {
            System.out.println(String.valueOf(printNumbers ? String.valueOf(i + 1) + ". " : "* ") + plugins[i]);
            ++i;
        }
        return plugins;
    }

    private static String[] getAndPrintAllActivePlugins(String bot, boolean printNumbers) throws IOException {
        String[] plugins = JavaOpFileStuff.getActivePlugins(bot);
        int i = 0;
        while (i < plugins.length) {
            System.out.println(String.valueOf(printNumbers ? String.valueOf(i + 1) + ". " : "* ") + plugins[i]);
            ++i;
        }
        return plugins;
    }

    private static Object[] sortEnumeration(Enumeration<Object> e) {
        Vector<Object> objectVector = new Vector<Object>();
        while (e.hasMoreElements()) {
            objectVector.add(e.nextElement());
        }
        Object[] ret = objectVector.toArray();
        Arrays.sort(ret);
        return ret;
    }
}

