/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.BotMail;

import com.javaop.BotMail.Mail;
import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.CommandUsedIllegally;
import com.javaop.exceptions.CommandUsedImproperly;
import com.javaop.exceptions.PluginException;
import com.javaop.plugin_interfaces.CommandCallback;
import com.javaop.plugin_interfaces.EventCallback;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class PluginMain
extends GenericPluginInterface
implements CommandCallback,
EventCallback {
    private PublicExposedFunctions out;
    private Mail mail;
    private boolean shareMail;

    public void load(StaticExposedFunctions staticExposedFunctions) {
        this.shareMail = staticExposedFunctions.getGlobalSettingDefault(this.getName(), "Share mail", "false").equalsIgnoreCase("true");
    }

    public void activate(PublicExposedFunctions publicExposedFunctions, PluginCallbackRegister pluginCallbackRegister) {
        this.out = publicExposedFunctions;
        this.mail = this.shareMail ? new Mail(publicExposedFunctions.getName()) : new Mail("_GlobalMail");
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "getmail", 0, false, "L", "[number list]", "Retrieves the specified message or all messages", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "mail", 2, false, "ALN", "<user> <message>", "Sends a message to the specified user", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "removemail", 0, false, "L", "[number list]", "Removes the specified message", null);
        pluginCallbackRegister.registerEventPlugin((EventCallback)this, null);
    }

    public void deactivate(PluginCallbackRegister pluginCallbackRegister) {
    }

    public String getName() {
        return "BotMail";
    }

    public String getVersion() {
        return "2.1.3";
    }

    public String getAuthorName() {
        return "iago";
    }

    public String getAuthorWebsite() {
        return "www.javaop.com";
    }

    public String getAuthorEmail() {
        return "iago@valhallalegends.com";
    }

    public String getShortDescription() {
        return "Bot mail";
    }

    public String getLongDescription() {
        return "This plugin is for sending/receiving botmail";
    }

    public Properties getDefaultSettingValues() {
        Properties properties = new Properties();
        properties.setProperty("Delete on read", "true");
        properties.setProperty("Alert on message", "true");
        return properties;
    }

    public Properties getSettingsDescription() {
        Properties properties = new Properties();
        properties.setProperty("Delete on read", "Automatically remove messages when they are read");
        properties.setProperty("Alert on message", "Alert users if they have mail when they enter the channel");
        return properties;
    }

    public JComponent getComponent(String string, String string2) {
        return new JCheckBox("", string2.equalsIgnoreCase("true"));
    }

    public Properties getGlobalDefaultSettingValues() {
        Properties properties = new Properties();
        properties.setProperty("Share mail", "false");
        return properties;
    }

    public Properties getGlobalSettingsDescription() {
        Properties properties = new Properties();
        properties.setProperty("Share mail", "If this is set, all bots share the same database for mail messages");
        return properties;
    }

    public JComponent getGlobalComponent(String string, String string2) {
        return new JCheckBox("", string2.equalsIgnoreCase("true"));
    }

    public void commandExecuted(String string, String string2, String[] stringArray, int n, Object object) throws IOException, PluginException, CommandUsedIllegally, CommandUsedImproperly {
        if (string2.equalsIgnoreCase("getmail")) {
            if (stringArray.length == 0) {
                String[] stringArray2 = this.mail.getMessages(string);
                if (stringArray2.length == 0) {
                    this.out.sendTextUser(string, "You have no mail.", 0);
                } else {
                    for (int i = 0; i < stringArray2.length; ++i) {
                        this.out.sendTextUser(string, this.mail.getFullMessage(string, stringArray2[i]), 0);
                        if (!this.out.getLocalSetting(this.getName(), "Delete on read").equalsIgnoreCase("true")) continue;
                        this.mail.remove(string, stringArray2[i]);
                    }
                }
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (this.mail.exists(string, stringArray[i])) {
                        this.out.sendTextUser(string, this.mail.getFullMessage(string, stringArray[i]), 0);
                        if (!this.out.getLocalSetting(this.getName(), "Delete on read").equalsIgnoreCase("true")) continue;
                        this.mail.remove(string, stringArray[i]);
                        continue;
                    }
                    this.out.sendTextUser(string, "No such message: " + stringArray[i], 0);
                }
            }
        } else if (string2.equalsIgnoreCase("mail")) {
            if (stringArray.length != 2) {
                throw new CommandUsedImproperly("mail requires exactly 2 parameters", string, string2);
            }
            this.mail.add(stringArray[0], string, stringArray[1]);
            this.out.sendTextUser(string, "Message queued to be sent", 0);
        } else if (string2.equalsIgnoreCase("removemail")) {
            if (stringArray.length == 0) {
                throw new CommandUsedImproperly("removemail requires the list of messages to remove", string, string2);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.mail.exists(string, stringArray[i])) continue;
                this.mail.remove(string, stringArray[i]);
                this.out.sendTextUser(string, "Removed: " + stringArray[i], 0);
            }
        } else {
            this.out.sendTextUser(string, "Error: unknown command used in BotMail -- please inform iago", 0);
        }
    }

    private void checkMail(String string) throws IOException {
        int n;
        if (this.out.getLocalSetting(this.getName(), "Alert on message").equalsIgnoreCase("true") && (n = this.mail.getCount(string)) > 0) {
            this.out.sendTextUser(string, "You have " + n + " mail messages waiting; use getmail command to retrieve", 0);
        }
    }

    public void userShow(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.checkMail(string);
    }

    public void userJoin(String string, String string2, int n, int n2) throws IOException, PluginException {
        this.checkMail(string);
    }

    public void talk(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void emote(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void whisperFrom(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void whisperTo(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void userLeave(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void userFlags(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void error(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void info(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void broadcast(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void channel(String string, String string2, int n, int n2) throws IOException, PluginException {
    }
}

