/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.BotMail;

import com.javaop.util.PersistantMap;
import com.javaop.util.RelativeFile;
import java.io.File;
import java.util.Date;
import java.util.Vector;

public class Mail {
    private PersistantMap messages;
    private static final String ID = "_current id";
    private static final String LOW_ID = "_lowest id";
    private static final String SENDER_PREFIX = "from-";
    private static final String MESSAGE_PREFIX = "msg-";
    private static final String DATE_PREFIX = "date-";

    public Mail(String string) {
        this.messages = new PersistantMap((File)new RelativeFile(string + ".mail"), "This is the mail messages.  One section per user.");
    }

    public synchronized void add(String string, String string2, String string3) {
        int n = Integer.parseInt(this.messages.getWrite(string, ID, "0"));
        this.messages.set(string, ID, ++n + "");
        String string4 = SENDER_PREFIX + n;
        String string5 = MESSAGE_PREFIX + n;
        String string6 = DATE_PREFIX + n;
        this.messages.set(string, string4, string2);
        this.messages.set(string, string5, string3);
        this.messages.set(string, string6, new Date().toString());
    }

    public synchronized void remove(String string, String string2) {
        int n = Integer.parseInt(string2);
        int n2 = Integer.parseInt(this.messages.getWrite(string, LOW_ID, "1"));
        int n3 = Integer.parseInt(this.messages.getWrite(string, ID, "0"));
        this.messages.remove(string, MESSAGE_PREFIX + string2);
        this.messages.remove(string, SENDER_PREFIX + string2);
        this.messages.remove(string, DATE_PREFIX + string2);
        if (n == n2) {
            System.err.println("Low Id removed, bumping it up");
            for (int i = n2 + 1; i <= n3; ++i) {
                if (this.exists(string, i + "")) {
                    this.messages.set(string, LOW_ID, i + "");
                    break;
                }
                this.messages.set(string, LOW_ID, i + "");
            }
        }
    }

    public synchronized String getMessage(String string, String string2) {
        return this.messages.getNoWrite(string, MESSAGE_PREFIX + string2, "<no such message>");
    }

    public synchronized String getSender(String string, String string2) {
        return this.messages.getNoWrite(string, SENDER_PREFIX + string2, "<no such message>");
    }

    public synchronized String getDate(String string, String string2) {
        return this.messages.getNoWrite(string, DATE_PREFIX + string2, "<no such message>");
    }

    public synchronized String getFullMessage(String string, String string2) {
        return "#" + string2 + ": <From: " + this.getSender(string, string2) + "> " + this.getMessage(string, string2) + " [" + this.getDate(string, string2) + "]";
    }

    public synchronized boolean exists(String string, String string2) {
        return this.messages.getNoWrite(string, MESSAGE_PREFIX + string2, null) != null;
    }

    public synchronized String[] getMessages(String string) {
        int n = Integer.parseInt(this.messages.getNoWrite(string, LOW_ID, "1"));
        int n2 = Integer.parseInt(this.messages.getNoWrite(string, ID, "0"));
        Vector<String> vector = new Vector<String>();
        for (int i = n; i <= n2; ++i) {
            if (!this.exists(string, i + "")) continue;
            vector.add(i + "");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public synchronized int getCount(String string) {
        int n = Integer.parseInt(this.messages.getNoWrite(string, LOW_ID, "1"));
        int n2 = Integer.parseInt(this.messages.getNoWrite(string, ID, "0"));
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            if (!this.exists(string, i + "")) continue;
            ++n3;
        }
        return n3;
    }

    public static void main(String[] stringArray) throws Exception {
        Mail mail = new Mail("/tmp/test");
        mail.add("iago", "Joe", "1 Hey iago, it's Joe");
        mail.add("iago", "Joe", "2 Hey iago, it's Joe");
        mail.remove("iago", "1");
        mail.add("iago", "Joe", "3 Hey iago, it's Joe");
        mail.remove("iago", "3");
        mail.add("iago", "Joe", "4 Hey iago, it's Joe");
        mail.add("iago", "Joe", "5 Hey iago, it's Joe");
        System.out.println("Message 2, 4, and 5:");
        String[] stringArray2 = mail.getMessages("iago");
        for (int i = 0; i < stringArray2.length; ++i) {
            System.out.println(mail.getFullMessage("iago", stringArray2[i]));
        }
        System.out.println("iago = " + mail.getCount("iago"));
        System.out.println("Joe = " + mail.getCount("joe"));
    }
}

