/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.util;

public class Buffer {
    public final int defaultLength = 32;
    protected byte[] buffer = new byte[32];
    private int currentLength = 0;
    private int maxLength = 32;

    public Buffer() {
    }

    public Buffer(byte[] byArray) {
        this();
        this.addBytes(byArray);
    }

    public Buffer(Buffer buffer) {
        this();
        this.addBytes(buffer.getBytes());
    }

    public int size() {
        return this.currentLength;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.currentLength];
        System.arraycopy(this.buffer, 0, byArray, 0, this.currentLength);
        return byArray;
    }

    private void verifyLength(int n) {
        if (this.currentLength + n <= this.maxLength) {
            return;
        }
        while (this.currentLength + n > this.maxLength) {
            this.maxLength *= 2;
        }
        byte[] byArray = new byte[this.maxLength];
        System.arraycopy(this.buffer, 0, byArray, 0, this.currentLength);
        this.buffer = byArray;
    }

    protected byte[] remove(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.buffer, 0, byArray, 0, n);
        System.arraycopy(this.buffer, n, this.buffer, 0, this.currentLength - n);
        this.currentLength -= n;
        return byArray;
    }

    public void addByte(byte by) {
        this.verifyLength(1);
        this.buffer[this.currentLength++] = by;
    }

    public byte removeByte() throws IndexOutOfBoundsException {
        if (this.currentLength == 0) {
            throw new IndexOutOfBoundsException("Attempted to remove data from the buffer that wasn't there.");
        }
        return this.remove(1)[0];
    }

    public byte byteAt(int n) {
        return this.buffer[n];
    }

    public void addWord(short s) {
        this.addByte((byte)((s & 0xFF) >> 0));
        this.addByte((byte)((s & 0xFF00) >> 8));
    }

    public short removeWord() throws IndexOutOfBoundsException {
        int n = this.removeByte() << 0 & 0xFF | this.removeByte() << 8 & 0xFF00;
        return (short)(n & 0xFFFF);
    }

    public void addDWord(int n) {
        this.addByte((byte)((n & 0xFF) >> 0));
        this.addByte((byte)((n & 0xFF00) >> 8));
        this.addByte((byte)((n & 0xFF0000) >> 16));
        this.addByte((byte)((n & 0xFF000000) >> 24));
    }

    public void addArray(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.addDWord(nArray[i]);
        }
    }

    public int removeDWord() throws IndexOutOfBoundsException {
        return this.removeByte() << 0 & 0xFF | this.removeByte() << 8 & 0xFF00 | this.removeByte() << 16 & 0xFF0000 | this.removeByte() << 24 & 0xFF000000;
    }

    public void addLong(long l) {
        this.addByte((byte)((l & 0xFFL) >> 0));
        this.addByte((byte)((l & 0xFF00L) >> 8));
        this.addByte((byte)((l & 0xFF0000L) >> 16));
        this.addByte((byte)((l & 0xFF000000L) >> 24));
        this.addByte((byte)((l & 0xFF00000000L) >> 32));
        this.addByte((byte)((l & 0xFF0000000000L) >> 40));
        this.addByte((byte)((l & 0xFF000000000000L) >> 48));
        this.addByte((byte)((l & 0xFF00000000000000L) >> 56));
    }

    public long removeLong() throws IndexOutOfBoundsException {
        return (long)this.removeByte() << 0 & 0xFFL | (long)this.removeByte() << 8 & 0xFF00L | (long)this.removeByte() << 16 & 0xFF0000L | (long)this.removeByte() << 24 & 0xFF000000L | (long)this.removeByte() << 32 & 0xFF00000000L | (long)this.removeByte() << 40 & 0xFF0000000000L | (long)this.removeByte() << 48 & 0xFF000000000000L | (long)this.removeByte() << 56 & 0xFF00000000000000L;
    }

    public void addString(String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.addByte((byte)string.charAt(i));
        }
    }

    public String removeString(int n) throws IndexOutOfBoundsException {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append((char)this.removeByte());
        }
        return stringBuffer.toString();
    }

    public void addNTString(String string) {
        this.addString(string);
        this.addByte((byte)0);
    }

    public String removeNTString() {
        StringBuffer stringBuffer = new StringBuffer();
        byte by = this.removeByte();
        while (by != 0) {
            stringBuffer.append((char)by);
            by = this.removeByte();
        }
        return stringBuffer.toString();
    }

    public byte[] removeNtByteArray() {
        Buffer buffer = new Buffer();
        byte by = this.removeByte();
        while (by != 0) {
            buffer.addByte(by);
            by = this.removeByte();
        }
        return buffer.getBytes();
    }

    public void addNtByteArray(byte[] byArray) {
        this.addBytes(byArray);
        this.addByte((byte)0);
    }

    public void addBytes(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            this.addByte(byArray[i]);
        }
    }

    public byte[] removeBytes(int n) throws IndexOutOfBoundsException {
        return this.remove(n);
    }

    public void addBuffer(Buffer buffer) {
        this.addBytes(buffer.getBytes());
    }

    public void add(byte by) {
        this.addByte(by);
    }

    public void add(short s) {
        this.addWord(s);
    }

    public void add(int n) {
        this.addDWord(n);
    }

    public void add(int[] nArray) {
        this.addArray(nArray);
    }

    public void add(long l) {
        this.addLong(l);
    }

    public void add(byte[] byArray) {
        this.addBytes(byArray);
    }

    public void add(Buffer buffer) {
        this.addBuffer(buffer);
    }

    public String toString() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer(this.currentLength * 3 + this.currentLength + this.currentLength / 4 + 30);
        for (n2 = 0; n2 < this.currentLength; ++n2) {
            if (n2 != 0 && n2 % 16 == 0) {
                stringBuffer.append('\t');
                for (n = n2 - 16; n < n2; ++n) {
                    if (this.buffer[n] < 32 || this.buffer[n] > 127) {
                        stringBuffer.append('.');
                        continue;
                    }
                    stringBuffer.append((char)this.buffer[n]);
                }
                stringBuffer.append("\n");
            }
            stringBuffer.append(Integer.toString((this.buffer[n2] & 0xF0) >> 4, 16) + Integer.toString((this.buffer[n2] & 0xF) >> 0, 16));
            stringBuffer.append(' ');
        }
        if (n2 != 0 && n2 % 16 != 0) {
            for (n = 0; n < (16 - n2 % 16) * 3; ++n) {
                stringBuffer.append(' ');
            }
        }
        stringBuffer.append('\t');
        for (n = n2 > 0 && n2 % 16 == 0 ? n2 - 16 : n2 - n2 % 16; n2 >= 0 && n < n2; ++n) {
            if (this.buffer[n] < 32 || this.buffer[n] > 127) {
                stringBuffer.append('.');
                continue;
            }
            stringBuffer.append((char)this.buffer[n]);
        }
        stringBuffer.append('\n');
        stringBuffer.append("Length: " + this.currentLength + '\n');
        return stringBuffer.toString();
    }
}

