/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.util;

import java.math.BigInteger;
import java.util.Random;

public class BigIntegerEx {
    public static final int BIG_ENDIAN = 0;
    public static final int LITTLE_ENDIAN = 1;
    public static final int BIGINT_SIZE = 32;
    private final BigInteger bigInteger;
    private final int endian;

    public BigIntegerEx(int n, String string) {
        this.endian = n;
        this.bigInteger = new BigInteger(string);
    }

    public BigIntegerEx(int n, byte[] byArray) {
        this.endian = n;
        this.bigInteger = n == 0 ? new BigInteger(1, byArray) : new BigInteger(1, BigIntegerEx.reverseArray(byArray, byArray.length));
    }

    public BigIntegerEx(int n, BigInteger bigInteger) {
        this.endian = n;
        this.bigInteger = n == 1 ? bigInteger : new BigInteger(BigIntegerEx.reverseArray(bigInteger.toByteArray(), 32));
    }

    public BigIntegerEx(int n, int n2) {
        this.endian = n;
        this.bigInteger = new BigInteger(n2, new Random());
    }

    public BigInteger getBigInteger() {
        return this.bigInteger;
    }

    public byte[] toByteArray() {
        if (this.endian == 0) {
            return this.bigInteger.toByteArray();
        }
        return BigIntegerEx.reverseArray(this.bigInteger.toByteArray(), 32);
    }

    public BigIntegerEx modPow(BigIntegerEx bigIntegerEx, BigIntegerEx bigIntegerEx2) {
        return new BigIntegerEx(this.endian, this.getBigInteger().modPow(bigIntegerEx.getBigInteger(), bigIntegerEx2.getBigInteger()));
    }

    public BigIntegerEx mod(BigIntegerEx bigIntegerEx) {
        return new BigIntegerEx(this.endian, this.getBigInteger().mod(bigIntegerEx.getBigInteger()));
    }

    public BigIntegerEx add(BigIntegerEx bigIntegerEx) {
        return new BigIntegerEx(this.endian, this.getBigInteger().add(bigIntegerEx.getBigInteger()));
    }

    public BigIntegerEx subtract(BigIntegerEx bigIntegerEx) {
        return new BigIntegerEx(this.endian, this.getBigInteger().subtract(bigIntegerEx.getBigInteger()));
    }

    public BigIntegerEx multiply(BigIntegerEx bigIntegerEx) {
        return new BigIntegerEx(this.endian, this.getBigInteger().multiply(bigIntegerEx.getBigInteger()));
    }

    public int compareTo(BigIntegerEx bigIntegerEx) {
        return this.bigInteger.compareTo(bigIntegerEx.getBigInteger());
    }

    public String toString() {
        return this.bigInteger.toString();
    }

    public String toString(int n) {
        return this.bigInteger.toString(n);
    }

    private static byte[] reverseArray(byte[] byArray, int n) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[byArray.length - i - 1] = byArray[i];
        }
        if (n != 0) {
            return BigIntegerEx.trimArray(byArray2, n);
        }
        return byArray2;
    }

    private static byte[] trimArray(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        if (byArray.length > n) {
            System.arraycopy(byArray, 0, byArray2, 0, n);
        } else {
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        }
        return byArray2;
    }
}

