/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.bot;

import com.javaop.bot.BotManager;
import com.javaop.bot.PluginMain;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.util.FileManagement;
import com.javaop.util.PersistantMap;
import com.javaop.util.RelativeFile;
import com.javaop.util.Uniq;
import com.javaop.util.UserDB;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Vector;

public class JavaOpFileStuff {
    public static final String EXT_SETTINGS = ".jbb";
    public static final String EXT_SETTINGS_MATCH = ".*\\.jbb";
    public static final String EXT_DATABASE = ".jdb";
    public static final String EXT_DATABASE_MATCH = ".*\\.jdb";
    public static final String EXT_PLUGIN = ".plugin";
    public static final String EXT_PLUGIN_MATCH = ".*\\.plugin";
    public static final String EXT_ALIASES = ".aliases";
    public static final String EXT_CUSTOMFLAGS = ".flags";
    public static final String GLOBAL_SETTINGS = "_GlobalSettings.txt";
    public static final String PLUGIN_PATHS = "_PluginPaths.txt";
    public static final String DEFAULT_BOTS = "_DefaultBots.txt";

    public static void setBaseDirectory() {
        System.setProperty("user.dir", System.getProperty("user.home") + "/.javaop2");
    }

    public static File getDefaultBotsFile() {
        return new RelativeFile(DEFAULT_BOTS);
    }

    public static File getPluginPathsFile() {
        return new RelativeFile(PLUGIN_PATHS);
    }

    public static File getPluginFile(String string) {
        return new RelativeFile(string + EXT_PLUGIN);
    }

    public static File getAliasesFile(String string) {
        return new RelativeFile(string + EXT_ALIASES);
    }

    public static File getCustomFlagsFile(String string) {
        return new RelativeFile(string + EXT_CUSTOMFLAGS);
    }

    public static String[] getRawPluginPaths() {
        return Uniq.uniq(JavaOpFileStuff.getPluginPaths());
    }

    public static void addPluginPath(String string) {
        try {
            FileManagement.addLine(JavaOpFileStuff.getPluginPathsFile(), string);
        }
        catch (IOException iOException) {
            System.err.println("Error adding plugin path: " + iOException);
            System.exit(0);
            throw new RuntimeException();
        }
    }

    public static void removePluginPath(String string) {
        try {
            FileManagement.removeLine(JavaOpFileStuff.getPluginPathsFile(), string);
        }
        catch (IOException iOException) {
            System.err.println("Error removing plugin path: " + iOException);
            System.exit(0);
            throw new RuntimeException();
        }
    }

    public static String[] getAllPlugins() {
        String[] stringArray = Uniq.uniq(JavaOpFileStuff.getPluginPaths());
        Vector<File> vector = new Vector<File>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.addAll(FileManagement.search(new RelativeFile(stringArray[i]), ".*\\.jar"));
        }
        return Uniq.uniq(vector);
    }

    private static Vector<String> getPluginPaths() {
        try {
            RelativeFile relativeFile = new RelativeFile(PLUGIN_PATHS);
            Vector<String> vector = FileManagement.getFile(relativeFile);
            if (vector == null) {
                System.err.println("Plugin paths file not found -- using defaults (" + relativeFile + ")");
            }
            JavaOpFileStuff.addIfExists(vector, new RelativeFile("Plugins"));
            JavaOpFileStuff.addIfExists(vector, new File("C:\\JavaOp-Plugins"));
            JavaOpFileStuff.addIfExists(vector, new File("C:\\Program Files\\JavaOp2\\JavaOp-Plugins"));
            JavaOpFileStuff.addIfExists(vector, new File("/usr/local/JavaOp-Plugins"));
            return vector;
        }
        catch (IOException iOException) {
            System.err.println("Error reading plugin paths: " + iOException);
            System.exit(0);
            throw new RuntimeException();
        }
    }

    private static void addIfExists(Vector vector, File file) {
        if (file.exists() && !vector.contains(file)) {
            vector.add(file);
        }
    }

    public static GenericPluginInterface loadPlugin(String string) throws ClassNotFoundException, MalformedURLException, InstantiationException, IllegalAccessException {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = new URL("file:///" + string);
        }
        return JavaOpFileStuff.loadPlugin(uRL);
    }

    public static GenericPluginInterface loadPlugin(URL uRL) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        URL[] uRLArray = new URL[]{uRL};
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
        Class<?> clazz = uRLClassLoader.loadClass("PluginMain");
        return (GenericPluginInterface)clazz.newInstance();
    }

    public static String[] getActivePlugins(String string) {
        try {
            return FileManagement.getUniqueLines(JavaOpFileStuff.getPluginFile(string));
        }
        catch (IOException iOException) {
            System.err.println("Error getting active plugins: " + iOException);
            System.exit(0);
            throw new RuntimeException();
        }
    }

    public static void setActivePlugins(String string, String[] stringArray) {
        FileManagement.deleteFile(JavaOpFileStuff.getPluginFile(string));
        for (int i = 0; i < stringArray.length; ++i) {
            JavaOpFileStuff.addActivePlugin(string, stringArray[i]);
        }
    }

    public static boolean isActivePlugin(String string, String string2) {
        try {
            if (string2.equalsIgnoreCase(new PluginMain().getName())) {
                return true;
            }
            return FileManagement.findLine(JavaOpFileStuff.getPluginFile(string), string2);
        }
        catch (IOException iOException) {
            System.err.println("Error checking if active plugin: " + iOException);
            System.exit(0);
            throw new RuntimeException();
        }
    }

    public static void addActivePlugin(String string, String string2) {
        try {
            if (string2.equalsIgnoreCase(new PluginMain().getName())) {
                return;
            }
            FileManagement.addLine(JavaOpFileStuff.getPluginFile(string), string2);
        }
        catch (IOException iOException) {
            System.err.println("Error adding active plugin: " + iOException);
            System.exit(0);
            throw new RuntimeException();
        }
    }

    public static void removeActivePlugin(String string, String string2) {
        try {
            if (string2.equalsIgnoreCase(new PluginMain().getName())) {
                return;
            }
            FileManagement.removeLine(JavaOpFileStuff.getPluginFile(string), string2);
        }
        catch (IOException iOException) {
            System.err.println("Error removing active plugin: " + iOException);
            System.exit(0);
            throw new RuntimeException();
        }
    }

    public static void toggleActivePlugin(String string, String string2) {
        if (string2.equalsIgnoreCase(new PluginMain().getName())) {
            return;
        }
        if (JavaOpFileStuff.isActivePlugin(string, string2)) {
            JavaOpFileStuff.removeActivePlugin(string, string2);
        } else {
            JavaOpFileStuff.addActivePlugin(string, string2);
        }
    }

    public static String[] getAllBots() {
        String[] stringArray = Uniq.uniq(FileManagement.search(new RelativeFile(""), EXT_SETTINGS_MATCH));
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].replaceAll("\\.jbb$", "");
            stringArray[i] = stringArray[i].replaceAll(".*[\\\\/]", "");
        }
        return stringArray;
    }

    public static void deleteBot(String string) {
        JavaOpFileStuff.removeDefaultBot(string);
        BotManager.stopBot(string);
        new RelativeFile(string + EXT_SETTINGS).delete();
        new RelativeFile(string + EXT_DATABASE).delete();
        new RelativeFile(string + EXT_ALIASES).delete();
        new RelativeFile(string + ".jbb.remote").delete();
        new RelativeFile(string + EXT_PLUGIN).delete();
        new RelativeFile(string + ".quotes").delete();
        new RelativeFile(string + ".seen").delete();
        new RelativeFile(string + EXT_CUSTOMFLAGS).delete();
    }

    public static void newBot(String string) {
        JavaOpFileStuff.getSettings(string);
    }

    public static void copyBot(String string, String string2) {
        try {
            FileManagement.copyFile(new RelativeFile(string + EXT_SETTINGS), new RelativeFile(string2 + EXT_SETTINGS));
            FileManagement.copyFile(new RelativeFile(string + EXT_ALIASES), new RelativeFile(string2 + EXT_ALIASES));
            FileManagement.copyFile(new RelativeFile(string + EXT_DATABASE), new RelativeFile(string2 + EXT_DATABASE));
            FileManagement.copyFile(new RelativeFile(string + EXT_PLUGIN), new RelativeFile(string2 + EXT_PLUGIN));
        }
        catch (IOException iOException) {
            System.err.println("Error copying bot: " + iOException);
            System.exit(0);
            throw new RuntimeException();
        }
    }

    public static String[] getDefaultBots() {
        try {
            return FileManagement.getUniqueLines(JavaOpFileStuff.getDefaultBotsFile());
        }
        catch (IOException iOException) {
            System.err.println("Error getting default bots: " + iOException);
            System.exit(0);
            throw new RuntimeException();
        }
    }

    public static boolean isDefaultBot(String string) {
        try {
            return FileManagement.findLine(JavaOpFileStuff.getDefaultBotsFile(), string);
        }
        catch (IOException iOException) {
            System.err.println("Error checking if default bot: " + iOException);
            System.exit(0);
            throw new RuntimeException();
        }
    }

    public static void toggleDefault(String string) {
        try {
            if (JavaOpFileStuff.isDefaultBot(string)) {
                FileManagement.removeLine(JavaOpFileStuff.getDefaultBotsFile(), string);
            } else {
                FileManagement.addLine(JavaOpFileStuff.getDefaultBotsFile(), string);
            }
        }
        catch (IOException iOException) {
            System.err.println("Error toggling default bot: " + iOException);
            System.exit(0);
            throw new RuntimeException();
        }
    }

    public static void setDefaultBots(String[] stringArray) {
        try {
            FileManagement.setFile(JavaOpFileStuff.getDefaultBotsFile(), stringArray);
        }
        catch (IOException iOException) {
            System.err.println("Error setting default bots: " + iOException);
            System.exit(0);
            throw new RuntimeException();
        }
    }

    public static void addDefaultBot(String string) {
        try {
            FileManagement.addLine(JavaOpFileStuff.getDefaultBotsFile(), string);
        }
        catch (IOException iOException) {
            System.err.println("Error adding default bot: " + iOException);
            System.exit(0);
            throw new RuntimeException();
        }
    }

    public static void removeDefaultBot(String string) {
        try {
            FileManagement.removeLine(JavaOpFileStuff.getDefaultBotsFile(), string);
        }
        catch (IOException iOException) {
            System.err.println("Error removing default bot: " + iOException);
            System.exit(0);
            throw new RuntimeException();
        }
    }

    public static PersistantMap getGlobalSettings() {
        return new PersistantMap(new RelativeFile(GLOBAL_SETTINGS), "These are the bot's settings");
    }

    public static PersistantMap getSettings(String string) {
        return new PersistantMap(new RelativeFile(string + EXT_SETTINGS), "These are the bot's settings");
    }

    public static PersistantMap getAliases(String string) {
        return new PersistantMap(JavaOpFileStuff.getAliasesFile(string), "These are the aliases; each line is in the format alias=command");
    }

    public static PersistantMap getCustomFlags(String string) {
        return new PersistantMap(JavaOpFileStuff.getCustomFlagsFile(string), "These are customized flags for commands.  You may add 'command=FLAGS' for any command, and it will be overridden.");
    }

    public static UserDB getUserDB(String string) {
        return new UserDB(new RelativeFile(string + EXT_DATABASE));
    }

    public static File getDB(String string) {
        return new RelativeFile(string + EXT_DATABASE);
    }
}

