/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.bot;

import com.javaop.bot.BotCore;
import com.javaop.bot.JavaOpFileStuff;
import com.javaop.exceptions.PluginException;
import com.javaop.util.Uniq;
import java.io.IOException;
import java.util.Hashtable;

public class BotManager {
    private static final Hashtable<String, BotCore> activeBots = new Hashtable();

    public static void startBot(String string) throws IOException, PluginException {
        if (activeBots.get(string) == null) {
            activeBots.put(string, new BotCore(string));
        } else {
            System.err.println("Attempting to load an already active bot!");
        }
    }

    public static void stopBot(String string) throws IllegalArgumentException {
        BotCore botCore = activeBots.get(string);
        activeBots.remove(string);
        if (botCore != null) {
            botCore.stop();
        }
    }

    public static String[] getAllBots() {
        return JavaOpFileStuff.getAllBots();
    }

    public static String[] getActiveBots() {
        return Uniq.uniq(activeBots.keys());
    }

    public static BotCore getBot(String string) {
        return activeBots.get(string);
    }
}

