/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.bot;

import com.javaop.bot.BotManager;
import com.javaop.bot.JavaOpFileStuff;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.PluginException;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.pluginmanagers.PluginManager;
import com.javaop.util.PersistantMap;
import com.javaop.util.Uniq;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JComponent;

public class BotCoreStatic
implements StaticExposedFunctions {
    private static final Hashtable<Object, Object> globalVariables = new Hashtable();
    private static final PersistantMap globalSettings = JavaOpFileStuff.getGlobalSettings();
    private static BotCoreStatic instance = new BotCoreStatic();

    private BotCoreStatic() {
    }

    public static BotCoreStatic getInstance() {
        return instance;
    }

    @Override
    public void newBot(String string) throws PluginException {
        this.botStart(string);
        JavaOpFileStuff.setActivePlugins(string, PluginManager.getAllNames());
    }

    @Override
    public void botStart(String string) throws PluginException {
        if (!string.matches("[\\w\\_\\-\\.]+")) {
            throw new PluginException("Bots' names must contain at least one character, and the only characters a-z, A-Z, 0-9, or '.-_'");
        }
        try {
            BotManager.startBot(string);
        }
        catch (IOException iOException) {
            throw new PluginException(iOException);
        }
    }

    @Override
    public void botStop(String string) throws IllegalArgumentException {
        BotManager.stopBot(string);
    }

    @Override
    public String[] botGetAllNames() {
        return BotManager.getAllBots();
    }

    @Override
    public String[] botGetActiveNames() {
        return BotManager.getActiveBots();
    }

    @Override
    public PublicExposedFunctions[] botGetAllActive() {
        String[] stringArray = BotManager.getActiveBots();
        PublicExposedFunctions[] publicExposedFunctionsArray = new PublicExposedFunctions[stringArray.length];
        for (int i = 0; i < publicExposedFunctionsArray.length; ++i) {
            publicExposedFunctionsArray[i] = this.botGet(stringArray[i]);
        }
        return publicExposedFunctionsArray;
    }

    @Override
    public PublicExposedFunctions botGet(String string) {
        return BotManager.getBot(string);
    }

    @Override
    public PersistantMap botGetSettings(String string) {
        return JavaOpFileStuff.getSettings(string);
    }

    @Override
    public void systemMessage(int n, String string) {
        PublicExposedFunctions[] publicExposedFunctionsArray = this.botGetAllActive();
        for (int i = 0; i < publicExposedFunctionsArray.length; ++i) {
            publicExposedFunctionsArray[i].systemMessage(n, string);
        }
    }

    @Override
    public void botDelete(String string) {
        JavaOpFileStuff.deleteBot(string);
    }

    @Override
    public boolean botIsDefault(String string) {
        return JavaOpFileStuff.isDefaultBot(string);
    }

    @Override
    public void botToggleDefault(String string) {
        JavaOpFileStuff.toggleDefault(string);
    }

    @Override
    public PersistantMap getCustomFlags(String string) {
        return JavaOpFileStuff.getCustomFlags(string);
    }

    @Override
    public String getVersion() {
        return "2.1.3";
    }

    @Override
    public String getGlobalSetting(String string, String string2) {
        return globalSettings.getNoWrite(string, string2, null);
    }

    @Override
    public String getGlobalSettingDefault(String string, String string2, String string3) {
        if (string == null) {
            string = " default";
        }
        return globalSettings.getWrite(string, string2, string3);
    }

    @Override
    public void setGlobalSetting(String string, String string2, String string3) {
        globalSettings.set(string, string2, string3);
    }

    @Override
    public Properties getGlobalSection(String string) {
        return globalSettings.getSection(string);
    }

    @Override
    public String[] getGlobalKeys(String string) {
        return Uniq.uniq(globalSettings.propertyNames(string));
    }

    @Override
    public void putGlobalVariable(Object object, Object object2) {
        globalVariables.put(object, object2);
    }

    @Override
    public Object getGlobalVariable(Object object) {
        return globalVariables.get(object);
    }

    @Override
    public String[] pluginGetNames() {
        return PluginManager.getAllNames();
    }

    @Override
    public GenericPluginInterface pluginGet(String string) {
        return PluginManager.getPlugin(string);
    }

    @Override
    public Properties pluginGetDefaultSettings(String string) {
        return this.pluginGet(string).getDefaultSettingValues();
    }

    @Override
    public Properties pluginGetGlobalDefaultSettings(String string) {
        return this.pluginGet(string).getGlobalDefaultSettingValues();
    }

    @Override
    public Properties pluginGetDescriptions(String string) {
        return this.pluginGet(string).getSettingsDescription();
    }

    @Override
    public Properties pluginGetGlobalDescriptions(String string) {
        return this.pluginGet(string).getGlobalSettingsDescription();
    }

    @Override
    public Hashtable<String, JComponent> pluginGetComponents(String string, Properties properties) {
        return this.pluginGet(string).getComponents(properties);
    }

    @Override
    public Hashtable<String, JComponent> pluginGetGlobalComponents(String string, Properties properties) {
        return this.pluginGet(string).getGlobalComponents(properties);
    }

    @Override
    public GenericPluginInterface[] pluginGetAll(boolean bl) {
        String[] stringArray = this.pluginGetNames();
        GenericPluginInterface[] genericPluginInterfaceArray = new GenericPluginInterface[stringArray.length];
        for (int i = 0; i < genericPluginInterfaceArray.length; ++i) {
            genericPluginInterfaceArray[i] = this.pluginGet(stringArray[i]);
        }
        return genericPluginInterfaceArray;
    }

    @Override
    public String pluginGetFullName(String string) {
        return this.pluginGet(string).getFullName();
    }

    @Override
    public String pluginGetAuthor(String string) {
        return this.pluginGet(string).getAuthorName();
    }

    @Override
    public String pluginGetWebsite(String string) {
        return this.pluginGet(string).getAuthorWebsite();
    }

    @Override
    public String pluginGetEmail(String string) {
        return this.pluginGet(string).getAuthorEmail();
    }

    @Override
    public String pluginGetLongDescription(String string) {
        return this.pluginGet(string).getLongDescription();
    }
}

