/*
 * Decompiled with CFR 0.152.
 */
package com.javaop._main;

import com.javaop.bot.JavaOpFileStuff;
import com.javaop.pluginmanagers.PluginManager;
import com.javaop.util.RelativeFile;
import com.javaop.util.gui.Gui;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public class ConfigurePlugins
extends JFrame
implements WindowListener {
    private static final long serialVersionUID = 1L;
    private JList list;
    private boolean dirty = true;
    private DefaultListModel listData;

    public ConfigurePlugins() {
        super("Configure loaded plugins");
        try {
            this.listData = new DefaultListModel();
            String[] stringArray = JavaOpFileStuff.getRawPluginPaths();
            for (int i = 0; i < stringArray.length; ++i) {
                this.listData.addElement(stringArray[i].toString());
            }
            this.setDefaultCloseOperation(0);
            this.getContentPane().setLayout(new BorderLayout(5, 5));
            this.getContentPane().add((Component)new Form(), "Center");
            this.getContentPane().add((Component)new JLabel(), "North");
            this.getContentPane().add((Component)new JLabel(), "East");
            this.getContentPane().add((Component)new JLabel(), "South");
            this.getContentPane().add((Component)new JLabel(), "West");
            this.setSize(750, 550);
            Gui.center(this);
            this.setVisible(true);
            this.addWindowListener(this);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error populating plugin list: " + throwable);
        }
    }

    private void save() throws IOException {
        File file = JavaOpFileStuff.getPluginPathsFile();
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        Enumeration enumeration = this.listData.elements();
        while (enumeration.hasMoreElements()) {
            printWriter.println(enumeration.nextElement());
        }
        printWriter.close();
        this.dirty = false;
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (this.dirty) {
            int n = JOptionPane.showConfirmDialog(this, "Do you want to save before exiting?", "Save?", 1);
            if (n == 2) {
                return;
            }
            if (n == 0) {
                try {
                    this.save();
                    System.exit(0);
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(null, "An error occurred writing to the file: " + iOException.toString());
                }
            }
        }
        System.exit(0);
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    public static void main(String[] stringArray) {
        JavaOpFileStuff.setBaseDirectory();
        PluginManager.initialize(false);
        new ConfigurePlugins();
    }

    private class FindJarFiles
    extends javax.swing.filechooser.FileFilter
    implements FileFilter {
        private FindJarFiles() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().matches(".*\\.jar");
        }

        @Override
        public String getDescription() {
            return "JavaOp2 Plugin Files (*.jar)";
        }
    }

    private class AddSection
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private JButton addFile;
        private JButton addUrl;
        private JButton remove;
        private JButton save;

        public AddSection() {
            this.setLayout(new GridLayout(0, 3, 5, 5));
            this.add(new JLabel());
            this.addFile = new JButton("Add from file...");
            this.add(this.addFile);
            this.add(new JLabel());
            this.add(new JLabel());
            this.addUrl = new JButton("Add from url...");
            this.add(this.addUrl);
            this.add(new JLabel());
            this.add(new JLabel());
            this.remove = new JButton("Remove");
            this.add(this.remove);
            this.add(new JLabel());
            this.add(new JLabel());
            this.save = new JButton("Save");
            this.add(this.save);
            this.add(new JLabel());
            this.addFile.addActionListener(this);
            this.addUrl.addActionListener(this);
            this.remove.addActionListener(this);
            this.save.addActionListener(this);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 2), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.addFile) {
                JFileChooser jFileChooser = new JFileChooser(new RelativeFile(""));
                jFileChooser.setFileHidingEnabled(false);
                jFileChooser.setMultiSelectionEnabled(true);
                jFileChooser.setFileSelectionMode(2);
                jFileChooser.setFileFilter(new FindJarFiles());
                if (jFileChooser.showOpenDialog(this) == 0) {
                    File[] fileArray = jFileChooser.getSelectedFiles();
                    for (int i = 0; i < fileArray.length; ++i) {
                        ConfigurePlugins.this.listData.addElement(fileArray[i].getAbsolutePath());
                    }
                    ConfigurePlugins.this.dirty = true;
                }
            } else if (actionEvent.getSource() == this.addUrl) {
                String string = JOptionPane.showInputDialog(this, (Object)"Please type the url here.");
                if (string != null) {
                    ConfigurePlugins.this.listData.addElement(string);
                    ConfigurePlugins.this.dirty = true;
                }
            } else if (actionEvent.getSource() == this.remove) {
                int[] nArray = ConfigurePlugins.this.list.getSelectedIndices();
                if (nArray != null) {
                    for (int i = 0; i < nArray.length; ++i) {
                        ConfigurePlugins.this.listData.remove(nArray[i]);
                    }
                    if (nArray[0] >= ConfigurePlugins.this.listData.getSize()) {
                        ConfigurePlugins.this.list.setSelectedIndex(ConfigurePlugins.this.listData.getSize() - 1);
                    } else {
                        ConfigurePlugins.this.list.setSelectedIndex(nArray[0]);
                    }
                    ConfigurePlugins.this.dirty = true;
                }
            } else if (actionEvent.getSource() == this.save) {
                try {
                    ConfigurePlugins.this.save();
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(null, "An error occurred writing to the file: " + iOException.toString());
                }
            }
        }
    }

    private class ListSection
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public ListSection() {
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)new JLabel("Loaded paths:"), "North");
            this.add((Component)new JScrollPane(ConfigurePlugins.this.list = new JList(ConfigurePlugins.this.listData)), "Center");
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 2), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            ConfigurePlugins.this.list.setCellRenderer(new MyCellRenderer());
        }

        private class MyCellRenderer
        implements ListCellRenderer {
            private MyCellRenderer() {
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = new JLabel(object.toString());
                ((Component)jLabel).setBackground(Color.WHITE);
                ((Component)jLabel).setForeground(Color.BLACK);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new GridLayout());
                jPanel.setBackground(Color.WHITE);
                jPanel.setForeground(Color.BLACK);
                jPanel.add(jLabel);
                if (bl) {
                    jPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
                } else {
                    jPanel.setBorder(BorderFactory.createLineBorder(jList.getBackground(), 2));
                }
                return jPanel;
            }
        }
    }

    private class Form
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public Form() {
            this.setLayout(new BorderLayout(10, 10));
            this.add((Component)new ListSection(), "Center");
            this.add((Component)new AddSection(), "South");
        }
    }
}

