/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.Ping;

import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.plugin_interfaces.PacketCallback;
import com.javaop.util.BnetPacket;
import com.javaop.util.Buffer;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class PluginMain
extends GenericPluginInterface
implements PacketCallback {
    private PublicExposedFunctions out;

    public void load(StaticExposedFunctions staticExposedFunctions) {
    }

    public void activate(PublicExposedFunctions publicExposedFunctions, PluginCallbackRegister pluginCallbackRegister) {
        this.out = publicExposedFunctions;
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 0, null);
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 37, null);
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 81, null);
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 74, null);
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 76, null);
    }

    public void deactivate(PluginCallbackRegister pluginCallbackRegister) {
    }

    public BnetPacket processingPacket(BnetPacket bnetPacket, Object object) {
        return bnetPacket;
    }

    public void processedPacket(BnetPacket bnetPacket, Object object) throws IOException {
        switch (bnetPacket.getCode()) {
            case 37: {
                this.out.setTCPNoDelay(true);
                this.out.sendPacket((Buffer)bnetPacket);
                this.out.setTCPNoDelay(false);
                break;
            }
            case 81: {
                if (bnetPacket.removeDWord() != 0) {
                    return;
                }
                BnetPacket bnetPacket2 = new BnetPacket();
                bnetPacket2.setCode((byte)20);
                bnetPacket2.addBytes(new byte[]{98, 110, 101, 116});
                this.out.sendPacket((Buffer)bnetPacket2);
                break;
            }
            case 0: {
                break;
            }
            case 74: {
                this.out.systemMessage(1, "Optional Work: " + bnetPacket.removeNTString() + ". (SID_OPTIONALWORK)");
                break;
            }
            case 76: {
                this.out.systemMessage(1, "Required Work: " + bnetPacket.removeNTString() + ". (SID_REQUIREDWORK)");
            }
        }
    }

    public String getName() {
        return "Ping";
    }

    public String getVersion() {
        return "2.1.3";
    }

    public String getAuthorName() {
        return "iago, joe";
    }

    public String getAuthorWebsite() {
        return "http://www.javaop.com";
    }

    public String getAuthorEmail() {
        return "joetheodd@gmail.com";
    }

    public String getShortDescription() {
        return "Looks after ping and other keepalive messages, as well as extra and required work packets.";
    }

    public String getLongDescription() {
        return "Returns a ping message (if set to) when SID_PING is received.  Also sends back the UDP Ping probe at the appropriate time.  Either of these can be disabled to get either \"unplugged\" icon, or -1ms ping. This also handles displaying of the SID_OPTIONALWORK and SID_REQUIREWORK packets.";
    }

    public Properties getDefaultSettingValues() {
        Properties properties = new Properties();
        properties.setProperty("Return Ping", "true");
        properties.setProperty("Return UDP Ping", "true");
        return properties;
    }

    public Properties getSettingsDescription() {
        Properties properties = new Properties();
        properties.setProperty("Return Ping", "Turn this off to get \"unplugged\" icon.");
        properties.setProperty("Return UDP Ping", "Turn this off to get -1ms ping.");
        return properties;
    }

    public JComponent getComponent(String string, String string2) {
        return new JCheckBox("", string2.equalsIgnoreCase("true"));
    }

    public Properties getGlobalDefaultSettingValues() {
        Properties properties = new Properties();
        return properties;
    }

    public Properties getGlobalSettingsDescription() {
        Properties properties = new Properties();
        return properties;
    }

    public JComponent getGlobalComponent(String string, String string2) {
        return null;
    }

    public boolean isRequiredPlugin() {
        return false;
    }
}

