/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.FunStuff;

import com.javaop.FunStuff.Define;
import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.CommandUsedIllegally;
import com.javaop.exceptions.CommandUsedImproperly;
import com.javaop.exceptions.PluginException;
import com.javaop.plugin_interfaces.CommandCallback;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.util.PersistantMap;
import com.javaop.util.RelativeFile;
import com.javaop.util.Uniq;
import com.javaop.util.gui.JTextFieldNumeric;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import java.util.Random;
import javax.swing.JComponent;

public class PluginMain
extends GenericPluginInterface
implements CommandCallback {
    private PublicExposedFunctions out;
    private final Random random = new Random();
    private PersistantMap quotes;

    public void load(StaticExposedFunctions staticExposedFunctions) {
    }

    public void activate(PublicExposedFunctions publicExposedFunctions, PluginCallbackRegister pluginCallbackRegister) {
        this.out = publicExposedFunctions;
        this.quotes = new PersistantMap((File)new RelativeFile(publicExposedFunctions.getName() + ".quotes"), "These are the quotes, one per line");
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "quote", 1, false, "L", "[num]", "Displays the specified quote (or a random one if none is specified)", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "addquote", 1, false, "L", "<quote>", "Adds a quote to the quote database", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "removequote", 1, false, "A", "<?????>", "Removes a quote from the quote database", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "pickrandom", 1, false, "L", "<option list>", "Picks a random option from the list.  Options are separated by commas", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "random", 0, false, "L", "[min] [max]", "Picks a random number between min and max.  If only one parameter is given, it picks between 1 and <max>.  If no parameters are given, it picks between 1 and 10.", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "host", 1, false, "L", "<hostname>", "Resolves the given hostname to its ip(s)", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "time", 0, false, "L", "", "Displays the current time/date", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "define", 1, false, "L", "", "Tries to get the dictionary definition of the word", null);
        publicExposedFunctions.addAlias("pickrandom heads,tails", "flip");
        publicExposedFunctions.addAlias("time", "date");
    }

    public void deactivate(PluginCallbackRegister pluginCallbackRegister) {
    }

    public String getName() {
        return "FunStuff";
    }

    public String getVersion() {
        return "2.1.3";
    }

    public String getAuthorName() {
        return "iago";
    }

    public String getAuthorWebsite() {
        return "www.javaop.com";
    }

    public String getAuthorEmail() {
        return "iago@valhallalegends.com";
    }

    public String getShortDescription() {
        return "A plugin for fun stuff";
    }

    public String getLongDescription() {
        return "This plugin provides useless functionality such as flipping a coin, picking a random number, etc.";
    }

    public Properties getDefaultSettingValues() {
        Properties properties = new Properties();
        properties.setProperty("definitions", "3");
        return properties;
    }

    public Properties getSettingsDescription() {
        Properties properties = new Properties();
        properties.setProperty("definitions", "The number of definitions that ?define returns.  I recommend around 3 because this will kill the message queue.  0 = unlimited.");
        return properties;
    }

    public JComponent getComponent(String string, String string2) {
        return new JTextFieldNumeric(string2);
    }

    public Properties getGlobalDefaultSettingValues() {
        Properties properties = new Properties();
        return properties;
    }

    public Properties getGlobalSettingsDescription() {
        Properties properties = new Properties();
        return properties;
    }

    public JComponent getGlobalComponent(String string, String string2) {
        return null;
    }

    public void commandExecuted(String string, String string2, String[] stringArray, int n, Object object) throws PluginException, IOException, CommandUsedIllegally, CommandUsedImproperly {
        if (string2.equalsIgnoreCase("quote")) {
            Properties properties = this.quotes.getSection(null);
            String[] stringArray2 = Uniq.uniq(properties.keys());
            int n2 = stringArray.length == 0 ? this.random.nextInt(stringArray2.length) : Integer.parseInt(stringArray[0]) - 1;
            if (n2 < 0 || n2 >= stringArray2.length) {
                this.out.sendTextUser(string, "Error: quote #" + (n2 + 1) + " not found!", 0);
            } else {
                this.out.sendTextPriority(n2 + 1 + ": " + properties.getProperty(stringArray2[n2]), -100);
            }
        } else if (string2.equalsIgnoreCase("removequote")) {
            if (stringArray.length != 1) {
                throw new CommandUsedImproperly("removequote requires a parameter", string, string2);
            }
            Properties properties = this.quotes.getSection(null);
            String[] stringArray3 = Uniq.uniq(properties.keys());
            int n3 = Integer.parseInt(stringArray[0]) - 1;
            if (n3 < 0 || n3 >= stringArray3.length) {
                this.out.sendTextUser(string, "Error: quote #" + (n3 + 1) + " not found!", 0);
            } else {
                this.quotes.remove(null, stringArray3[n3]);
                this.out.sendTextUser(string, "Quote #" + (n3 + 1) + " removed", 0);
            }
        } else if (string2.equalsIgnoreCase("addquote")) {
            if (stringArray.length != 1) {
                throw new CommandUsedImproperly("addquote requires a single parameter (the quote to add)", string, string2);
            }
            this.quotes.set(null, System.currentTimeMillis() + "", stringArray[0]);
            this.out.sendTextUserPriority(string, "Quote added", n, -50);
        } else if (string2.equalsIgnoreCase("clearquotes")) {
            Properties properties = this.quotes.getSection(null);
            String[] stringArray4 = Uniq.uniq(properties.keys());
            for (int i = 0; i < stringArray4.length; ++i) {
                this.quotes.remove(null, stringArray4[i]);
            }
        } else if (string2.equalsIgnoreCase("flip")) {
            if (this.random.nextInt(2) == 0) {
                this.out.sendTextPriority("Heads", -100);
            } else {
                this.out.sendTextPriority("Tails", -100);
            }
        } else if (string2.equalsIgnoreCase("pickrandom")) {
            if (stringArray.length == 0) {
                throw new CommandUsedImproperly("pickrandom requires a comma-separated list of choices", string, string2);
            }
            String[] stringArray5 = stringArray[0].split(",");
            this.out.sendTextPriority(" " + stringArray5[this.random.nextInt(stringArray5.length)].trim(), -100);
        } else if (string2.equalsIgnoreCase("random")) {
            int n4;
            if (stringArray.length == 0) {
                n4 = this.random.nextInt(10) + 1;
            } else if (stringArray.length == 1) {
                n4 = this.random.nextInt(Integer.parseInt(stringArray[0])) + 1;
            } else {
                int n5;
                int n6 = Integer.parseInt(stringArray[0]);
                if (n6 > (n5 = Integer.parseInt(stringArray[1]))) {
                    throw new CommandUsedImproperly("In random, the minimum value has to be below the maximum value", string, string2);
                }
                n4 = this.random.nextInt(n5 - n6 + 1) + n6;
            }
            this.out.sendTextPriority(n4 + "", -100);
        } else if (string2.equalsIgnoreCase("host")) {
            if (stringArray.length == 0) {
                throw new CommandUsedImproperly("Must specify an address to look up", string, string2);
            }
            try {
                InetAddress[] inetAddressArray = InetAddress.getAllByName(stringArray[0]);
                Object[] objectArray = new String[inetAddressArray.length];
                for (int i = 0; i < inetAddressArray.length; ++i) {
                    objectArray[i] = inetAddressArray[i].getHostAddress();
                }
                Arrays.sort(objectArray);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(stringArray[0] + ": ");
                for (int i = 0; i < inetAddressArray.length; ++i) {
                    stringBuffer.append((String)objectArray[i] + (i + 1 < inetAddressArray.length ? ", " : ""));
                }
                this.out.sendTextUserPriority(string, stringBuffer.toString(), n, -50);
            }
            catch (UnknownHostException unknownHostException) {
                this.out.sendTextUser(string, "Unknown host: " + unknownHostException.getMessage(), n);
            }
        } else if (string2.equalsIgnoreCase("time")) {
            this.out.sendTextUserPriority(string, new Date().toString(), n, -50);
        } else if (string2.equalsIgnoreCase("define")) {
            if (stringArray.length == 0) {
                throw new CommandUsedImproperly("Must specify a word to define", string, string2);
            }
            new DefineThread(string, n, Integer.parseInt(this.out.getLocalSetting(this.getName(), "definitions")), stringArray[0]).start();
        } else {
            this.out.sendTextUser(string, "An unknown command was used in FunStuff plugin.  Please report to iago.", n);
        }
    }

    private class DefineThread
    extends Thread {
        private final String word;
        private final int loudness;
        private final int max;
        private final String user;

        public DefineThread(String string, int n, int n2, String string2) {
            this.user = string;
            this.loudness = n;
            this.max = n2;
            this.word = string2;
            this.setName("Define-thread");
        }

        @Override
        public void run() {
            try {
                String[] stringArray = Define.define(this.word);
                if (stringArray.length == 0) {
                    PluginMain.this.out.sendTextUser(this.user, "No definitions found for word '" + this.word + "'.", this.loudness);
                }
                System.out.println("retrieving " + this.max + " definitions");
                for (int i = 0; i < stringArray.length && (this.max == 0 || i < this.max); ++i) {
                    PluginMain.this.out.sendTextUserPriority(this.user, i + 1 + ": " + stringArray[i], this.loudness, -100);
                }
            }
            catch (IOException iOException) {
                try {
                    PluginMain.this.out.sendTextUser(this.user, "Error looking up word: " + iOException.toString(), this.loudness);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

