/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.War3Clan;

import com.javaop.War3Clan.ClanConstants;
import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.CommandUsedIllegally;
import com.javaop.exceptions.CommandUsedImproperly;
import com.javaop.exceptions.PluginException;
import com.javaop.plugin_interfaces.CommandCallback;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.plugin_interfaces.PacketCallback;
import com.javaop.util.BnetPacket;
import com.javaop.util.Buffer;
import com.javaop.util.ColorConstants;
import com.javaop.util.Uniq;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JComponent;

public class PluginMain
extends GenericPluginInterface
implements PacketCallback,
CommandCallback,
ClanConstants {
    private PublicExposedFunctions out;
    private final Hashtable invites = new Hashtable();

    public void load(StaticExposedFunctions staticExposedFunctions) {
    }

    public void activate(PublicExposedFunctions publicExposedFunctions, PluginCallbackRegister pluginCallbackRegister) {
        this.out = publicExposedFunctions;
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 117, null);
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 118, null);
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 121, null);
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 124, null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "accept", 1, false, "N", "<clan name>", "Accepts an invitation to a clan", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "decline", 1, false, "N", "<clan name>", "Rejects an invitation to a clan", null);
        pluginCallbackRegister.registerCommandPlugin((CommandCallback)this, "invites", 0, false, "AN", "", "Lists the pending invites", null);
    }

    public void deactivate(PluginCallbackRegister pluginCallbackRegister) {
    }

    public String getName() {
        return "War3Clan";
    }

    public String getVersion() {
        return "2.1.3";
    }

    public String getAuthorName() {
        return "iago";
    }

    public String getAuthorWebsite() {
        return "www.javaop.com";
    }

    public String getAuthorEmail() {
        return "iago@valhallalegends.com";
    }

    public String getShortDescription() {
        return "Clan related stuff";
    }

    public String getLongDescription() {
        return "So far, just displays some clan-related information";
    }

    public Properties getDefaultSettingValues() {
        return new Properties();
    }

    public Properties getSettingsDescription() {
        return new Properties();
    }

    public JComponent getComponent(String string, String string2) {
        return null;
    }

    public Properties getGlobalDefaultSettingValues() {
        Properties properties = new Properties();
        return properties;
    }

    public Properties getGlobalSettingsDescription() {
        Properties properties = new Properties();
        return properties;
    }

    public JComponent getGlobalComponent(String string, String string2) {
        return null;
    }

    public BnetPacket processingPacket(BnetPacket bnetPacket, Object object) throws IOException, PluginException {
        return bnetPacket;
    }

    public void processedPacket(BnetPacket bnetPacket, Object object) throws IOException, PluginException {
        if (bnetPacket.getCode() == 117) {
            bnetPacket.removeByte();
            String string = this.getClanTag(bnetPacket.removeString(4));
            byte by = bnetPacket.removeByte();
            this.out.showMessage(ColorConstants.getColor((String)"Clan message") + "You're in clan " + ColorConstants.getColor((String)"Clan emphasize") + string + ColorConstants.getColor((String)"Clan message") + " with rank " + ColorConstants.getColor((String)"Clan emphasize") + clanMemberConstants[by]);
        } else if (bnetPacket.getCode() == 118) {
            this.out.showMessage(ColorConstants.getColor((String)"Clan message") + "Removed from clan.");
        } else if (bnetPacket.getCode() == 121) {
            int n = bnetPacket.removeDWord();
            String string = bnetPacket.removeString(4);
            String string2 = bnetPacket.removeNTString();
            String string3 = bnetPacket.removeNTString();
            Invite invite = new Invite(n, string, string2, string3);
            this.invites.put(string2, invite);
            this.out.showMessage(ColorConstants.getColor((String)"Clan message") + "You were invited to a clan:");
            this.out.showMessage(ColorConstants.getColor((String)"Clan message") + invite.toString());
            this.out.showMessage(ColorConstants.getColor((String)"Clan message") + "Please use '/accept " + string2 + "' or '/decline " + string2 + "'");
            if (this.invites.size() > 1) {
                this.out.showMessage(ColorConstants.getColor((String)"Clan message") + "You have " + this.invites.size() + " pending invites.  Use '/invites' for more information");
            }
        } else if (bnetPacket.getCode() == 124) {
            bnetPacket.removeDWord();
            bnetPacket.removeDWord();
            String string = bnetPacket.removeNTString();
            this.out.showMessage(ColorConstants.getColor((String)"Clan message") + "Message of the Day:");
            this.out.showMessage(ColorConstants.getColor((String)"Clan emphasize") + string);
        }
    }

    private String getClanTag(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = string.length() - 1; i >= 0; --i) {
            if (string.charAt(i) <= '\u0000') continue;
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public void commandExecuted(String string, String string2, String[] stringArray, int n, Object object) throws PluginException, IOException, CommandUsedIllegally, CommandUsedImproperly {
        if (string2.equalsIgnoreCase("accept") || string2.equalsIgnoreCase("decline")) {
            if (stringArray.length != 1) {
                throw new CommandUsedImproperly("Accept and decline require the clan name as a parameter", string, string2);
            }
            Invite invite = (Invite)this.invites.get(stringArray[0]);
            if (invite == null) {
                this.out.sendTextUser(string, "Clan name not found in invites: " + stringArray[0], n);
            } else {
                if (string2.equalsIgnoreCase("accept")) {
                    this.out.sendPacket((Buffer)invite.getAccept());
                    this.out.sendTextUser(string, "Clan invitation accepted: " + invite, n);
                } else {
                    this.out.sendPacket((Buffer)invite.getDecline());
                    this.out.sendTextUser(string, "Clan invitation rejected: " + invite, n);
                }
                this.invites.remove(stringArray[0]);
            }
        } else if (string2.equalsIgnoreCase("invites")) {
            String[] stringArray2 = Uniq.uniq(this.invites.keys());
            this.out.sendTextUserPriority(string, "You have " + stringArray2.length + " pending invitations", n, -50);
            for (int i = 0; i < stringArray2.length; ++i) {
                this.out.sendTextUserPriority(string, i + 1 + ": " + this.invites.get(stringArray2[i]).toString(), n, -50);
            }
        } else if (!string2.equalsIgnoreCase("invite")) {
            this.out.sendTextUserPriority(string, "Error, unknown command in War3Clan: " + string2, n, -50);
        }
    }

    private class Invite {
        private final int cookie;
        private final String clanTag;
        private final String clanName;
        private final String inviter;

        public Invite(int n, String string, String string2, String string3) {
            this.cookie = n;
            this.clanTag = string;
            this.clanName = string2;
            this.inviter = string3;
        }

        public String toString() {
            return "Tag: " + PluginMain.this.getClanTag(this.clanTag) + "; name: " + this.clanName + "; invited by: " + this.inviter;
        }

        public BnetPacket getAccept() {
            BnetPacket bnetPacket = new BnetPacket(121);
            bnetPacket.add(this.cookie);
            bnetPacket.addString(this.clanTag);
            bnetPacket.addNTString(this.inviter);
            bnetPacket.addByte((byte)6);
            return bnetPacket;
        }

        public BnetPacket getDecline() {
            BnetPacket bnetPacket = new BnetPacket(121);
            bnetPacket.add(this.cookie);
            bnetPacket.addString(this.clanTag);
            bnetPacket.addNTString(this.inviter);
            bnetPacket.addByte((byte)5);
            return bnetPacket;
        }
    }
}

