/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.EmailRegister;

import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.PluginException;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.plugin_interfaces.PacketCallback;
import com.javaop.util.BnetPacket;
import com.javaop.util.Buffer;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class PluginMain
extends GenericPluginInterface
implements PacketCallback {
    private PublicExposedFunctions out;

    public void load(StaticExposedFunctions staticExposedFunctions) {
    }

    public void activate(PublicExposedFunctions publicExposedFunctions, PluginCallbackRegister pluginCallbackRegister) {
        this.out = publicExposedFunctions;
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 89, null);
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 84, null);
        pluginCallbackRegister.registerIncomingPacketPlugin((PacketCallback)this, 81, null);
    }

    public void deactivate(PluginCallbackRegister pluginCallbackRegister) {
    }

    public String getName() {
        return "EmailRegister";
    }

    public String getVersion() {
        return "2.1.3";
    }

    public String getAuthorName() {
        return "iago";
    }

    public String getAuthorWebsite() {
        return "www.javaop.com";
    }

    public String getAuthorEmail() {
        return "iago@valhallalegends.com";
    }

    public String getShortDescription() {
        return "Email registration";
    }

    public String getLongDescription() {
        return "Allows users to set an email address for their account, and to request their password be reset";
    }

    public Properties getDefaultSettingValues() {
        Properties properties = new Properties();
        properties.setProperty("Email", "");
        properties.setProperty("Register email", "true");
        properties.setProperty("Try to recover", "false");
        return properties;
    }

    public Properties getSettingsDescription() {
        Properties properties = new Properties();
        properties.setProperty("Email", "The email address to register accounts to.");
        properties.setProperty("Register email", "Check this if you want to attempt to register your email whenever you log on.");
        properties.setProperty("Try to recover", "Check this ONLY if you need the password reset.");
        return properties;
    }

    public Properties getGlobalDefaultSettingValues() {
        Properties properties = new Properties();
        return properties;
    }

    public Properties getGlobalSettingsDescription() {
        Properties properties = new Properties();
        return properties;
    }

    public JComponent getGlobalComponent(String string, String string2) {
        return null;
    }

    public JComponent getComponent(String string, String string2) {
        if (string2 == null) {
            System.err.println(string + " = null??");
        }
        if (string.equalsIgnoreCase("Register email") || string.equalsIgnoreCase("Try to recover")) {
            return new JCheckBox("", string2 != null && string2.equalsIgnoreCase("true"));
        }
        return null;
    }

    public boolean isRequiredPlugin() {
        return false;
    }

    public BnetPacket processingPacket(BnetPacket bnetPacket, Object object) throws IOException, PluginException {
        return bnetPacket;
    }

    private void setEmail() throws IOException {
        String string = this.out.getLocalSettingDefault(this.getName(), "Email", "");
        if (string.length() == 0 || string.indexOf(64) < 0) {
            this.out.systemMessage(5, "Attempted to register invalid email address; cancelled");
        } else {
            this.out.systemMessage(3, "Attempting to register your email address");
            BnetPacket bnetPacket = new BnetPacket(89);
            bnetPacket.addNTString(string);
            this.out.sendPacket((Buffer)bnetPacket);
        }
    }

    public void processedPacket(BnetPacket bnetPacket, Object object) throws IOException, PluginException {
        if (this.out.getLocalSettingDefault(this.getName(), "Register email", "false").equalsIgnoreCase("true")) {
            if (bnetPacket.getCode() == 89) {
                this.setEmail();
            } else if (bnetPacket.getCode() == 84 && bnetPacket.removeDWord() == 14) {
                this.setEmail();
            }
        }
        if (this.out.getLocalSettingDefault(this.getName(), "Try to recover", "false").equalsIgnoreCase("true") && bnetPacket.getCode() == 81) {
            BnetPacket bnetPacket2 = new BnetPacket(90);
            bnetPacket2.addNTString(this.out.getLocalSetting("battle.net login plugin", "username"));
            bnetPacket2.addNTString(this.out.getLocalSettingDefault(this.getName(), "Email", ""));
            this.out.sendPacket((Buffer)bnetPacket2);
            this.out.systemMessage(4, "Tried to reset password via email; check your email.");
        }
    }
}

