/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.AwayMessage;

import com.javaop.callback_interfaces.PluginCallbackRegister;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.PluginException;
import com.javaop.plugin_interfaces.EventCallback;
import com.javaop.plugin_interfaces.GenericPluginInterface;
import com.javaop.plugin_interfaces.OutgoingTextCallback;
import com.javaop.util.TimeReader;
import com.javaop.util.gui.JTextFieldNumeric;
import java.io.IOException;
import java.util.Properties;
import java.util.TimerTask;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class PluginMain
extends GenericPluginInterface
implements OutgoingTextCallback,
EventCallback {
    private PublicExposedFunctions out;
    private long lastMessage = System.currentTimeMillis();
    private boolean away = false;

    public void load(StaticExposedFunctions staticExposedFunctions) {
    }

    public void activate(PublicExposedFunctions publicExposedFunctions, PluginCallbackRegister pluginCallbackRegister) {
        this.out = publicExposedFunctions;
        pluginCallbackRegister.registerOutgoingTextPlugin((OutgoingTextCallback)this, null);
        pluginCallbackRegister.registerEventPlugin((EventCallback)this, null);
        publicExposedFunctions.schedule((TimerTask)new Callback(), (long)(1000 * Integer.parseInt(publicExposedFunctions.getLocalSettingDefault(this.getName(), "Update idle", "60"))));
    }

    public void deactivate(PluginCallbackRegister pluginCallbackRegister) {
    }

    public String getName() {
        return "AwayMessage";
    }

    public String getVersion() {
        return "2.1.3";
    }

    public String getAuthorName() {
        return "iago";
    }

    public String getAuthorWebsite() {
        return "www.javaop.com";
    }

    public String getAuthorEmail() {
        return "iago@valhallalegends.com";
    }

    public String getLongDescription() {
        return "Sets an away message that tells people how long you've been away from your bot.  This is reset by, by default, any outgoing text that doesn't begin with /, so if somebody uses .say or a similar command the idle turns off.";
    }

    public Properties getDefaultSettingValues() {
        Properties properties = new Properties();
        properties.setProperty("Start showing idle", "180");
        properties.setProperty("Update idle", "60");
        properties.setProperty("Show only minutes", "true");
        properties.setProperty("/commands end idle", "false");
        properties.setProperty("Away message", "Bot has been idle for %t");
        return properties;
    }

    public Properties getSettingsDescription() {
        Properties properties = new Properties();
        properties.setProperty("Start showing idle", "This is the time (in seconds) before the first idle message is set.");
        properties.setProperty("Update idle", "This is the amount of time that the idle time is updated.  If you're displaying seconds, an odd number like 17 or 29 is useful.  WARNING: don't put this so low that it backs up the flood protection! [Must reload bot to take effect]");
        properties.setProperty("Show only minutes", "If this is turned off, it'll show seconds.  This is usually pretty redundant, but some people like it.");
        properties.setProperty("/commands end idle", "If this is enabled, then a /command (like /whereis iago) won't reset the idle.");
        properties.setProperty("Away message", "The away message.  %t is replaced with the elapsed time.  You can have more than one %t if you really want.  %t also isn't required if you just want a standard away message.");
        return properties;
    }

    public JComponent getComponent(String string, String string2) {
        if (string.equalsIgnoreCase("/commands end idle") || string.equalsIgnoreCase("Show only minutes")) {
            return new JCheckBox("", string2.equalsIgnoreCase("true"));
        }
        if (string.equalsIgnoreCase("Start showing idle") || string.equalsIgnoreCase("update idle")) {
            return new JTextFieldNumeric(string2);
        }
        return null;
    }

    public Properties getGlobalDefaultSettingValues() {
        Properties properties = new Properties();
        return properties;
    }

    public Properties getGlobalSettingsDescription() {
        Properties properties = new Properties();
        return properties;
    }

    public JComponent getGlobalComponent(String string, String string2) {
        return null;
    }

    public String queuingText(String string, Object object) {
        return string;
    }

    public void queuedText(String string, Object object) {
    }

    public String nextInLine(String string, Object object) {
        return string;
    }

    public long getDelay(String string, Object object) {
        return 0L;
    }

    public boolean sendingText(String string, Object object) {
        return true;
    }

    public void sentText(String string, Object object) {
        try {
            if (this.out.getLocalSettingDefault(this.getName(), "/commands end idle", "false").equalsIgnoreCase("false") && string.matches("/.*")) {
                return;
            }
            if (!string.matches("/away.*")) {
                this.lastMessage = System.currentTimeMillis();
                if (this.away) {
                    this.out.sendText("/away");
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void info(String string, String string2, int n, int n2) throws IOException, PluginException {
        if (string2.equalsIgnoreCase("You are now marked as being away.")) {
            this.away = true;
        }
        if (string2.equalsIgnoreCase("You are no longer marked as away.")) {
            this.away = false;
        }
    }

    public void talk(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void emote(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void whisperFrom(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void whisperTo(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void userShow(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void userJoin(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void userLeave(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void userFlags(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void error(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void broadcast(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    public void channel(String string, String string2, int n, int n2) throws IOException, PluginException {
    }

    private class Callback
    extends TimerTask {
        private Callback() {
        }

        @Override
        public void run() {
            try {
                long l = System.currentTimeMillis() - PluginMain.this.lastMessage;
                if (l / 1000L > (long)Integer.parseInt(PluginMain.this.out.getLocalSettingDefault(PluginMain.this.getName(), "Start showing idle", "180"))) {
                    String string = PluginMain.this.out.getLocalSettingDefault(PluginMain.this.getName(), "Away message", "Bot has been idle for %t");
                    if (PluginMain.this.out.getLocalSettingDefault(PluginMain.this.getName(), "Show only minutes", "true").equalsIgnoreCase("true")) {
                        l /= 1000L;
                        l /= 60L;
                        if (++l > 60L) {
                            long l2 = l / 60L;
                            long l3 = l % 60L;
                            string = string.replaceAll("%t", l2 + " hour" + (l2 == 1L ? "" : "s") + ", " + l3 + " minute" + (l3 == 1L ? "" : "s"));
                        } else {
                            string = string.replaceAll("%t", l + " minute" + (l == 1L ? "" : "s"));
                        }
                    } else {
                        string = string.replaceAll("%t", TimeReader.timeToString((long)l));
                    }
                    PluginMain.this.out.sendText("/away " + string);
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
        }
    }
}

