/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.BNetLogin.versioning;

import com.javaop.BNetLogin.versioning.Bnls;
import com.javaop.BNetLogin.versioning.CheckRevisionResults;
import com.javaop.BNetLogin.versioning.Game;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.LoginException;
import com.javaop.util.Buffer;
import java.io.IOException;

public class Versioning {
    private static boolean bnlsFailed = false;

    public static int VersionByte(String string, PublicExposedFunctions publicExposedFunctions) throws LoginException {
        StaticExposedFunctions staticExposedFunctions = publicExposedFunctions.getStaticExposedFunctionsHandle();
        Game game = new Game(string);
        if (bnlsFailed || !Bnls.isEnabled(staticExposedFunctions)) {
            publicExposedFunctions.systemMessage(2, "Using local version byte for " + game.getName());
            return game.getVersionByte();
        }
        try {
            publicExposedFunctions.systemMessage(2, "[BNLS] Retreiving version byte for " + game.getName());
            return Bnls.VersionByte(staticExposedFunctions, game);
        }
        catch (Exception exception) {
            bnlsFailed = true;
            publicExposedFunctions.systemMessage(4, "Caught exception when attempting to get verbyte from BNLS. Stack trace available on console. Will attempt to use local verbyte.");
            exception.printStackTrace();
            return Versioning.VersionByte(string, publicExposedFunctions);
        }
    }

    public static synchronized CheckRevisionResults CheckRevision(String string, PublicExposedFunctions publicExposedFunctions, String string2, byte[] byArray, long l) throws LoginException {
        StaticExposedFunctions staticExposedFunctions = publicExposedFunctions.getStaticExposedFunctionsHandle();
        Game game = new Game(string);
        if (bnlsFailed || !Bnls.isEnabled(staticExposedFunctions)) {
            try {
                publicExposedFunctions.systemMessage(2, "Running local version check for " + game.getName());
                return new CheckRevisionResults(game.getVersionHash(), game.doCheckRevision(byArray, string2), game.getExeInfo().getBytes());
            }
            catch (IOException iOException) {
                publicExposedFunctions.systemMessage(4, "Caught exception when attempting to perform check revision locally. Stack trace available on console. Disconnecting.");
                publicExposedFunctions.disconnect();
                return new CheckRevisionResults(0, 0, new byte[]{0});
            }
        }
        try {
            publicExposedFunctions.systemMessage(2, "[BNLS] Running version check for " + game.getName());
            return Bnls.CheckRevision(game, staticExposedFunctions, string2, l, byArray);
        }
        catch (Exception exception) {
            bnlsFailed = true;
            publicExposedFunctions.systemMessage(4, "Caught exception when attempting to perform check revision with BNLS. Stack trace available on console. Will attempt to perform CheckRevision locally.");
            exception.printStackTrace();
            return Versioning.CheckRevision(string, publicExposedFunctions, string2, byArray, l);
        }
    }

    public static Buffer CDKeyBlock(String string, int n, int n2, String string2, String string3) throws LoginException {
        return new Game(string).getKeyBuffer(string2, string3, n, n2);
    }
}

