/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.BNetLogin.versioning;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.LinkedList;

public class VerHash {
    private static final int PE_START = 60;
    private static final int RT_VERSION = 16;
    private static final long rsrc = 427121930798L;

    public static int getVersion(String string) {
        int n = 0;
        try {
            MappedByteBuffer mappedByteBuffer = new FileInputStream(string).getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, new File(string).length());
            mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            int n2 = mappedByteBuffer.getInt(60);
            int n3 = mappedByteBuffer.getInt(n2 + 0);
            if (n3 != 17744) {
                throw new IOException("Invalid PE file!");
            }
            short s = mappedByteBuffer.getShort(n2 + 6);
            int n4 = n2 + 24;
            n = VerHash.processOptionalHeader(mappedByteBuffer, n4, s);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        return n;
    }

    private static int processOptionalHeader(MappedByteBuffer mappedByteBuffer, int n, int n2) throws IOException {
        boolean bl = mappedByteBuffer.getShort(n) == 523;
        int n3 = mappedByteBuffer.getInt(n + (bl ? 108 : 92));
        int n4 = n + 96 + n3 * 8;
        int n5 = VerHash.processSections(mappedByteBuffer, n4, n2);
        if (n5 == 0) {
            throw new IOException("Couldn't find .rsrc section!");
        }
        return n5;
    }

    private static int processSections(MappedByteBuffer mappedByteBuffer, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            int n3 = mappedByteBuffer.getInt(n + i * 40 + 12);
            int n4 = mappedByteBuffer.getInt(n + i * 40 + 20);
            int n5 = n + i * 40;
            int n6 = n4 - n3;
            if (mappedByteBuffer.getLong(n + i * 40) != 427121930798L) continue;
            return VerHash.processResourceRecord(new LinkedList(), mappedByteBuffer, 0, mappedByteBuffer.getInt(n5 + 20), n6);
        }
        return 0;
    }

    private static int processResourceRecord(LinkedList linkedList, MappedByteBuffer mappedByteBuffer, int n, int n2, int n3) throws IOException {
        int n4 = n + n2;
        short s = mappedByteBuffer.getShort(n4 + 12);
        int n5 = mappedByteBuffer.getShort(n4 + 14);
        int n6 = n4 + 16 + s * 8;
        for (int i = 0; i < n5; ++i) {
            int n7 = n6 + i * 8;
            int n8 = VerHash.processEntry(new LinkedList(linkedList), mappedByteBuffer, n7, n2, n3);
            if (n8 == 0) continue;
            return n8;
        }
        return 0;
    }

    private static int processEntry(LinkedList linkedList, MappedByteBuffer mappedByteBuffer, int n, int n2, int n3) throws IOException {
        int n4 = mappedByteBuffer.getInt(n + 4);
        linkedList.addLast(mappedByteBuffer.getInt(n + 0));
        if ((n4 & Integer.MIN_VALUE) != 0) {
            int n5 = VerHash.processResourceRecord(linkedList, mappedByteBuffer, n4 & Integer.MAX_VALUE, n2, n3);
            if (n5 != 0) {
                return n5;
            }
        } else if (linkedList.get(0) == Integer.valueOf(16)) {
            int n6 = mappedByteBuffer.getInt(n2 + n4) + n3;
            int n7 = mappedByteBuffer.getInt(n2 + n4 + 4);
            byte[] byArray = new byte[n7];
            mappedByteBuffer.position(n6);
            mappedByteBuffer.get(byArray);
            return byArray[60] << 0 & 0xFF | byArray[62] << 8 & 0xFF00 | byArray[56] << 16 & 0xFF0000 | byArray[58] << 24 & 0xFF000000;
        }
        return 0;
    }
}

