/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.BNetLogin.versioning;

import com.javaop.BNetLogin.cdkey.Decode;
import com.javaop.BNetLogin.versioning.CheckRevision;
import com.javaop.BNetLogin.versioning.GameData;
import com.javaop.exceptions.LoginException;
import com.javaop.util.Buffer;
import com.javaop.util.PadString;
import com.javaop.util.RelativeFile;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

public class Game {
    private static GameData gameData = new GameData();
    private String game;

    public Game(String string) throws LoginException {
        this.game = Game.getCodeFromLongName(string);
    }

    private static String getCodeFromLongName(String string) {
        if (string == null) {
            return "";
        }
        string = string.toLowerCase();
        string = string.replace("iiii", "4");
        string = string.replace("iii", "3");
        string = string.replace("ii", "2");
        string = string.replace(" ", "");
        if ((string = string.replace(":", "")).equals("star") || string.equals("rats") || string.equals("starcraft") || string.equals("sc")) {
            return "STAR";
        }
        if (string.equals("sexp") || string.equals("pxes") || string.equals("broodwar") || string.equals("bw")) {
            return "SEXP";
        }
        if (string.equals("w2bn") || string.equals("nb2w") || string.equals("war2") || string.equals("warcraft2") || string.equals("warcraft2bne") || string.equals("wc2")) {
            return "W2BN";
        }
        if (string.equals("d2dv") || string.equals("vd2d") || string.equals("d2") || string.equals("diablo2")) {
            return "D2DV";
        }
        if (string.equals("d2xp") || string.equals("px2d") || string.equals("lod") || string.equals("diablo2lod")) {
            return "D2XP";
        }
        if (string.equals("war3") || string.equals("3raw") || string.equals("warcraft3") || string.equals("warcraft3roc")) {
            return "WAR3";
        }
        if (string.equals("w3xp") || string.equals("px3w") || string.equals("tft") || string.equals("warcraft3tft")) {
            return "W3XP";
        }
        return "";
    }

    public int getVersionByte() {
        return gameData.getVersionByte(this.game);
    }

    public int getVersionHash() {
        return gameData.getVersionHash(this.game);
    }

    public int getGameCode() {
        return this.game.charAt(0) << 24 | this.game.charAt(1) << 16 | this.game.charAt(2) << 8 | this.game.charAt(3) << 0;
    }

    public String getName() {
        return this.game;
    }

    public String getExeInfo() {
        RelativeFile relativeFile = new RelativeFile(gameData.getFiles(this.game)[0]);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(relativeFile.lastModified()));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(relativeFile.getName()).append(" ");
        stringBuffer.append(PadString.padNumber((int)calendar.get(2), (int)2)).append("/");
        stringBuffer.append(PadString.padNumber((int)calendar.get(5), (int)2)).append("/");
        stringBuffer.append(PadString.padNumber((int)(calendar.get(1) % 100), (int)2)).append(" ");
        stringBuffer.append(PadString.padNumber((int)calendar.get(11), (int)2)).append(":");
        stringBuffer.append(PadString.padNumber((int)calendar.get(12), (int)2)).append(":");
        stringBuffer.append(PadString.padNumber((int)calendar.get(13), (int)2)).append(" ");
        stringBuffer.append(relativeFile.length());
        return stringBuffer.toString();
    }

    public int doCheckRevision(byte[] byArray, String string) throws LoginException, IOException {
        return CheckRevision.doCheckRevision(string, gameData.getFiles(this.game), byArray);
    }

    public static Vector<String> getGames() {
        Vector<String> vector = new Vector<String>();
        vector.add("Starcraft");
        vector.add("Brood War");
        vector.add("Warcraft II");
        vector.add("Diablo II");
        vector.add("Diablo II: LoD");
        vector.add("Warcraft III");
        vector.add("Warcraft III: TFT");
        return vector;
    }

    public Buffer getKeyBuffer(String string, String string2, int n, int n2) throws LoginException {
        Buffer buffer = new Buffer();
        if (!gameData.hasTwoKeys(this.game)) {
            buffer.addDWord(1);
            buffer.addDWord(0);
            buffer.add(this.getKeyBlock(string, n, n2));
        } else {
            buffer.addDWord(2);
            buffer.addDWord(0);
            buffer.add(this.getKeyBlock(string, n, n2));
            buffer.add(this.getKeyBlock(string2, n, n2));
        }
        return buffer;
    }

    private Buffer getKeyBlock(String string, int n, int n2) throws LoginException {
        Decode decode = Decode.getDecoder(string);
        int[] nArray = decode.getKeyHash(n, n2);
        Buffer buffer = new Buffer();
        buffer.addDWord(string.length());
        buffer.addDWord(decode.getProduct());
        buffer.addDWord(decode.getVal1());
        buffer.addDWord(0);
        for (int i = 0; i < 5; ++i) {
            buffer.addDWord(nArray[i]);
        }
        return buffer;
    }

    public String toString() {
        return this.game + " (" + this.getExeInfo() + ", Version Hash = 0x" + Integer.toHexString(gameData.getVersionHash(this.game)) + ", Version Byte = 0x" + Integer.toHexString(gameData.getVersionByte(this.game)) + ")";
    }
}

