/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.BNetLogin.versioning;

import com.javaop.BNetLogin.versioning.CheckRevisionResults;
import com.javaop.BNetLogin.versioning.Game;
import com.javaop.callback_interfaces.StaticExposedFunctions;
import com.javaop.exceptions.LoginException;
import com.javaop.util.BnlsPacket;
import com.javaop.util.TimeoutSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class Bnls {
    public static int VersionByte(StaticExposedFunctions staticExposedFunctions, Game game) throws LoginException, IOException {
        String string = staticExposedFunctions.getGlobalSetting("Battle.net Login Plugin", "BNLS Server");
        int n = Integer.parseInt(staticExposedFunctions.getGlobalSettingDefault("JavaOp2", "timeout", "30000"));
        Socket socket = TimeoutSocket.getSocket((String)string, (int)9367, (int)n);
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        BnlsPacket bnlsPacket = new BnlsPacket(16);
        bnlsPacket.addDWord(Bnls.BnlsProductId(game));
        outputStream.write(bnlsPacket.getBytes());
        outputStream.flush();
        bnlsPacket = Bnls.ReadBnlsPacket(inputStream);
        bnlsPacket.removeDWord();
        return bnlsPacket.removeDWord();
    }

    public static CheckRevisionResults CheckRevision(Game game, StaticExposedFunctions staticExposedFunctions, String string, long l, byte[] byArray) throws LoginException, IOException {
        String string2 = staticExposedFunctions.getGlobalSetting("Battle.net Login Plugin", "BNLS Server");
        int n = Integer.parseInt(staticExposedFunctions.getGlobalSettingDefault("JavaOp2", "timeout", "30000"));
        Socket socket = TimeoutSocket.getSocket((String)string2, (int)9367, (int)n);
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        BnlsPacket bnlsPacket = new BnlsPacket(26);
        bnlsPacket.addDWord(Bnls.BnlsProductId(game));
        bnlsPacket.addDWord(0);
        bnlsPacket.addDWord(0);
        bnlsPacket.addLong(l);
        bnlsPacket.addNTString(string);
        bnlsPacket.addNtByteArray(byArray);
        outputStream.write(bnlsPacket.getBytes());
        outputStream.flush();
        bnlsPacket = Bnls.ReadBnlsPacket(inputStream);
        if (bnlsPacket.removeDWord() == 0) {
            throw new LoginException("[BNLS] Check revision failed.");
        }
        int n2 = bnlsPacket.removeDWord();
        int n3 = bnlsPacket.removeDWord();
        byte[] byArray2 = bnlsPacket.removeNtByteArray();
        return new CheckRevisionResults(n2, n3, byArray2);
    }

    private static int BnlsProductId(Game game) throws LoginException {
        if (game.getName().equalsIgnoreCase("STAR")) {
            return 1;
        }
        if (game.getName().equalsIgnoreCase("SEXP")) {
            return 2;
        }
        if (game.getName().equalsIgnoreCase("W2BN")) {
            return 3;
        }
        if (game.getName().equalsIgnoreCase("D2DV")) {
            return 4;
        }
        if (game.getName().equalsIgnoreCase("D2XP")) {
            return 5;
        }
        if (game.getName().equalsIgnoreCase("JSTR")) {
            return 6;
        }
        if (game.getName().equalsIgnoreCase("WAR3")) {
            return 7;
        }
        if (game.getName().equalsIgnoreCase("W3XP")) {
            return 8;
        }
        throw new LoginException("[BNLS] Invalid product: " + game.getName());
    }

    public static boolean isEnabled(StaticExposedFunctions staticExposedFunctions) {
        return staticExposedFunctions.getGlobalSetting("Battle.net Login Plugin", "Enable BNLS").equalsIgnoreCase("true");
    }

    private static BnlsPacket ReadBnlsPacket(InputStream inputStream) throws IOException {
        int n = inputStream.read() | inputStream.read() << 8;
        int n2 = inputStream.read();
        byte[] byArray = new byte[n - 3];
        for (int i = 0; i < n - 3; ++i) {
            byArray[i] = (byte)inputStream.read();
        }
        return new BnlsPacket((byte)n2, byArray);
    }
}

