/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.BNetLogin.password;

import com.javaop.util.BigIntegerEx;
import com.javaop.util.Buffer;
import java.security.MessageDigest;

public class SRP {
    public static final int BIGINT_SIZE = 32;
    public static final int SHA_DIGESTSIZE = 20;
    private static final byte[] generatorRaw = new byte[]{47};
    private static final byte[] modulusRaw = new byte[]{-121, -57, 35, -123, 101, -10, 22, 18, -39, 18, 50, -57, 120, 108, -105, 126, 85, -75, -110, -96, -116, -74, -122, 33, 3, 24, -103, 97, -117, 26, -1, -8};
    private static final byte[] I = new byte[]{108, 14, -105, -19, 10, -7, 107, -85, -79, 88, -119, -21, -117, -70, 37, -92, -16, -116, 1, -8};
    private static final BigIntegerEx N = new BigIntegerEx(1, modulusRaw);
    private static final BigIntegerEx g = new BigIntegerEx(1, generatorRaw);
    private final String username;
    private final String password;
    private final BigIntegerEx a;

    public static void main(String[] stringArray) {
        SRP sRP = new SRP("username", "password");
        byte[] byArray = new byte[32];
        System.out.println("v: " + sRP.get_v(new byte[32]).toString(16));
        System.out.println("A: " + new Buffer(sRP.get_A()));
        System.out.println("u: " + sRP.get_u(byArray).toString(16));
        System.out.println("S: " + new Buffer(sRP.get_S(byArray, byArray)));
        System.out.println("K: " + new Buffer(sRP.get_K(sRP.get_S(byArray, byArray))));
        System.out.println("M1: " + new Buffer(sRP.getM1(byArray, byArray)));
    }

    public SRP(String string, String string2) {
        this.username = string.toUpperCase();
        this.password = string2.toUpperCase();
        this.a = new BigIntegerEx(1, 256);
    }

    public BigIntegerEx get_x(byte[] byArray) {
        MessageDigest messageDigest = this.getSHA1();
        messageDigest.update(this.username.getBytes());
        messageDigest.update(":".getBytes());
        messageDigest.update(this.password.getBytes());
        byte[] byArray2 = messageDigest.digest();
        messageDigest = this.getSHA1();
        messageDigest.update(byArray);
        messageDigest.update(byArray2);
        byArray2 = messageDigest.digest();
        return new BigIntegerEx(1, byArray2);
    }

    public BigIntegerEx get_v(byte[] byArray) {
        return g.modPow(this.get_x(byArray), N);
    }

    public byte[] get_A() {
        return g.modPow(this.a, N).toByteArray();
    }

    public BigIntegerEx get_u(byte[] byArray) {
        byte[] byArray2 = this.getSHA1().digest(byArray);
        byte[] byArray3 = new byte[]{byArray2[3], byArray2[2], byArray2[1], byArray2[0]};
        return new BigIntegerEx(1, byArray3);
    }

    public byte[] get_S(byte[] byArray, byte[] byArray2) {
        BigIntegerEx bigIntegerEx = N.add(new BigIntegerEx(1, byArray2)).subtract(this.get_v(byArray)).mod(N);
        BigIntegerEx bigIntegerEx2 = this.a.add(this.get_u(byArray2).multiply(this.get_x(byArray)));
        return bigIntegerEx.modPow(bigIntegerEx2, N).toByteArray();
    }

    public byte[] get_K(byte[] byArray) {
        byte[] byArray2 = new byte[40];
        byte[] byArray3 = new byte[16];
        byte[] byArray4 = new byte[16];
        for (int i = 0; i < byArray3.length; ++i) {
            byArray3[i] = byArray[i * 2];
            byArray4[i] = byArray[i * 2 + 1];
        }
        byte[] byArray5 = this.getSHA1().digest(byArray3);
        byte[] byArray6 = this.getSHA1().digest(byArray4);
        for (int i = 0; i < byArray5.length; ++i) {
            byArray2[i * 2] = byArray5[i];
            byArray2[i * 2 + 1] = byArray6[i];
        }
        return byArray2;
    }

    public byte[] getM1(byte[] byArray, byte[] byArray2) {
        MessageDigest messageDigest = this.getSHA1();
        messageDigest.update(I);
        messageDigest.update(this.getSHA1().digest(this.username.getBytes()));
        messageDigest.update(byArray);
        messageDigest.update(this.get_A());
        messageDigest.update(byArray2);
        messageDigest.update(this.get_K(this.get_S(byArray, byArray2)));
        return messageDigest.digest();
    }

    public byte[] getM2(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = this.get_A();
        byte[] byArray4 = this.getM1(byArray, byArray2);
        byte[] byArray5 = this.get_K(this.get_S(byArray, byArray2));
        MessageDigest messageDigest = this.getSHA1();
        messageDigest.update(byArray3);
        messageDigest.update(byArray4);
        messageDigest.update(byArray5);
        return messageDigest.digest();
    }

    private MessageDigest getSHA1() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (Exception exception) {
            System.err.println("Apparently SHA-1 isn't installed");
            System.exit(0);
            throw new RuntimeException();
        }
    }
}

