/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.BNetLogin.password;

import com.javaop.util.PadString;

public class IntFromByteArray {
    private boolean littleEndian;
    public static final IntFromByteArray LITTLEENDIAN = new IntFromByteArray(true);
    public static final IntFromByteArray BIGENDIAN = new IntFromByteArray(false);

    public static void main(String[] stringArray) {
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        IntFromByteArray intFromByteArray = new IntFromByteArray(true);
        int[] nArray = intFromByteArray.getIntArray(byArray);
        for (int i = 0; i < nArray.length; ++i) {
            System.out.print(PadString.padHex((int)nArray[i], (int)8) + " ");
        }
    }

    public IntFromByteArray(boolean bl) {
        this.littleEndian = bl;
    }

    public int getInteger(byte[] byArray, int n) {
        if (n + 3 >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException("location = " + n + ", number of bytes = " + byArray.length + " (note: 4 available bytes are needed)");
        }
        int n2 = 0;
        if (this.littleEndian) {
            n2 |= byArray[n++] << 0 & 0xFF;
            n2 |= byArray[n++] << 8 & 0xFF00;
            n2 |= byArray[n++] << 16 & 0xFF0000;
            n2 |= byArray[n++] << 24 & 0xFF000000;
        } else {
            n2 |= byArray[n++] << 24 & 0xFF000000;
            n2 |= byArray[n++] << 16 & 0xFF0000;
            n2 |= byArray[n++] << 8 & 0xFF00;
            n2 |= byArray[n++] << 0 & 0xFF;
        }
        return n2;
    }

    public byte[] insertInteger(byte[] byArray, int n, int n2) {
        if (n + 3 >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException("location = " + n + ", length = " + byArray.length + " - note that we need 4 bytes to insert an int");
        }
        if (this.littleEndian) {
            byArray[n++] = (byte)((n2 & 0xFF) >> 0);
            byArray[n++] = (byte)((n2 & 0xFF00) >> 8);
            byArray[n++] = (byte)((n2 & 0xFF0000) >> 16);
            byArray[n++] = (byte)((n2 & 0xFF000000) >> 24);
        } else {
            byArray[n++] = (byte)((n2 & 0xFF000000) >> 24);
            byArray[n++] = (byte)((n2 & 0xFF0000) >> 16);
            byArray[n++] = (byte)((n2 & 0xFF00) >> 8);
            byArray[n++] = (byte)((n2 & 0xFF) >> 0);
        }
        return byArray;
    }

    public int[] getIntArray(byte[] byArray) {
        int[] nArray = new int[byArray.length / 4];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (this.littleEndian) {
                int n2 = i;
                nArray[n2] = nArray[n2] | byArray[n++] << 0 & 0xFF;
                int n3 = i;
                nArray[n3] = nArray[n3] | byArray[n++] << 8 & 0xFF00;
                int n4 = i;
                nArray[n4] = nArray[n4] | byArray[n++] << 16 & 0xFF0000;
                int n5 = i;
                nArray[n5] = nArray[n5] | byArray[n++] << 24 & 0xFF000000;
                continue;
            }
            int n6 = i;
            nArray[n6] = nArray[n6] | byArray[n++] << 24;
            int n7 = i;
            nArray[n7] = nArray[n7] | byArray[n++] << 16;
            int n8 = i;
            nArray[n8] = nArray[n8] | byArray[n++] << 8;
            int n9 = i;
            nArray[n9] = nArray[n9] | byArray[n++] << 0;
        }
        return nArray;
    }
}

