/*
 * Decompiled with CFR 0.152.
 */
package com.javaop.BNetLogin.packets;

import com.javaop.BNetLogin.password.SRP;
import com.javaop.callback_interfaces.PublicExposedFunctions;
import com.javaop.exceptions.LoginException;
import com.javaop.exceptions.PluginException;
import com.javaop.util.BnetPacket;

public class SrpLogin {
    private SRP srp;
    private SRP accountChangeSrp;
    private byte[] salt;
    private byte[] B;
    private String prefSection = "Battle.net Login Plugin";

    public void checkSidAuthCreateAccount(PublicExposedFunctions publicExposedFunctions, BnetPacket bnetPacket) throws PluginException, LoginException {
        int n = bnetPacket.removeDWord();
        switch (n) {
            case 0: 
            case 6: {
                throw new LoginException("[BNET] NLS Create Account failed: Name is in use");
            }
            case 7: {
                throw new LoginException("[BNET] NLS Create Account failed: Name is not long enough");
            }
            case 8: {
                throw new LoginException("[BNET] NLS Create Account failed: Name contains bad characters");
            }
            case 9: {
                throw new LoginException("[BNET] NLS Create Account failed: Name contains bad words");
            }
            case 10: {
                throw new LoginException("[BNET] NLS Create Account failed: Name needs more alphanumeric characters");
            }
            case 11: {
                throw new LoginException("[BNET] NLS Create Account failed: Name cannot have adjacent puncuation");
            }
            case 12: {
                throw new LoginException("[BNET] NLS Create Account failed: Name has too much puncuation");
            }
        }
        throw new LoginException("[BNET] NLS Create Account failed with an unknown error: " + n);
    }

    public BnetPacket getSidAuthAccountLogon(PublicExposedFunctions publicExposedFunctions) throws LoginException {
        String string = publicExposedFunctions.getLocalSetting("Battle.net Login Plugin", "username");
        String string2 = publicExposedFunctions.getLocalSetting("Battle.net Login Plugin", "password").toLowerCase();
        int n = (Integer)publicExposedFunctions.getLocalVariable((Object)"clientToken");
        int n2 = (Integer)publicExposedFunctions.getLocalVariable((Object)"serverToken");
        if (string == null || string.isEmpty()) {
            throw new LoginException("[BNET] Cannot login because username is null.");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new LoginException("[BNET] Cannot login because password is null.");
        }
        if (n == 0) {
            throw new LoginException("[BNET] Cannot login because client token isn't set. Wtf?");
        }
        if (n2 == 0) {
            throw new LoginException("[BNET] Cannot login because server token isn't set. Wtf?");
        }
        if (this.srp == null) {
            this.srp = new SRP(string, string2);
        }
        BnetPacket bnetPacket = new BnetPacket(83);
        bnetPacket.add(this.srp.get_A());
        bnetPacket.addNTString(string);
        return bnetPacket;
    }

    public BnetPacket getSidAuthAccountLogonProof(PublicExposedFunctions publicExposedFunctions, BnetPacket bnetPacket) throws PluginException, LoginException {
        int n = bnetPacket.removeDWord();
        if (this.srp == null) {
            throw new RuntimeException("[BNET] SID_AUTH_ACCOUNTLOGIN was received without SRP being set up -- this shouldn't happen.");
        }
        switch (n) {
            case 0: {
                this.salt = bnetPacket.removeBytes(32);
                this.B = bnetPacket.removeBytes(32);
                BnetPacket bnetPacket2 = new BnetPacket(84);
                bnetPacket2.add(this.srp.getM1(this.salt, this.B));
                return bnetPacket2;
            }
            case 1: {
                publicExposedFunctions.systemMessage(2, "Account does not exist. Attempting to create.");
                BnetPacket bnetPacket3 = new BnetPacket(82);
                this.salt = this.srp.get_A();
                bnetPacket3.add(this.salt);
                bnetPacket3.add(this.srp.get_v(this.salt).toByteArray());
                bnetPacket3.addNTString(publicExposedFunctions.getLocalSetting(this.prefSection, "username"));
                return bnetPacket3;
            }
            case 5: {
                throw new LoginException("[BNET] Account needs to be upgraded. Please log in with the client.");
            }
        }
        throw new LoginException("[BNET] Login failed with unknown error code: " + n);
    }

    public void checkSidAuthAccountLogonProof(PublicExposedFunctions publicExposedFunctions, BnetPacket bnetPacket) throws PluginException, LoginException {
        int n = bnetPacket.removeDWord();
        switch (n) {
            case 0: 
            case 14: {
                byte[] byArray = bnetPacket.removeBytes(20);
                byte[] byArray2 = this.srp.getM2(this.salt, this.B);
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] == byArray2[i]) continue;
                    throw new LoginException("[BNET] Server failed to provide proof that it knows your password!");
                }
                break;
            }
            case 2: {
                throw new LoginException("[BNET] Login failed: incorrect password.");
            }
            default: {
                throw new LoginException("[BNET] Login failed with unknown error: " + n);
            }
        }
    }

    public BnetPacket getSidAuthAccountChange(PublicExposedFunctions publicExposedFunctions) throws LoginException {
        String string = publicExposedFunctions.getLocalSetting("Battle.net Login Plugin", "username");
        String string2 = publicExposedFunctions.getLocalSetting("Battle.net Login Plugin", "password").toLowerCase();
        if (string == null || string.isEmpty()) {
            throw new LoginException("[BNET] Cannot login because username is null.");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new LoginException("[BNET] Cannot login because password is null.");
        }
        BnetPacket bnetPacket = new BnetPacket(85);
        this.srp = new SRP(string, string2);
        publicExposedFunctions.putLocalVariable((Object)"srp", (Object)this.srp);
        bnetPacket.add(this.srp.get_A());
        bnetPacket.addNTString(publicExposedFunctions.getLocalSetting(this.prefSection, "username"));
        return bnetPacket;
    }

    public BnetPacket getSidAuthAccountChangeProof(PublicExposedFunctions publicExposedFunctions, BnetPacket bnetPacket) throws LoginException {
        int n = bnetPacket.removeDWord();
        if (n == 1) {
            throw new LoginException("[BNET] Account doesn't exist -- create before trying to change password");
        }
        if (n == 5) {
            throw new LoginException("[BNET] Account needs to be upgraded");
        }
        if (n != 0) {
            throw new LoginException("[BNET] Unknown NLS Change Password error code: " + n);
        }
        this.accountChangeSrp = new SRP(publicExposedFunctions.getLocalSetting(this.prefSection, "username"), publicExposedFunctions.getLocalSetting(this.prefSection, "password change"));
        BnetPacket bnetPacket2 = new BnetPacket(86);
        this.salt = bnetPacket.removeBytes(32);
        this.B = bnetPacket.removeBytes(32);
        bnetPacket2.add(this.srp.getM1(this.salt, this.B));
        bnetPacket2.add(this.salt);
        bnetPacket2.add(this.accountChangeSrp.get_v(this.salt).toByteArray());
        return bnetPacket2;
    }

    public void checkSidAuthAccountChangseProof(PublicExposedFunctions publicExposedFunctions, BnetPacket bnetPacket) throws LoginException, PluginException {
        int n = bnetPacket.removeDWord();
        if (n == 2) {
            throw new LoginException("[BNET] Account change failed: invalid old password");
        }
        if (n != 0) {
            throw new LoginException("[BNET] Account change failed: unknown error: " + n);
        }
        byte[] byArray = bnetPacket.removeBytes(20);
        byte[] byArray2 = this.srp.getM2(this.salt, this.B);
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            throw new PluginException("[BNET] Server failed to provide proof that it knows your password!");
        }
        publicExposedFunctions.systemMessage(1, "[BNET] Password successfully changed!");
        publicExposedFunctions.putLocalSetting(this.prefSection, "password", publicExposedFunctions.getLocalSetting(this.prefSection, "password change"));
        publicExposedFunctions.putLocalSetting(this.prefSection, "password change", "");
        this.srp = null;
        this.accountChangeSrp = null;
    }
}

